/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.hardware;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.List;
import javax0.license3j.hardware.Network;

class HashCalculator {
    private final Network.Interface.Selector selector;

    HashCalculator(Network.Interface.Selector selector) {
        this.selector = selector;
    }

    private void updateWithNetworkData(MessageDigest md5, List<Network.Interface.Data> interfaces) {
        for (Network.Interface.Data ni : interfaces) {
            md5.update(ni.name.getBytes(StandardCharsets.UTF_8));
            if (ni.hwAddress == null) continue;
            md5.update(ni.hwAddress);
        }
    }

    void updateWithNetworkData(MessageDigest md5) throws SocketException {
        List<Network.Interface.Data> networkInterfaces = Network.Interface.Data.gatherUsing(this.selector);
        networkInterfaces.sort(Comparator.comparing(a -> a.name));
        this.updateWithNetworkData(md5, networkInterfaces);
    }

    void updateWithHostName(MessageDigest md5) throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        md5.update(hostName.getBytes(StandardCharsets.UTF_8), 0, hostName.getBytes(StandardCharsets.UTF_8).length);
    }

    void updateWithArchitecture(MessageDigest md5) {
        String architectureString = System.getProperty("os.arch");
        md5.update(architectureString.getBytes(StandardCharsets.UTF_8), 0, architectureString.getBytes(StandardCharsets.UTF_8).length);
    }
}

