/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import javax0.license3j.crypto.LicenseKeyPair;
import javax0.license3j.io.IOFormat;

public class KeyPairWriter
implements Closeable {
    private final OutputStream osPrivate;
    private final OutputStream osPublic;

    public KeyPairWriter(OutputStream osPrivate, OutputStream osPublic) {
        this.osPrivate = osPrivate;
        this.osPublic = osPublic;
    }

    public KeyPairWriter(File priv, File publ) throws FileNotFoundException {
        this(new FileOutputStream(priv), new FileOutputStream(publ));
    }

    public KeyPairWriter(String priv, String publ) throws FileNotFoundException {
        this(new File(priv), new File(publ));
    }

    public void write(LicenseKeyPair pair, IOFormat format) throws IOException {
        switch (format) {
            case BINARY: {
                this.osPrivate.write(pair.getPrivate());
                this.osPublic.write(pair.getPublic());
                return;
            }
            case BASE64: {
                this.osPrivate.write(Base64.getEncoder().encode(pair.getPrivate()));
                this.osPublic.write(Base64.getEncoder().encode(pair.getPublic()));
                return;
            }
        }
        throw new IllegalArgumentException("Key format " + (Object)((Object)format) + " is unknown.");
    }

    @Override
    public void close() throws IOException {
        if (this.osPrivate != null) {
            this.osPrivate.close();
        }
        if (this.osPublic != null) {
            this.osPublic.close();
        }
    }
}

