/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pageflow;

import de.cni.client.gui.action.toolbar.SaveAction;
import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.ToolbarWrapper;
import de.cni.common.datamodel.IBusinessObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public abstract class PageController
implements IPageController {
    private static Log log = LogFactory.getLog(PageController.class);
    public static final int SAVE_AND_LEAVE = 0;
    public static final int DONT_SAVE_BUT_LEAVE = 1;
    public static final int ABORT = 2;
    boolean isPopup = false;
    ToolbarWrapper toolbarWrapper = new ToolbarWrapper();

    @Override
    public void setPopupMode() {
        this.isPopup = true;
        this.toolbarWrapper.setActive(false);
    }

    @Override
    public boolean isPopupMode() {
        return this.isPopup;
    }

    @Override
    public void openPage(Composite parent) {
    }

    @Override
    public void closePage() {
    }

    @Override
    public void initializeValue(Object initValue) {
    }

    @Override
    public boolean isDataChanged() {
        return false;
    }

    @Override
    public boolean isDiscardChanges() {
        int answer = this.discardChangesPopup();
        return answer != 2;
    }

    public int discardChangesPopup() {
        int answer = 1;
        try {
            if (this.isDataChanged()) {
                answer = MainApplicationWindow.getInstance().popupTripleQuestion("Daten wurden ge\u00e4ndert. M\u00f6chten Sie die \u00c4nderungen speichern?");
                if (answer == 0) {
                    SaveAction sa = new SaveAction(this);
                    sa.save();
                }
                if (answer == 1) {
                    this.doDiscardChanges();
                }
            }
            return answer;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            return 2;
        }
    }

    @Override
    public boolean preSave() {
        return true;
    }

    @Override
    public boolean isSaveable() {
        return true;
    }

    @Override
    public String getSaveableValidationError() {
        return "";
    }

    protected void doDiscardChanges() {
    }

    @Override
    public IBusinessObject getCurrentBusinessObject() {
        return null;
    }

    public ToolbarWrapper getToolbarWrapper() {
        return this.toolbarWrapper;
    }

    public void setToolbarWrapper(ToolbarWrapper toolbarWrapper) {
        this.toolbarWrapper = toolbarWrapper;
    }

    @Override
    public void terminate() {
    }

    @Override
    public IPageController.PageEditStatus getPageEditStatus() {
        return IPageController.PageEditStatus.disabled;
    }

    @Override
    public String getTitle() {
        return this.getPage().getTitle();
    }
}

