/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pageflow;

import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pageflow.MainController;
import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.pages.analyse.AnalyseController;
import de.cni.client.gui.pages.analyseHerrscher.AnalyseHerrscherController;
import de.cni.client.gui.pages.analyseSchluesselThema.AnalyseSchluesselThemaController;
import de.cni.client.gui.pages.geodaten.GeodatenController;
import de.cni.client.gui.pages.gruppe.GruppeController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.pdffile.PdfFileController;
import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.pages.popuppage.PopupPageController;
import de.cni.client.gui.pages.settings.SettingsController;
import de.cni.client.gui.pages.texte.TexteController;
import de.cni.client.gui.util.PermissionHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class PageFlowController {
    private static Log log = LogFactory.getLog(PageFlowController.class);
    private Hashtable<Page, IPageController> allPages = new Hashtable();
    private List<IPageController> controllerList = new ArrayList<IPageController>();
    private IPageController currentPageController;
    private Page currentPage;
    public static PageFlowController instance = new PageFlowController();

    private PageFlowController() {
    }

    public void initAllPageControllers() throws NamingException {
        long start = System.currentTimeMillis();
        this.allPages.put(Page.main, new MainController());
        this.allPages.put(Page.settings, new SettingsController());
        this.allPages.put(Page.geodaten, new GeodatenController());
        this.allPages.put(Page.personendaten, new PersonendatenController());
        this.allPages.put(Page.gruppe, new GruppeController());
        this.allPages.put(Page.coreAnalyse, new AnalyseController(true));
        this.allPages.put(Page.customAnalyse, new AnalyseController(false));
        this.allPages.put(Page.coreAnalyseHerrscher, new AnalyseHerrscherController(true));
        this.allPages.put(Page.customAnalyseHerrscher, new AnalyseHerrscherController(false));
        this.allPages.put(Page.coreAnalyseSchluesselThema, new AnalyseSchluesselThemaController(true));
        this.allPages.put(Page.customAnalyseSchluesselThema, new AnalyseSchluesselThemaController(false));
        this.allPages.put(Page.coreTexte, new TexteController(true));
        this.allPages.put(Page.customTexte, new TexteController(false));
        this.allPages.put(Page.handbuch, new PdfFileController());
        this.allPages.put(Page.exchangeLicense, new PopupPageController(Page.exchangeLicense));
        this.allPages.put(Page.exportDb, new PopupPageController(Page.exportDb));
        this.allPages.put(Page.importDb, new PopupPageController(Page.importDb));
        this.allPages.put(Page.exportPersonendaten, new PopupPageController(Page.exportPersonendaten));
        this.allPages.put(Page.importPersonendaten, new PopupPageController(Page.importPersonendaten));
        log.debug((Object)("Alle Page Controller instanziiert in  " + (System.currentTimeMillis() - start) + "ms"));
    }

    public Collection<IPageController> getAllPageControllers() {
        return this.allPages.values();
    }

    public IPageController getPage(Page page) {
        return this.allPages.get((Object)page);
    }

    public void nextPage() {
    }

    public void prevPage() {
    }

    public void gotoNewPage(Page page, Object object) {
        if (this.allPages.containsKey((Object)page)) {
            if (!PermissionHandler.getInstance().isPageAllowd(page)) {
                Popup.warning("Sie haben keine Berechtigung diese Seite aufzuschalten.");
                return;
            }
            if (this.currentPageController != null && !this.currentPageController.isDiscardChanges()) {
                return;
            }
            log.debug((Object)"ClearMainComposite");
            MainApplicationWindow mainPage = MainApplicationWindow.getInstance();
            mainPage.clearMainComposite();
            Composite parent = null;
            if (MainApplicationWindow.getInstance() != null) {
                parent = MainApplicationWindow.getInstance().getMainComposite();
            }
            log.debug((Object)("Open New Page: " + page.name));
            this.currentPageController = this.allPages.get((Object)page);
            this.currentPage = page;
            this.setTitle();
            this.currentPageController.initializeValue(object);
            this.currentPageController.openPage(parent);
            if (parent != null) {
                log.debug((Object)"Layout");
                parent.layout();
            }
        } else {
            log.error((Object)("Seite nicht gefunden: " + (Object)((Object)page)));
        }
    }

    public void gotoInvisiblePage(Page page, Object object) {
        if (this.allPages.containsKey((Object)page)) {
            if (!PermissionHandler.getInstance().isPageAllowd(page)) {
                Popup.warning("Sie haben keine Berechtigung, die Aktion durchzuf\u00fchren.");
                return;
            }
            if (this.currentPageController != null && !this.currentPageController.isDiscardChanges()) {
                return;
            }
            Composite parent = null;
            if (MainApplicationWindow.getInstance() != null) {
                parent = MainApplicationWindow.getInstance().getMainComposite();
            }
            log.debug((Object)"Open New invisible Page");
            this.currentPageController = this.allPages.get((Object)page);
            this.currentPageController.initializeValue(object);
            this.currentPageController.openPage(parent);
        } else {
            log.error((Object)("Seite nicht gefunden: " + (Object)((Object)page)));
        }
    }

    public void gotoNewPage(Page page) {
        this.gotoNewPage(page, null);
    }

    public static PageFlowController getInstance() {
        return instance;
    }

    public IPageController getCurrentPageController() {
        return this.currentPageController;
    }

    public void setTitle() {
        if (MainApplicationWindow.getInstance() != null) {
            StringBuffer sb = new StringBuffer(ApplicationProperties.getInstance().getProperty("application.name"));
            sb.append(" (");
            sb.append("Lizenz f\u00fcr " + LicenseHandler.getInstance().getLicensWrapper().getName());
            sb.append(")");
            sb.append(" - ");
            sb.append(this.currentPageController.getTitle());
            if (GlobalData.getInstance().getUserSetting() != null && GlobalData.getInstance().getUserSetting().isTechNames()) {
                sb.append(" - ");
                sb.append(" (");
                sb.append(this.currentPage.toString());
                sb.append(")");
            }
            MainApplicationWindow.getInstance().getShell().setText(sb.toString());
        }
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }
}

