/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.analyseHerrscher;

import de.cni.client.gui.pages.analyseHerrscher.AnalyseHerrscherController;
import de.cni.client.gui.templates.filter.AbstractFilterHeaderTile;
import de.cni.client.gui.templates.filter.IFilterController;
import de.cni.client.gui.util.AstroCombo;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.TextWrapper;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.AnalyseHerrscher;
import de.cni.common.datamodel.admin.CoreAnalyseHerrscher;
import de.cni.common.datamodel.admin.CustomAnalyseHerrscher;
import de.cni.common.exceptions.MappingException;
import javax.naming.NamingException;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class AnalyseHerrscherFilterTile
extends AbstractFilterHeaderTile {
    private Group group;
    private AstroCombo astroCombo;
    private AnalyseHerrscher object;
    private boolean core;
    private ComboWrapper horoskop;
    private ComboWrapper herrscher;
    private ComboWrapper tkz;
    private ComboWrapper haus;
    private TextWrapper textkey;

    protected AnalyseHerrscherFilterTile(IFilterController controller, int[] weights) throws NamingException {
        super(controller, weights, PAGE_FILTER);
        this.core = ((AnalyseHerrscherController)controller).isCore();
    }

    @Override
    public void createGuiFilterElements(Composite parent) throws MappingException {
        this.astroCombo = new AstroCombo(this.core);
        RowLayout filterRowLayout = new RowLayout();
        filterRowLayout.pack = true;
        Composite filterComposite = new Composite(parent, 0);
        filterComposite.setLayout((Layout)filterRowLayout);
        Composite c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Horoskop");
        this.horoskop = this.astroCombo.createHoroskopCombo(this.guiUtil, c, 90);
        c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Herrscher");
        this.herrscher = this.astroCombo.createPlanetenCombo(this.guiUtil, c, 90);
        this.guiUtil.createLabel(c, "Tkz");
        this.tkz = this.astroCombo.createTkzCombo(this.guiUtil, c, 90);
        c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Haus");
        this.haus = this.astroCombo.createHausCombo(this.guiUtil, c, 90);
        this.guiUtil.createLabel(c, "Text-Key");
        this.textkey = this.guiUtil.createText(c, "Text-Key", 0, 200);
    }

    @Override
    public IBusinessObject getPageFilterData() throws MappingException {
        AnalyseHerrscher object = this.core ? new CoreAnalyseHerrscher() : new CustomAnalyseHerrscher();
        object.setHoroskop(this.astroCombo.getValueAsString(this.horoskop));
        object.setHerrscher(this.astroCombo.getValueAsString(this.herrscher));
        object.setTkz(this.astroCombo.getValueAsString(this.tkz));
        object.setHaus(this.astroCombo.getValueAsString(this.haus));
        object.setTextkey(this.textkey.getValue());
        return object;
    }

    @Override
    public void setPageFilterData(IBusinessObject filterObject) throws MappingException {
        AnalyseHerrscher object = (AnalyseHerrscher)filterObject;
        this.astroCombo.setValueAsString(this.horoskop, object.getHoroskop());
        this.astroCombo.setValueAsString(this.herrscher, object.getHerrscher());
        this.astroCombo.setValueAsString(this.tkz, object.getTkz());
        this.astroCombo.setValueAsString(this.haus, object.getHaus());
        this.textkey.setValue(object.getTextkey());
        this.guiUtil.setChanged(false);
    }
}

