/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.main;

import de.cni.client.gui.pageflow.PageFlowController;
import de.cni.client.gui.pages.main.FailureApplicationWindow;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.ClassUtils;
import de.cni.common.core.Converter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.Mappings;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Settings;
import de.cni.common.datamodel.admin.User;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StartApplication {
    private static Log log = LogFactory.getLog(StartApplication.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block13: {
            try {
                log.info((Object)"Programm Start");
                log.info((Object)("Java Version: " + System.getProperty("java.version")));
                log.info((Object)("Working-Directory: " + System.getProperty("user.dir")));
                if (log.isDebugEnabled()) {
                    Properties p = System.getProperties();
                    Enumeration<Object> l1 = p.keys();
                    Iterator<Object> i = p.values().iterator();
                    while (l1.hasMoreElements()) {
                        Object k = l1.nextElement();
                        Object v = i.next();
                        log.debug((Object)("Key=" + k + ", value=" + v));
                    }
                }
                ApplicationProperties.getInstance().initialize();
                Mappings.getInstance().initialize();
                Properties props = ApplicationProperties.getInstance().getProperties();
                User user = new User();
                user.setVorname("Vorname");
                user.setNachname("Nachname");
                user.setLoggedIn(true);
                GlobalData.getInstance().setUser(user);
                GlobalData.getInstance().setAlwaysEnabled(Converter.stringToBoolean(props.getProperty("application.alwaysEnabled")));
                GlobalData.getInstance().setOS(props.getProperty("os"));
                if (!GlobalData.getInstance().getUser().isLoggedIn()) break block13;
                GlobalData.getInstance().recalculateMonitoraufloesung();
                GlobalData.getInstance().setBrand(ApplicationProperties.getInstance().getBrand());
                GlobalData.getInstance().setBrandOpen(ApplicationProperties.getInstance().hasBrand(Brand.OPEN.name()));
                GlobalData.getInstance().setBrandRandolf(ApplicationProperties.getInstance().hasBrand(Brand.RANDOLF.name()));
                SqLiteDatabase db = new SqLiteDatabase();
                db.excecuteDbUpdateIfRequired();
                LicenseHandler licenseHandler = LicenseHandler.getInstance();
                if (!licenseHandler.checkLicense()) {
                    return;
                }
                GlobalData.getInstance().setLizenzart(licenseHandler.getLicensWrapper().getArt());
                try {
                    List<IBusinessObject> boList = db.select(new Settings());
                    if (boList != null && boList.size() > 0) {
                        Settings settings = (Settings)boList.get(0);
                        GlobalData.getInstance().setSettings(settings);
                    }
                }
                catch (Exception e) {
                    GlobalData.getInstance().setSettings(new Settings());
                }
                PageFlowController.getInstance().initAllPageControllers();
                new MainApplicationWindow().run();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    FailureApplicationWindow window = new FailureApplicationWindow();
                    if (!Util.isEmpty(e.getMessage())) {
                        window.setText(e.getMessage());
                    } else {
                        window.setText("Fataler Fehler. " + ClassUtils.getClassName(e.getClass()));
                    }
                    window.setBlockOnOpen(false);
                    window.run();
                }
                finally {
                    log.error((Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        log.info((Object)"Programm Ende");
        System.exit(0);
    }
}

