/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.personendaten;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.popup.filter.PopupGruppe;
import de.cni.client.gui.popup.filter.PopupPersonendatenZusatzfilterDialog;
import de.cni.client.gui.popup.page.PopupPageDialog;
import de.cni.client.gui.templates.filter.AbstractFilterHeaderTile;
import de.cni.client.gui.templates.filter.IFilterController;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.TextWrapper;
import de.cni.common.core.GlobalData;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.datamodel.admin.PersonendatenZusatzfilter;
import javax.naming.NamingException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PersonendatenFilterTile
extends AbstractFilterHeaderTile {
    Group group;
    TextWrapper id;
    TextWrapper vorname;
    TextWrapper nachname;
    TextWrapper geburtsort;
    TextWrapper symptome;
    TextWrapper notiz;
    ComboWrapper gruppe;
    PersonendatenZusatzfilter personendatenZusatzfilter = new PersonendatenZusatzfilter(true);
    ButtonWrapper buttonZusatzfilter;
    ButtonWrapper noFilterButton;
    String[] allGroups = new String[0];
    boolean core = !GlobalData.getInstance().getSettings().isEigeneAnalysetexte();
    Composite filterComposite1 = null;
    Composite filterComposite2 = null;
    IFilterController controller;

    protected PersonendatenFilterTile(IFilterController controller, int[] weights) throws NamingException {
        super(controller, weights, PAGE_FILTER);
        this.controller = controller;
        PopupGruppe p = new PopupGruppe();
        String[] allGroups = p.selectAllGroups(true);
        if (allGroups != null) {
            this.allGroups = allGroups;
        }
    }

    @Override
    public void createGuiFilterElements(Composite parent) {
        Composite main = GuiContainer.newTopComposite(parent, 1);
        this.createGuiFilterElements1(main);
        this.createGuiFilterElements2(main);
        this.enabledIdFilter(true);
    }

    public void createGuiFilterElements1(Composite parent) {
        RowLayout filterRowLayout = new RowLayout();
        filterRowLayout.pack = false;
        Composite filterComposite = new Composite(parent, 0);
        filterComposite.setLayoutData((Object)new GridData());
        filterComposite.setLayout((Layout)filterRowLayout);
        this.filterComposite1 = filterComposite;
        Composite c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Personen-ID");
        this.id = this.guiUtil.createLeftNumberText(c, "", 30, 5);
        this.id.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        c = this.newComposite(filterComposite);
        ButtonWrapper personButton = this.guiUtil.createPushButton(c, "eine Person ausw\u00e4hlen", null);
        personButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Personendaten pd = PersonendatenFilterTile.this.getPersonendaten(null);
                    ((PersonendatenController)PersonendatenFilterTile.this.pageFilterController.getPageController()).search(pd);
                }
                catch (Exception ex) {
                    MainApplicationWindow.getInstance().popupError("technischer Fehler. " + ex.getMessage());
                }
            }
        });
    }

    public void createGuiFilterElements2(Composite parent) {
        RowLayout filterRowLayout = new RowLayout();
        filterRowLayout.pack = false;
        Composite filterComposite = new Composite(parent, 0);
        filterComposite.setLayout((Layout)filterRowLayout);
        filterComposite.setLayoutData((Object)new GridData());
        this.filterComposite2 = filterComposite;
        Composite c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Vorname");
        this.vorname = this.guiUtil.createText(c, "", 180, 40);
        this.vorname.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "Nachname");
        this.nachname = this.guiUtil.createText(c, "", 180, 40);
        this.nachname.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Ort", "Geburts-, Wohn- oder aktueller Ort");
        this.geburtsort = this.guiUtil.createText(c, "Geburts-, Wohn- oder aktueller Ort", 180, 40);
        this.geburtsort.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "Gruppe");
        this.gruppe = this.guiUtil.createCombo(c, this.allGroups, "Gruppe", 180);
        this.gruppe.getWidget().addSelectionListener((SelectionListener)this.filterSelectionListener);
        c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "Symptome");
        this.symptome = this.guiUtil.createText(c, "", 180, 2000);
        this.symptome.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        this.guiUtil.createLabel(c, "Notiz");
        this.notiz = this.guiUtil.createText(c, "", 180, 2000);
        this.notiz.getWidget().addTraverseListener((TraverseListener)this.filterTraverseListener);
        c = this.newComposite(filterComposite);
        this.guiUtil.createLabel(c, "");
        this.buttonZusatzfilter = this.guiUtil.createPushButton(c, "Zusatzfilter", this.personendatenZusatzfilter.isSet() ? Resources.ICON.SMALL_FILTER_RED : Resources.ICON.SMALL_FILTER);
        this.guiUtil.createLabel(c, "");
        this.buttonZusatzfilter.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupPersonendatenZusatzfilterDialog dialog = new PopupPersonendatenZusatzfilterDialog(MainApplicationWindow.getInstance().getShell(), PersonendatenFilterTile.this.personendatenZusatzfilter, PersonendatenFilterTile.this.core);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    PersonendatenZusatzfilter pz = dialog.getValue();
                    if (pz == null || pz.getAnalyse() == null || pz.getAnalyse().size() == 0) {
                        return;
                    }
                    PersonendatenFilterTile.this.personendatenZusatzfilter = pz;
                    PersonendatenFilterTile.this.setColor();
                    PersonendatenFilterTile.this.pageFilterController.search();
                } else if (dialog.getReturnCode() == 2) {
                    PersonendatenFilterTile.this.personendatenZusatzfilter = new PersonendatenZusatzfilter(true);
                    PersonendatenFilterTile.this.setColor();
                    PersonendatenFilterTile.this.pageFilterController.search();
                }
            }
        });
        if (this.noFilterButton != null) {
            this.noFilterButton.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PersonendatenFilterTile.this.personendatenZusatzfilter = null;
                    PersonendatenFilterTile.this.setColor();
                    PersonendatenFilterTile.this.pageFilterController.search();
                }
            });
        }
    }

    private Personendaten getPersonendaten(Personendaten personendaten) {
        PopupPageDialog ppd = new PopupPageDialog(new PersonendatenController(), personendaten, MainApplicationWindow.getInstance().getShell(), PopupPageDialog.Mode.SELECT, null);
        ppd.open();
        if (ppd.getButtonPressedId() == 1) {
            personendaten = (Personendaten)ppd.getBusinessObject();
            return personendaten;
        }
        return null;
    }

    @Override
    public IBusinessObject getPageFilterData() {
        Personendaten object = new Personendaten();
        object.setId(this.id.getIntValue());
        object.setVorname(this.vorname.getValue());
        object.setNachname(this.nachname.getValue());
        object.setGeburtsort(this.geburtsort.getValue());
        object.setSymptome(this.symptome.getValue());
        object.setNotiz(this.notiz.getValue());
        object.setFilterGruppe(this.gruppe.getStringValue());
        object.setPersonendatenZusatzfilter(this.personendatenZusatzfilter);
        return object;
    }

    @Override
    public void setPageFilterData(IBusinessObject filterObject) {
        Personendaten object = (Personendaten)filterObject;
        this.id.setValue(object.getId());
        this.vorname.setValue(object.getVorname());
        this.nachname.setValue(object.getNachname());
        this.geburtsort.setValue(object.getGeburtsort());
        this.symptome.setValue(object.getSymptome());
        this.notiz.setValue(object.getNotiz());
        this.gruppe.setStringValue(object.getFilterGruppe());
        this.personendatenZusatzfilter = null;
        this.setColor();
    }

    @Override
    public void setFocus() {
        this.nachname.setFocus();
    }

    private void setColor() {
        this.buttonZusatzfilter.getWidget().setImage(Resources.getInstance().getImage(this.personendatenZusatzfilter != null && this.personendatenZusatzfilter.isSet() ? Resources.ICON.SMALL_FILTER_RED : Resources.ICON.SMALL_FILTER));
    }

    @Override
    protected boolean isSelectOnClear() {
        return this.pageFilterController.getPageController().isLoadAllDataDuringInitialization();
    }

    @Override
    public void toogle(boolean flag) {
        this.enabledIdFilter(flag);
    }

    public void enabledIdFilter(boolean idFilter) {
        this.filterComposite1.setVisible(!idFilter);
        this.filterComposite2.setVisible(idFilter);
        ((GridData)this.filterComposite1.getLayoutData()).exclude = idFilter;
        ((GridData)this.filterComposite2.getLayoutData()).exclude = !idFilter;
        this.filterComposite1.pack();
        this.filterComposite2.pack();
        this.filterComposite1.getParent().layout(true, true);
        if (idFilter) {
            this.id.setValue(0);
        }
        this.controller.clearFilter();
    }
}

