/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.personendaten;

import de.cni.client.gui.pages.geodaten.GeodatenController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.PersonBefundTableListener;
import de.cni.client.gui.pages.personendaten.PersonGruppeTableListener;
import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.popup.filter.PopupLatLonDialog;
import de.cni.client.gui.popup.page.PopupPageDialog;
import de.cni.client.gui.templates.tableAndDetail.AbstractDetailTile;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.tiles.table.PersonBefundTableController;
import de.cni.client.gui.tiles.table.PersonGruppeTableController;
import de.cni.client.gui.tiles.table.templates.ITableDetailToogleListener;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.LaunchProgram;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.paint.ColorFactory;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.datamodel.GmsKoordinate;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Geodaten;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.validation.PersonendatenValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.joda.time.DateTime;

public class PersonendatenTile
extends AbstractDetailTile {
    private static Log log = LogFactory.getLog(PersonendatenTile.class);
    private Personendaten object;
    private static String tipKontinent = "Kontinent\n\nEU = Europa\nNA = Nord Amerika\nSA = S\u00fcd Amerika\nAS = Asien\nAF = Afrika\nOC=Australien/Ozeanien";
    private static String tipLkz = "L\u00e4ndercode\n\nDE = Deutschland\nCH = Schweiz\nAT = \u00d6sterreich\n\nsiehe: https://laendercode.net/de/countries.html";
    boolean noAutomatismGeburtsort = false;
    boolean noAutomatismWohnort = false;
    boolean noAutomatismAktuellOrt = false;
    boolean noAutomatismWarningImediate = false;
    Group group;
    TextWrapper vorname;
    TextWrapper nachname;
    TextWrapper geburtsdatumLocal;
    TextWrapper geburtszeitLocal;
    TextWrapper geburtsdatumUtc;
    TextWrapper geburtszeitUtc;
    TextWrapper alter;
    TextWrapper geburtsortKontinent;
    TextWrapper geburtsortLkz;
    TextWrapper geburtsortPlz;
    TextWrapper geburtsort;
    TextWrapper longitude;
    TextWrapper latitude;
    TextWrapper longitudeText;
    TextWrapper latitudeText;
    TextWrapper wohnortKontinent;
    TextWrapper wohnortLkz;
    TextWrapper wohnortPlz;
    TextWrapper wohnort;
    TextWrapper wohnortLongitude;
    TextWrapper wohnortLatitude;
    TextWrapper wohnortLongitudeText;
    TextWrapper wohnortLatitudeText;
    TextWrapper aktuellKontinent;
    TextWrapper aktuellLkz;
    TextWrapper aktuellPlz;
    TextWrapper aktuellOrt;
    TextWrapper aktuellLongitude;
    TextWrapper aktuellLatitude;
    TextWrapper aktuellLongitudeText;
    TextWrapper aktuellLatitudeText;
    ButtonWrapper geburtsortButton;
    ButtonWrapper geburtsortGmsButton;
    ButtonWrapper wohnortButton;
    ButtonWrapper wohnortGmsButton;
    ButtonWrapper aktuellButton;
    ButtonWrapper aktuellGmsButton;
    TextWrapper notiz;
    TextWrapper symptome;
    TextWrapper vorgeschichte;
    TextWrapper empfehlung;
    TextWrapper anschrift;
    TextWrapper anrede;
    TextWrapper telefon;
    TextWrapper handy;
    TextWrapper internet;
    TextWrapper email;
    TextWrapper gmtOffset;
    TextWrapper timezoneId;
    TextWrapper url1;
    TextWrapper url2;
    TextWrapper url3;
    TextWrapper kontaktDurch;
    TextWrapper anonymeBezeichnung;
    TextWrapper personBefundText;
    ButtonWrapper gmtOffsetManuell;
    ButtonWrapper internetButton;
    ButtonWrapper emailButton;
    ButtonWrapper url1Button;
    ButtonWrapper url2Button;
    ButtonWrapper url3Button;
    Personendaten backing = new Personendaten();
    Color manuellColor;
    PersonGruppeTableController personGruppeTableController;
    PersonBefundTableController personBefundTableController;
    private CTabFolder tabFolder;
    private CTabItem tabItemStamm;
    private CTabItem tabItemKontakt;
    private CTabItem tabItemInfo;
    private CTabItem tabItemAktuellerOrt;
    private CTabItem tabItemGruppen;
    private CTabItem tabItemBefunde;

    public PersonendatenTile(ITableDetailPageController controller) {
        super(controller);
        this.manuellColor = ColorFactory.getInstance().manuellGuiFlag;
    }

    @Override
    public Composite createContent(Composite parent) {
        Group master = GuiContainer.newFillGroup(parent, "Details", 1, 1);
        master.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ((ITableDetailToogleListener)((Object)PersonendatenTile.this.controller)).tableDetailToogle(null);
            }
        });
        this.tabFolder = GuiContainer.newCTabFolder((Composite)master);
        this.tabItemStamm = new CTabItem(this.tabFolder, 0);
        this.tabItemStamm.setText("Stammdaten");
        Composite tabStamm = GuiContainer.newCTabItemComposite(this.tabFolder, this.tabItemStamm, 3);
        this.tabItemKontakt = new CTabItem(this.tabFolder, 0);
        this.tabItemKontakt.setText("Kontakt-Daten");
        Composite tabKontakt = GuiContainer.newCTabItemComposite(this.tabFolder, this.tabItemKontakt, 3);
        this.tabItemAktuellerOrt = new CTabItem(this.tabFolder, 0);
        this.tabItemAktuellerOrt.setText("aktueller Ort");
        Composite tabAktuellerOrt = GuiContainer.newCTabItemComposite(this.tabFolder, this.tabItemAktuellerOrt, 3);
        this.tabItemGruppen = new CTabItem(this.tabFolder, 0);
        this.tabItemGruppen.setText("Gruppen");
        Composite tabGruppen = GuiContainer.newCTabItemComposite(this.tabFolder, this.tabItemGruppen, 3);
        this.tabItemInfo = new CTabItem(this.tabFolder, 0);
        this.tabItemInfo.setText("Symptome / Notizen");
        Composite tabInfo = GuiContainer.newCTabItemComposite(this.tabFolder, this.tabItemInfo, 3);
        this.tabItemBefunde = new CTabItem(this.tabFolder, 0);
        this.tabItemBefunde.setText("Befunde");
        Composite tabBefunde = GuiContainer.newCTabItemComposite(this.tabFolder, this.tabItemBefunde, 3);
        ScrolledComposite sc = GuiContainer.newScrolledComposite(tabStamm);
        Composite spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        Composite main = GuiContainer.newComposite(spacer, 1, 1, true, 1808);
        this.createContentStammdaten(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        sc = GuiContainer.newScrolledComposite(tabKontakt);
        spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        main = GuiContainer.newComposite(spacer, 1, 1, true, 1808);
        this.createContentKontaktdaten(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        sc = GuiContainer.newScrolledComposite(tabInfo);
        spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        main = GuiContainer.newComposite(spacer, 1, 1, true, 1808);
        this.createContentInfodaten(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        sc = GuiContainer.newScrolledComposite(tabAktuellerOrt);
        spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        main = GuiContainer.newComposite(spacer, 1, 1, true, 1808);
        this.createContentAktuellerOrt(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        sc = GuiContainer.newScrolledComposite(tabGruppen);
        spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        main = GuiContainer.newComposite(spacer, 1, 1, true, 1808);
        this.createContentGruppen(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        sc = GuiContainer.newScrolledComposite(tabBefunde);
        spacer = GuiContainer.newSpacer((Composite)sc, false, 10);
        main = GuiContainer.newComposite(spacer, 1, 1, true, 1808);
        this.createContentBefunde(main);
        GuiContainer.configureScrolledComposite(sc, spacer);
        this.tabFolder.setFocus();
        return parent;
    }

    public Composite createContentStammdaten(Composite parent) {
        Composite left1 = GuiContainer.newComposite(parent, 3, 1);
        this.guiUtil.createLabel(left1, "Vor-/Nachname");
        Composite rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.vorname = this.guiUtil.createText(rc, "", 90, 40);
        this.nachname = this.guiUtil.createText(rc, "", 0, 40);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        String tip = "UTC = Coordinated Universal Time (Weltzeit)";
        this.guiUtil.createLabel(left1, "Geburtsdatum/-Zeit (Ortszeit)", tip);
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.geburtsdatumLocal = this.guiUtil.createText(rc, "Geburtsdatum (mm.tt.yyyy)\nlokale Ortszeit", 90, 10);
        this.geburtszeitLocal = this.guiUtil.createText(rc, "Geburtszeit (hh:mm)\nlokale Ortszeit", 90, 5);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "Geburtsdatum/-Zeit (UTC)", tip);
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.geburtsdatumUtc = this.guiUtil.createText(rc, "Geburtsdatum (mm.tt.yyyy)\n" + tip, 90, 10);
        this.geburtszeitUtc = this.guiUtil.createText(rc, "Geburtszeit (hh:mm)\n" + tip, 90, 5);
        this.guiUtil.disableOneWidget(this.geburtsdatumUtc);
        this.guiUtil.disableOneWidget(this.geburtszeitUtc);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "Zeitzone/GMT");
        rc = this.guiUtil.createRowComposite(left1, 3);
        this.guiUtil.setDefaultSpan(1);
        this.timezoneId = this.guiUtil.createText(rc, "Zeitzone", 90, 40);
        this.gmtOffset = this.guiUtil.createSignedRightNumberTextSpan(rc, "Zeitverschiebung, relativ zur Weltzeit", 30, 5, 1);
        this.gmtOffsetManuell = this.guiUtil.createCheckbox(rc, "Zeitverschiebung manuell einstellen");
        this.guiUtil.disableOneWidget(this.timezoneId);
        this.guiUtil.disableOneWidget(this.gmtOffset);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "Alter");
        this.alter = this.guiUtil.createText(left1, "", 30, 0);
        this.guiUtil.disableOneWidget(this.alter);
        rc = GuiContainer.newComposite(left1, 1, 4);
        Label separator = new Label(rc, 266);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.guiUtil.createLabel(left1, "Kontinent / LKZ / PLZ");
        rc = this.guiUtil.createRowComposite(left1, 3);
        this.guiUtil.setDefaultSpan(1);
        this.geburtsortKontinent = this.guiUtil.createTextSpan(rc, tipKontinent, 20, 10, 1, 0);
        this.geburtsortLkz = this.guiUtil.createTextSpan(rc, tipLkz, 20, 2, 1, 0);
        this.geburtsortPlz = this.guiUtil.createTextSpan(rc, "Postleitzahl", 60, 20, 1, 0);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "Geburtsort");
        this.geburtsort = this.guiUtil.createTextSpan(left1, "", 0, 40, 1, 0);
        this.geburtsortButton = this.guiUtil.createPushButton(left1, "Ort", null);
        this.guiUtil.createLabel(left1, "Breitengrad (Lat.)");
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.latitude = this.guiUtil.createText(rc, "Format: (-)###.####", 90, 11);
        this.latitudeText = this.guiUtil.createText(rc, "", 0, 0);
        this.guiUtil.disableOneWidget(this.latitude);
        this.guiUtil.disableOneWidget(this.latitudeText);
        this.geburtsortGmsButton = this.guiUtil.createPushButton(left1, "Orts-Koordinaten", null);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "L\u00e4ngengrad (Long.)");
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.longitude = this.guiUtil.createText(rc, "Format: (-)###.####", 90, 11);
        this.longitudeText = this.guiUtil.createText(rc, "", 0, 0);
        this.guiUtil.disableOneWidget(this.longitude);
        this.guiUtil.disableOneWidget(this.longitudeText);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        rc = GuiContainer.newComposite(left1, 1, 4);
        separator = new Label(rc, 266);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.guiUtil.createLabel(left1, "Kontinent / LKZ / PLZ");
        rc = this.guiUtil.createRowComposite(left1, 3);
        this.guiUtil.setDefaultSpan(1);
        this.wohnortKontinent = this.guiUtil.createTextSpan(rc, tipKontinent, 20, 10, 1, 0);
        this.wohnortLkz = this.guiUtil.createTextSpan(rc, tipLkz, 20, 2, 1, 0);
        this.wohnortPlz = this.guiUtil.createTextSpan(rc, "Postleitzahl", 60, 20, 1, 0);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "Wohnort");
        this.wohnort = this.guiUtil.createTextSpan(left1, "", 0, 40, 1, 0);
        this.wohnortButton = this.guiUtil.createPushButton(left1, "Wohnort", null);
        this.guiUtil.createLabel(left1, "Breitengrad (Lat.)");
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.wohnortLatitude = this.guiUtil.createText(rc, "Format: (-)###.####", 90, 11);
        this.wohnortLatitudeText = this.guiUtil.createText(rc, "", 0, 0);
        this.guiUtil.disableOneWidget(this.wohnortLatitude);
        this.guiUtil.disableOneWidget(this.wohnortLatitudeText);
        this.wohnortGmsButton = this.guiUtil.createPushButton(left1, "Orts-Koordinaten", null);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "L\u00e4ngengrad (Long.)");
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.wohnortLongitude = this.guiUtil.createText(rc, "Format: (-)###.####", 90, 11);
        this.wohnortLongitudeText = this.guiUtil.createText(rc, "", 0, 0);
        this.guiUtil.disableOneWidget(this.wohnortLongitude);
        this.guiUtil.disableOneWidget(this.wohnortLongitudeText);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.registerNoAutomatismWarning(this.geburtsort, Ortstyp.geburtsort);
        this.registerNoAutomatismWarning(this.wohnort, Ortstyp.wohnort);
        this.geburtsortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String localDate = DateUtil.fixDate(PersonendatenTile.this.geburtsdatumLocal.getValue());
                String localTime = DateUtil.fixTime(PersonendatenTile.this.geburtszeitLocal.getValue());
                if (Util.isEmpty(localDate) || Util.isEmpty(localTime)) {
                    Popup.info("Bitte geben Sie zuerst das Geburtsdatum und die Geburtszeit ein.");
                    return;
                }
                String error = DateUtil.checkDateString(localDate, "Geburtsdatum");
                if (error != null) {
                    Popup.error("Das Geburtsdatum muss zuerst richtig gef\u00fcllt werden. " + error);
                    return;
                }
                error = DateUtil.checkGeburtsdatum(localDate);
                if (error != null) {
                    Popup.error("Das Geburtsdatum muss zuerst richtig gef\u00fcllt werden. " + error);
                    return;
                }
                error = DateUtil.checkTimeString(localTime, "Geburtszeit");
                if (error != null) {
                    Popup.error("Die Geburtszeit muss zuerst richtig gef\u00fcllt werden. " + error);
                    return;
                }
                Geodaten filter = PersonendatenTile.this.getGeodatenFilter(PersonendatenTile.this.geburtsortKontinent.getValue(), PersonendatenTile.this.geburtsortLkz.getValue(), PersonendatenTile.this.geburtsort.getValue());
                filter.setKontinent(GlobalData.getInstance().getSettings().getKontinent());
                filter.setLkz(GlobalData.getInstance().getSettings().getLkz());
                filter.setWebservice(GlobalData.getInstance().getSettings().isWebservice());
                PopupPageDialog ppd = new PopupPageDialog(new GeodatenController(), filter, MainApplicationWindow.getInstance().getShell(), PopupPageDialog.Mode.SELECT, null);
                ppd.open();
                if (ppd.getButtonPressedId() == 0) {
                    return;
                }
                if (ppd.getButtonPressedId() == 2) {
                    PersonendatenTile.this.geburtsortKontinent.setValue("");
                    PersonendatenTile.this.geburtsortLkz.setValue("");
                    PersonendatenTile.this.geburtsortPlz.setValue("");
                    PersonendatenTile.this.geburtsort.setValue("");
                    PersonendatenTile.this.setGeburtsortLatLong("", "");
                    PersonendatenTile.this.setTimezoneAndUtcTime(null);
                    PersonendatenTile.this.setGeburtsortManuell(false);
                    PersonendatenTile.this.noAutomatismGeburtsort = false;
                } else {
                    Geodaten geodaten = (Geodaten)ppd.getBusinessObject();
                    if (geodaten != null) {
                        PersonendatenTile.this.geburtsortKontinent.setValue(geodaten.getKontinent());
                        PersonendatenTile.this.geburtsortLkz.setValue(geodaten.getLkz());
                        PersonendatenTile.this.geburtsortPlz.setValue(geodaten.getPlz());
                        PersonendatenTile.this.geburtsort.setValue(geodaten.getOrt());
                        try {
                            PersonendatenTile.this.setTimezoneAndUtcTime(geodaten.getTimezoneId());
                        }
                        catch (Exception ex) {
                            ErrorHandler.handleError(log, "Unbekannte Zeitzone: " + geodaten.getTimezoneId());
                        }
                        PersonendatenTile.this.setGeburtsortLatLong(geodaten.getLatitude(), geodaten.getLongitude());
                        PersonendatenTile.this.setGeburtsortManuell(false);
                        PersonendatenTile.this.noAutomatismGeburtsort = false;
                    }
                }
                PersonendatenTile.this.refreshBackingFromGui(Ortstyp.geburtsort);
            }
        });
        this.wohnortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Geodaten filter = PersonendatenTile.this.getGeodatenFilter(PersonendatenTile.this.wohnortKontinent.getValue(), PersonendatenTile.this.wohnortLkz.getValue(), PersonendatenTile.this.wohnort.getValue());
                filter.setKontinent(GlobalData.getInstance().getSettings().getKontinent());
                filter.setLkz(GlobalData.getInstance().getSettings().getLkz());
                filter.setWebservice(GlobalData.getInstance().getSettings().isWebservice());
                PopupPageDialog ppd = new PopupPageDialog(new GeodatenController(), filter, MainApplicationWindow.getInstance().getShell(), PopupPageDialog.Mode.SELECT, null);
                ppd.open();
                if (ppd.getButtonPressedId() == 0) {
                    return;
                }
                if (ppd.getButtonPressedId() == 2) {
                    PersonendatenTile.this.wohnortKontinent.setValue("");
                    PersonendatenTile.this.wohnortLkz.setValue("");
                    PersonendatenTile.this.wohnortPlz.setValue("");
                    PersonendatenTile.this.wohnort.setValue("");
                    PersonendatenTile.this.setWohnortLatLong("", "");
                    PersonendatenTile.this.setWohnortManuell(false);
                    PersonendatenTile.this.noAutomatismWohnort = false;
                } else {
                    Geodaten geodaten = (Geodaten)ppd.getBusinessObject();
                    if (geodaten != null) {
                        PersonendatenTile.this.wohnortKontinent.setValue(geodaten.getKontinent());
                        PersonendatenTile.this.wohnortLkz.setValue(geodaten.getLkz());
                        PersonendatenTile.this.wohnortPlz.setValue(geodaten.getPlz());
                        PersonendatenTile.this.wohnort.setValue(geodaten.getOrt());
                        PersonendatenTile.this.setWohnortLatLong(geodaten.getLatitude(), geodaten.getLongitude());
                        PersonendatenTile.this.setWohnortManuell(false);
                        PersonendatenTile.this.noAutomatismWohnort = false;
                    }
                }
                PersonendatenTile.this.refreshBackingFromGui(Ortstyp.wohnort);
            }
        });
        this.geburtsortGmsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupLatLonDialog dialog = new PopupLatLonDialog(MainApplicationWindow.getInstance().getShell(), new GmsKoordinate(), false);
                dialog.open();
                if (dialog.getReturnCode() != 1 && dialog.getReturnCode() != 2) {
                    GmsKoordinate gms = dialog.getBusinessObject();
                    PersonendatenTile.this.setGeburtsortLatLong(gms.getLatitude(), gms.getLongitude());
                    PersonendatenTile.this.setGeburtsortManuell(true);
                    Popup.info("Achtung: Bei der manuellen Eingabe der Ortskoordinaten m\u00fcssen Sie auch die Zeitverschiebung manuell einstellen!");
                }
                PersonendatenTile.this.refreshColorAndEnableFromGui();
            }
        });
        this.wohnortGmsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupLatLonDialog dialog = new PopupLatLonDialog(MainApplicationWindow.getInstance().getShell(), new GmsKoordinate(), false);
                dialog.open();
                if (dialog.getReturnCode() != 1 && dialog.getReturnCode() != 2) {
                    GmsKoordinate gms = dialog.getBusinessObject();
                    PersonendatenTile.this.setWohnortLatLong(gms.getLatitude(), gms.getLongitude());
                    PersonendatenTile.this.setWohnortManuell(true);
                    return;
                }
                PersonendatenTile.this.refreshColorAndEnableFromGui();
            }
        });
        this.gmtOffsetManuell.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PersonendatenTile.this.gmtOffsetManuell.getValue()) {
                    PersonendatenTile.this.guiUtil.enableOneWidget(PersonendatenTile.this.gmtOffset);
                } else {
                    PersonendatenTile.this.guiUtil.disableOneWidget(PersonendatenTile.this.gmtOffset);
                    PersonendatenTile.this.setTimezoneAndUtcTime(PersonendatenTile.this.timezoneId.getValue());
                }
                PersonendatenTile.this.refreshColorAndEnableFromGui();
            }
        });
        this.gmtOffset.getWidget().addListener(16, new Listener(){

            public void handleEvent(Event e) {
                PersonendatenTile.this.setUtcTime(PersonendatenTile.this.gmtOffset.getValue());
            }
        });
        this.gmtOffset.getWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    PersonendatenTile.this.setUtcTime(PersonendatenTile.this.gmtOffset.getValue());
                }
            }
        });
        this.guiUtil.setChanged(false);
        return this.group;
    }

    private void registerNoAutomatismWarning(TextWrapper t, final Ortstyp ortstyp) {
        t.getWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    PersonendatenTile.this.popupNoAutomatismWarning(ortstyp);
                    switch (ortstyp) {
                        case geburtsort: {
                            PersonendatenTile.this.noAutomatismGeburtsort = true;
                            break;
                        }
                        case wohnort: {
                            PersonendatenTile.this.noAutomatismWohnort = true;
                            break;
                        }
                        case aktuellort: {
                            PersonendatenTile.this.noAutomatismAktuellOrt = true;
                        }
                    }
                }
            }
        });
        t.getWidget().addListener(16, new Listener(){

            public void handleEvent(Event event) {
                PersonendatenTile.this.popupNoAutomatismWarning(ortstyp);
                switch (ortstyp) {
                    case geburtsort: {
                        PersonendatenTile.this.noAutomatismGeburtsort = true;
                        break;
                    }
                    case wohnort: {
                        PersonendatenTile.this.noAutomatismWohnort = true;
                        break;
                    }
                    case aktuellort: {
                        PersonendatenTile.this.noAutomatismAktuellOrt = true;
                    }
                }
            }
        });
    }

    private void popupNoAutomatismWarning(Ortstyp ortstyp) {
        if (this.backingDiffers(ortstyp)) {
            if (this.noAutomatismWarningImediate) {
                Popup.warning("Durch manuelle Eingabe werden die Ortskoordinaten\n nicht automatisch angepasst.\n\nVerwenden Sie besser die Auswahlfunktion mit den drei P\u00fcnktchen");
            }
            this.refreshBackingFromGui(ortstyp);
        }
    }

    private void refreshBackingFromGui(Ortstyp ortstyp) {
        if (ortstyp == null) {
            this.backing.setGeburtsort(this.geburtsort.getValue());
            this.backing.setWohnort(this.wohnort.getValue());
            this.backing.setAktuellOrt(this.aktuellOrt.getValue());
            return;
        }
        switch (ortstyp) {
            case geburtsort: {
                this.backing.setGeburtsort(this.geburtsort.getValue());
                break;
            }
            case wohnort: {
                this.backing.setWohnort(this.wohnort.getValue());
                break;
            }
            case aktuellort: {
                this.backing.setAktuellOrt(this.aktuellOrt.getValue());
            }
        }
    }

    private boolean backingDiffers(Ortstyp ortstyp) {
        switch (ortstyp) {
            case geburtsort: {
                return !Util.equals(this.geburtsort.getValue(), this.backing.getGeburtsort());
            }
            case wohnort: {
                return !Util.equals(this.wohnort.getValue(), this.backing.getWohnort());
            }
            case aktuellort: {
                return !Util.equals(this.aktuellOrt.getValue(), this.backing.getAktuellOrt());
            }
        }
        return false;
    }

    public Composite createContentAktuellerOrt(Composite parent) {
        Composite left1 = GuiContainer.newComposite(parent, 3, 1);
        this.guiUtil.createLabel(left1, "Kontinent / LKZ / PLZ");
        Composite rc = this.guiUtil.createRowComposite(left1, 3);
        this.guiUtil.setDefaultSpan(1);
        this.aktuellKontinent = this.guiUtil.createTextSpan(rc, tipKontinent, 20, 10, 1, 0);
        this.aktuellLkz = this.guiUtil.createTextSpan(rc, tipLkz, 20, 2, 1, 0);
        this.aktuellPlz = this.guiUtil.createTextSpan(rc, "Postleitzahl", 60, 20, 1, 0);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "aktueller Ort");
        this.aktuellOrt = this.guiUtil.createTextSpan(left1, "", 0, 40, 1, 0);
        this.aktuellButton = this.guiUtil.createPushButton(left1, "Wohnort", null);
        this.registerNoAutomatismWarning(this.aktuellOrt, Ortstyp.aktuellort);
        this.guiUtil.createLabel(left1, "Breitengrad (Lat.)");
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.aktuellLatitude = this.guiUtil.createText(rc, "Format: (-)###.####", 90, 11);
        this.aktuellLatitudeText = this.guiUtil.createText(rc, "", 0, 0);
        this.guiUtil.disableOneWidget(this.aktuellLatitude);
        this.guiUtil.disableOneWidget(this.aktuellLatitudeText);
        this.aktuellGmsButton = this.guiUtil.createPushButton(left1, "Orts-Koordinaten", null);
        this.guiUtil.setDefaultSpan(2);
        this.guiUtil.createLabel(left1, "L\u00e4ngengrad (Long.)");
        rc = this.guiUtil.createRowComposite(left1, 2);
        this.guiUtil.setDefaultSpan(1);
        this.aktuellLongitude = this.guiUtil.createText(rc, "Format: (-)###.####", 90, 11);
        this.aktuellLongitudeText = this.guiUtil.createText(rc, "", 0, 0);
        this.guiUtil.disableOneWidget(this.aktuellLongitude);
        this.guiUtil.disableOneWidget(this.aktuellLongitudeText);
        this.guiUtil.createDummy(left1);
        this.guiUtil.setDefaultSpan(2);
        this.aktuellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Geodaten filter = PersonendatenTile.this.getGeodatenFilter(PersonendatenTile.this.aktuellKontinent.getValue(), PersonendatenTile.this.aktuellLkz.getValue(), PersonendatenTile.this.aktuellOrt.getValue());
                filter.setKontinent(GlobalData.getInstance().getSettings().getKontinent());
                PopupPageDialog ppd = new PopupPageDialog(new GeodatenController(), filter, MainApplicationWindow.getInstance().getShell(), PopupPageDialog.Mode.SELECT, null);
                ppd.open();
                if (ppd.getButtonPressedId() == 0) {
                    return;
                }
                if (ppd.getButtonPressedId() == 2) {
                    PersonendatenTile.this.aktuellKontinent.setValue("");
                    PersonendatenTile.this.aktuellLkz.setValue("");
                    PersonendatenTile.this.aktuellPlz.setValue("");
                    PersonendatenTile.this.aktuellOrt.setValue("");
                    PersonendatenTile.this.setAktuellLatLong("", "");
                    PersonendatenTile.this.setAktuellManuell(false);
                    PersonendatenTile.this.noAutomatismAktuellOrt = false;
                } else {
                    Geodaten geodaten = (Geodaten)ppd.getBusinessObject();
                    if (geodaten != null) {
                        PersonendatenTile.this.aktuellKontinent.setValue(geodaten.getKontinent());
                        PersonendatenTile.this.aktuellLkz.setValue(geodaten.getLkz());
                        PersonendatenTile.this.aktuellPlz.setValue(geodaten.getPlz());
                        PersonendatenTile.this.aktuellOrt.setValue(geodaten.getOrt());
                        PersonendatenTile.this.setAktuellLatLong(geodaten.getLatitude(), geodaten.getLongitude());
                        PersonendatenTile.this.setAktuellManuell(false);
                        PersonendatenTile.this.noAutomatismAktuellOrt = false;
                    }
                }
                PersonendatenTile.this.refreshBackingFromGui(Ortstyp.aktuellort);
            }
        });
        this.aktuellGmsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupLatLonDialog dialog = new PopupLatLonDialog(MainApplicationWindow.getInstance().getShell(), new GmsKoordinate(), false);
                dialog.open();
                if (dialog.getReturnCode() != 1 && dialog.getReturnCode() != 2) {
                    GmsKoordinate gms = dialog.getBusinessObject();
                    PersonendatenTile.this.setAktuellLatLong(gms.getLatitude(), gms.getLongitude());
                    PersonendatenTile.this.setAktuellManuell(true);
                    return;
                }
                PersonendatenTile.this.refreshColorAndEnableFromGui();
            }
        });
        return left1;
    }

    public Composite createContentKontaktdaten(Composite parent) {
        Composite left1 = GuiContainer.newComposite(parent, 3);
        this.guiUtil.createLabel(left1, "Anschrift");
        this.anschrift = this.guiUtil.createScrollTextBlock(left1, "", 80, 2);
        this.guiUtil.createLabel(left1, "Anrede");
        this.anrede = this.guiUtil.createText(left1, "Anrede im Brief. z.B. Sehr geehrte Frau Mustermann", 0, 40);
        this.guiUtil.createLabel(left1, "Anonyme-Bezeichnung");
        this.anonymeBezeichnung = this.guiUtil.createText(left1, "", 0, 40);
        this.guiUtil.createLabel(left1, "Telefon");
        this.telefon = this.guiUtil.createText(left1, "", 0, 30);
        this.guiUtil.createLabel(left1, "Handy");
        this.handy = this.guiUtil.createText(left1, "", 0, 30);
        this.guiUtil.createLabel(left1, "Internet");
        this.internet = this.guiUtil.createTextSpan(left1, "", 0, 512, 1, 0);
        this.internetButton = this.guiUtil.createPushButton(left1, "Browser \u00f6ffnen", null);
        this.guiUtil.createLabel(left1, "E-Mail");
        this.email = this.guiUtil.createTextSpan(left1, "", 0, 512, 1, 0);
        this.emailButton = this.guiUtil.createPushButton(left1, "E-Mail \u00f6ffnen", null);
        this.guiUtil.createLabel(left1, "URL1");
        this.url1 = this.guiUtil.createTextSpan(left1, "", 0, 512, 1, 0);
        this.url1Button = this.guiUtil.createPushButton(left1, "URL \u00f6ffnen", null);
        this.guiUtil.createLabel(left1, "URL2");
        this.url2 = this.guiUtil.createTextSpan(left1, "", 0, 512, 1, 0);
        this.url2Button = this.guiUtil.createPushButton(left1, "URL \u00f6ffnen", null);
        this.guiUtil.createLabel(left1, "URL3");
        this.url3 = this.guiUtil.createTextSpan(left1, "", 0, 512, 1, 0);
        this.url3Button = this.guiUtil.createPushButton(left1, "URL \u00f6ffnen", null);
        this.guiUtil.createLabel(left1, "Kontakt durch");
        this.kontaktDurch = this.guiUtil.createText(left1, "", 0, 40);
        this.internetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)PersonendatenTile.this.internet.getValue());
            }
        });
        this.emailButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchProgram.openMailWindows(PersonendatenTile.this.email.getValue(), "Nachricht von SignumSemita", "", null);
            }
        });
        this.url1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)PersonendatenTile.this.url1.getValue());
            }
        });
        this.url2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)PersonendatenTile.this.url2.getValue());
            }
        });
        this.url3Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)PersonendatenTile.this.url3.getValue());
            }
        });
        return parent;
    }

    public Composite createContentGruppen(Composite parent) {
        this.personGruppeTableController = new PersonGruppeTableController();
        PersonGruppeTableListener listener = new PersonGruppeTableListener(this.personGruppeTableController, this);
        this.personGruppeTableController.registerListener(listener);
        this.personGruppeTableController.createContent(parent);
        return parent;
    }

    public Composite createContentBefunde(Composite parent) {
        Composite c = GuiContainer.newFillComposite(parent, 1);
        this.personBefundTableController = new PersonBefundTableController((PersonendatenController)this.controller);
        PersonBefundTableListener listener = new PersonBefundTableListener(this.personBefundTableController, this);
        this.personBefundTableController.registerListener(listener);
        this.personBefundTableController.createContent(c);
        this.personBefundText = this.guiUtil.createInfoBlock(c, "Text", 150, 0, 1, true);
        return parent;
    }

    public void setPersonBefundText(String text) {
        this.personBefundText.setValue(text);
    }

    public Composite createContentInfodaten(Composite parent) {
        this.symptome = this.guiUtil.createScrollTextBlock(parent, "Symptome", 30, 1);
        this.vorgeschichte = this.guiUtil.createScrollTextBlock(parent, "Vorgeschichte / Anamnese", 30, 1);
        this.empfehlung = this.guiUtil.createScrollTextBlock(parent, "Empfehlung / Diagnose", 30, 1);
        this.notiz = this.guiUtil.createScrollTextBlock(parent, "pers\u00f6nliche Notizen", 30, 1);
        return parent;
    }

    private Geodaten getGeodatenFilter(String kontinent, String lkz, String ort) {
        Geodaten d = new Geodaten();
        if (Util.isEmpty(lkz) && Util.isEmpty(lkz) && Util.isEmpty(ort)) {
            d.setKontinent(GlobalData.getInstance().getSettings().getKontinent());
            d.setLkz(GlobalData.getInstance().getSettings().getLkz());
        } else {
            d.setKontinent(kontinent);
            d.setLkz(lkz);
            d.setOrt(ort);
        }
        return d;
    }

    @Override
    public Personendaten getData() throws MappingException, CalculationException {
        this.object.setVorname(this.vorname.getValue());
        this.object.setNachname(this.nachname.getValue());
        this.object.setGeburtsort(this.geburtsort.getValue());
        this.object.setGeburtsortKontinent(this.geburtsortKontinent.getValue());
        this.object.setGeburtsortLkz(this.geburtsortLkz.getValue());
        this.object.setGeburtsortPlz(this.geburtsortPlz.getValue());
        this.object.setGeburtsdatumLocal(DateUtil.fixDate(this.geburtsdatumLocal.getValue()));
        this.object.setGeburtsdatumUtc(DateUtil.fixDate(this.geburtsdatumUtc.getValue()));
        this.object.setGeburtszeitLocal(DateUtil.fixTime(this.geburtszeitLocal.getValue()));
        this.object.setGeburtszeitUtc(DateUtil.fixTime(this.geburtszeitUtc.getValue()));
        this.object.setTimezoneId(this.timezoneId.getValue());
        this.object.setGmtOffsetInMinutes(Converter.gmtStringToGmtOffsetInMinutes(this.gmtOffset.getValue()));
        this.object.setGmtOffsetManuell(this.gmtOffsetManuell.getValue());
        this.object.setLongitude(this.longitude.getValue());
        this.object.setLatitude(this.latitude.getValue());
        this.object.setWohnort(this.wohnort.getValue());
        this.object.setWohnortKontinent(this.wohnortKontinent.getValue());
        this.object.setWohnortLkz(this.wohnortLkz.getValue());
        this.object.setWohnortPlz(this.wohnortPlz.getValue());
        this.object.setWohnortLongitude(this.wohnortLongitude.getValue());
        this.object.setWohnortLatitude(this.wohnortLatitude.getValue());
        this.object.setAktuellOrt(this.aktuellOrt.getValue());
        this.object.setAktuellKontinent(this.aktuellKontinent.getValue());
        this.object.setAktuellLkz(this.aktuellLkz.getValue());
        this.object.setAktuellPlz(this.aktuellPlz.getValue());
        this.object.setAktuellLongitude(this.aktuellLongitude.getValue());
        this.object.setAktuellLatitude(this.aktuellLatitude.getValue());
        this.object.setNotiz(this.notiz.getValue());
        this.object.setSymptome(this.symptome.getValue());
        this.object.setVorgeschichte(this.vorgeschichte.getValue());
        this.object.setEmpfehlung(this.empfehlung.getValue());
        this.object.setAnschrift(this.anschrift.getValue());
        this.object.setAnrede(this.anrede.getValue());
        this.object.setTelefon(this.telefon.getValue());
        this.object.setHandy(this.handy.getValue());
        this.object.setInternet(this.internet.getValue());
        this.object.setEmail(this.email.getValue());
        this.object.setUrl1(this.url1.getValue());
        this.object.setUrl2(this.url2.getValue());
        this.object.setUrl3(this.url3.getValue());
        this.object.setKontaktDurch(this.kontaktDurch.getValue());
        this.object.setAnonymeBezeichnung(this.anonymeBezeichnung.getValue());
        return this.object;
    }

    @Override
    public void setData(IBusinessObject businessObject) throws MappingException {
        Personendaten object;
        this.object = object = (Personendaten)businessObject;
        this.vorname.setValue(object.getVorname());
        this.nachname.setValue(object.getNachname());
        this.geburtsort.setValue(object.getGeburtsort());
        this.geburtsortKontinent.setValue(object.getGeburtsortKontinent());
        this.geburtsortLkz.setValue(object.getGeburtsortLkz());
        this.geburtsortPlz.setValue(object.getGeburtsortPlz());
        this.geburtsdatumLocal.setValue(object.getGeburtsdatumLocal());
        this.geburtszeitLocal.setValue(object.getGeburtszeitLocal());
        this.geburtsdatumUtc.setValue(object.getGeburtsdatumUtc());
        this.geburtszeitUtc.setValue(object.getGeburtszeitUtc());
        this.timezoneId.setValue(object.getTimezoneId());
        this.gmtOffset.setValue(Converter.gmtOffsetInMinutesToOffsetString(object.getGmtOffsetInMinutes()));
        this.gmtOffsetManuell.setValue(object.isGmtOffsetManuell());
        this.setGeburtsortLatLong(object.getLatitude(), object.getLongitude());
        this.setAlter(object.getAlter());
        this.aktuellKontinent.setValue(object.getAktuellKontinent());
        this.aktuellLkz.setValue(object.getAktuellLkz());
        this.aktuellPlz.setValue(object.getAktuellPlz());
        this.aktuellOrt.setValue(object.getAktuellOrt());
        this.setAktuellLatLong(object.getAktuellLatitude(), object.getAktuellLongitude());
        this.wohnortKontinent.setValue(object.getWohnortKontinent());
        this.wohnortLkz.setValue(object.getWohnortLkz());
        this.wohnortPlz.setValue(object.getWohnortPlz());
        this.wohnort.setValue(object.getWohnort());
        this.setWohnortLatLong(object.getWohnortLatitude(), object.getWohnortLongitude());
        this.notiz.setValue(object.getNotiz());
        this.symptome.setValue(object.getSymptome());
        this.vorgeschichte.setValue(object.getVorgeschichte());
        this.empfehlung.setValue(object.getEmpfehlung());
        this.anschrift.setValue(object.getAnschrift());
        this.anrede.setValue(object.getAnrede());
        this.telefon.setValue(object.getTelefon());
        this.handy.setValue(object.getHandy());
        this.internet.setValue(object.getInternet());
        this.email.setValue(object.getEmail());
        this.url1.setValue(object.getUrl1());
        this.url2.setValue(object.getUrl2());
        this.url3.setValue(object.getUrl3());
        this.kontaktDurch.setValue(object.getKontaktDurch());
        this.anonymeBezeichnung.setValue(object.getAnonymeBezeichnung());
        this.personGruppeTableController.setObjectList(object.getPersonGruppeList());
        if (object.getPersonGruppeList() != null && object.getPersonGruppeList().size() > 0) {
            this.personGruppeTableController.setSelection(object.getPersonGruppeList().get(0));
        } else {
            this.personGruppeTableController.setSelection(null);
        }
        this.personBefundTableController.setObjectList(object.getPersonBefundList());
        if (object.getPersonBefundList() != null && object.getPersonBefundList().size() > 0) {
            this.personBefundTableController.setSelection(object.getPersonBefundList().get(0));
        } else {
            this.personBefundTableController.setSelection(null);
        }
        this.vorname.setFocus();
        this.refreshBackingFromGui(null);
        this.refreshColorAndEnableFromGui();
        this.guiUtil.setChanged(false);
    }

    private void refreshColorAndEnableFromGui() {
        if (this.gmtOffsetManuell.getValue()) {
            this.gmtOffset.getWidget().setBackground(this.manuellColor);
            this.guiUtil.enableOneWidget(this.gmtOffset);
        } else {
            this.gmtOffset.getWidget().setBackground(null);
            this.guiUtil.disableOneWidget(this.gmtOffset);
        }
        if (this.object.isGeburtsortManuell()) {
            this.geburtsortGmsButton.getWidget().setBackground(this.manuellColor);
            this.latitudeText.getWidget().setBackground(this.manuellColor);
            this.longitudeText.getWidget().setBackground(this.manuellColor);
        } else {
            this.geburtsortGmsButton.getWidget().setBackground(null);
            this.latitudeText.getWidget().setBackground(null);
            this.longitudeText.getWidget().setBackground(null);
        }
        if (this.object.isWohnortManuell()) {
            this.wohnortGmsButton.getWidget().setBackground(this.manuellColor);
            this.wohnortLatitudeText.getWidget().setBackground(this.manuellColor);
            this.wohnortLongitudeText.getWidget().setBackground(this.manuellColor);
        } else {
            this.wohnortGmsButton.getWidget().setBackground(null);
            this.wohnortLatitudeText.getWidget().setBackground(null);
            this.wohnortLongitudeText.getWidget().setBackground(null);
        }
        if (this.object.isAktuellManuell()) {
            this.aktuellGmsButton.getWidget().setBackground(this.manuellColor);
            this.aktuellLatitudeText.getWidget().setBackground(this.manuellColor);
            this.aktuellLongitudeText.getWidget().setBackground(this.manuellColor);
        } else {
            this.aktuellGmsButton.getWidget().setBackground(null);
            this.aktuellLatitudeText.getWidget().setBackground(null);
            this.aktuellLongitudeText.getWidget().setBackground(null);
        }
    }

    private void setAlter(Integer jahre) {
        if (jahre != null) {
            this.alter.setValue(Converter.intToString(jahre));
        } else {
            this.alter.setValue("");
        }
    }

    private void setTimezoneAndUtcTime(String timezoneIdValue) {
        if (!Util.isEmpty(timezoneIdValue)) {
            this.timezoneId.setValue(timezoneIdValue);
            String localDate = DateUtil.fixDate(this.geburtsdatumLocal.getValue());
            String localTime = DateUtil.fixTime(this.geburtszeitLocal.getValue());
            DateTime dt = null;
            if (this.gmtOffsetManuell.getValue()) {
                int offsetInMinutes = Converter.gmtStringToGmtOffsetInMinutes(this.gmtOffset.getValue());
                dt = DateUtil.localString2jodaDateTime(localDate, localTime);
                dt = dt.minusMinutes(offsetInMinutes);
            } else {
                dt = DateUtil.localString2jodaDateTime(localDate, localTime, timezoneIdValue);
                double offset = DateUtil.getTimeZoneOffsetInHours(dt, timezoneIdValue);
                this.gmtOffset.setValue(Converter.gmtOffsetInHoursToOffsetString(offset));
            }
            PersonendatenValidator v = new PersonendatenValidator(GlobalData.getInstance().getBrand());
            String utcDateString = DateUtil.joda2UtcDateString(dt);
            String utcTimeString = DateUtil.joda2UtcHHmmTimeString(dt);
            this.geburtsdatumUtc.setValue(utcDateString);
            this.geburtszeitUtc.setValue(utcTimeString);
        } else {
            this.geburtsdatumUtc.setValue("");
            this.geburtszeitUtc.setValue("");
            this.timezoneId.setValue("");
            if (!this.gmtOffsetManuell.getValue()) {
                this.gmtOffset.setValue("");
            }
        }
    }

    private void setUtcTime(String offsetString) {
        if (this.gmtOffsetManuell.getValue()) {
            String localDate = DateUtil.fixDate(this.geburtsdatumLocal.getValue());
            String localTime = DateUtil.fixTime(this.geburtszeitLocal.getValue());
            DateTime dt = null;
            int offsetInMinutes = Converter.gmtStringToGmtOffsetInMinutes(this.gmtOffset.getValue());
            dt = DateUtil.localString2jodaDateTime(localDate, localTime);
            dt = dt.minusMinutes(offsetInMinutes);
            String utcDateString = DateUtil.joda2UtcDateString(dt);
            String utcTimeString = DateUtil.joda2UtcHHmmTimeString(dt);
            this.geburtsdatumUtc.setValue(utcDateString);
            this.geburtszeitUtc.setValue(utcTimeString);
        }
    }

    private void setGeburtsortLatLong(String lat, String lon) {
        this.latitude.setValue(lat);
        this.longitude.setValue(lon);
        this.latitudeText.setValue(Util.lat2dms(lat));
        this.longitudeText.setValue(Util.lon2dms(lon));
    }

    private void setWohnortLatLong(String lat, String lon) {
        if (Util.isEmpty(lat)) {
            this.wohnortLatitude.setValue("");
            this.wohnortLatitudeText.setValue("");
        } else {
            this.wohnortLatitude.setValue(lat);
            this.wohnortLatitudeText.setValue(Util.lat2dms(lat));
        }
        if (Util.isEmpty(lon)) {
            this.wohnortLongitude.setValue("");
            this.wohnortLongitudeText.setValue("");
        } else {
            this.wohnortLongitude.setValue(lon);
            this.wohnortLongitudeText.setValue(Util.lon2dms(lon));
        }
    }

    private void setAktuellLatLong(String lat, String lon) {
        if (Util.isEmpty(lat)) {
            this.aktuellLatitude.setValue("");
            this.aktuellLatitudeText.setValue("");
        } else {
            this.aktuellLatitude.setValue(lat);
            this.aktuellLatitudeText.setValue(Util.lat2dms(lat));
        }
        if (Util.isEmpty(lon)) {
            this.aktuellLongitude.setValue("");
            this.aktuellLongitudeText.setValue("");
        } else {
            this.aktuellLongitude.setValue(lon);
            this.aktuellLongitudeText.setValue(Util.lon2dms(lon));
        }
    }

    private void setGeburtsortManuell(boolean flag) {
        this.object.setGeburtsortManuell(flag);
        this.refreshColorAndEnableFromGui();
    }

    private void setWohnortManuell(boolean flag) {
        this.object.setWohnortManuell(flag);
        this.refreshColorAndEnableFromGui();
    }

    private void setAktuellManuell(boolean flag) {
        this.object.setAktuellManuell(flag);
        this.refreshColorAndEnableFromGui();
    }

    @Override
    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void checkNoAutomatism() {
        String ort = null;
        if (this.noAutomatismGeburtsort) {
            ort = "Geburtsort";
        }
        if (this.noAutomatismWohnort) {
            ort = Formatter.append(ort, "Wohnort", " und ");
        }
        if (this.noAutomatismAktuellOrt) {
            ort = Formatter.append(ort, "aktueller Ort", " und ");
        }
        if (ort != null) {
            String text = "Durch manuelle Eingabe werden die Ortskoordinaten\n nicht automatisch angepasst.\n\nVerwenden Sie besser die Auswahlfunktion mit den drei P\u00fcnktchen";
            Popup.warning(ort + " wurden manuelle ge\u00e4ndert.\n\n" + text);
            this.refreshBackingFromGui(null);
            this.noAutomatismGeburtsort = false;
            this.noAutomatismWohnort = false;
            this.noAutomatismAktuellOrt = false;
        }
    }

    public static enum Ortstyp {
        geburtsort,
        wohnort,
        aktuellort;

    }
}

