/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.pages.popuppage;

import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.pageflow.PageFlowController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.popup.filter.PopupRadiobuttonDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Datensicherung;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.SaveUserException;
import de.cni.common.io.ExportPersonendaten;
import de.cni.common.io.ImportPersonendaten;
import de.cni.common.io.JsonModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class PopupPageController
implements IPageController {
    private static Log log = LogFactory.getLog(PopupPageController.class);
    String initValue;
    Page page;

    public PopupPageController(Page page) {
        this.page = page;
    }

    @Override
    public void closePage() {
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public IBusinessObject getCurrentBusinessObject() {
        return null;
    }

    @Override
    public IPageController.PageEditStatus getPageEditStatus() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.getPage().getTitle();
    }

    @Override
    public void initializeValue(Object initValue) {
        if (initValue instanceof String) {
            initValue = (String)initValue;
        }
    }

    @Override
    public boolean isDataChanged() {
        return false;
    }

    public int discardChangesPopup() {
        return 1;
    }

    @Override
    public boolean isDiscardChanges() {
        return true;
    }

    public boolean isDiscardChanges(boolean closeApplication) {
        return true;
    }

    @Override
    public boolean isPopupMode() {
        return false;
    }

    @Override
    public void openPage(Composite parent) {
        try {
            if (this.page == Page.importDb) {
                this.datenruecksicherung();
            }
            if (this.page == Page.exportDb) {
                this.datensicherung();
            }
            if (this.page == Page.importPersonendaten) {
                this.importPersonendaten();
            }
            if (this.page == Page.exportPersonendaten) {
                this.exportPersonendaten();
            }
            if (this.page == Page.exchangeLicense) {
                this.exchangeLicense();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
        finally {
            try {
                PageFlowController.getInstance().gotoNewPage(Page.personendaten);
            }
            catch (Exception e) {
                ErrorHandler.handleError(log, e);
            }
        }
    }

    private void datensicherung() {
        Datensicherung.manuelleSicherung();
    }

    private void datenruecksicherung() {
        Datensicherung.manuelleRuecksicherung();
    }

    private void exchangeLicense() {
        try {
            boolean ret = Popup.question("M\u00f6chten Sie wirklich eine neue Lizenz-Datei einspielen?");
            if (!ret) {
                return;
            }
            if (LicenseHandler.getInstance().newLicense()) {
                GlobalData.getInstance().setLizenzart(LicenseHandler.getInstance().getLicensWrapper().getArt());
                Popup.info("Die neue Lizenz wurde eingespielt");
                return;
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public void setPopupMode() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public String getSaveableValidationError() {
        return null;
    }

    @Override
    public boolean isSaveable() {
        return false;
    }

    @Override
    public boolean preSave() {
        return false;
    }

    @Override
    public void save() throws DatabaseException, MappingException, SaveUserException, CalculationException {
    }

    @Override
    public void setFocusOnFilterHeader() {
    }

    private void importPersonendaten() {
        block11: {
            try {
                String ext;
                int index = 0;
                String[] dateiformate = new String[]{"SignumSemita-Format", "CSV-Format"};
                if (dateiformate.length > 1) {
                    PopupRadiobuttonDialog dialog = new PopupRadiobuttonDialog(MainApplicationWindow.getInstance().getShell(), "Dateityp", new String[]{"SignumSemita-Format", "CSV-Format"});
                    dialog.open();
                    if (dialog.getReturnCode() != 0) {
                        return;
                    }
                    index = dialog.getIndex();
                } else {
                    index = 0;
                }
                if (index == 0) {
                    ext = "json";
                    String extName = "SignumSemita-Format";
                    String filename = PopupFileDialog.openFileDialog("Bitte w\u00e4hlen Sie die Datei aus.", "SignumSemita_Personen." + ext, new String[]{"*." + ext}, new String[]{extName});
                    if (Util.isEmpty(filename)) {
                        return;
                    }
                    if (!filename.endsWith("." + ext)) {
                        filename = filename + "." + ext;
                    }
                    JsonModule module = new JsonModule();
                    int n = module.importPersonendaten(filename);
                    Popup.info("Es wurden " + Formatter.reportNumber(n) + " Datens\u00e4tze importiert.");
                    break block11;
                }
                if (index == 1) {
                    ext = "csv";
                    String extName = "SignumSemita-Format";
                    String filename = PopupFileDialog.openFileDialog("Bitte w\u00e4hlen Sie die Datei aus.", "SignumSemita_Personen." + ext, new String[]{"*." + ext}, new String[]{extName});
                    if (Util.isEmpty(filename)) {
                        return;
                    }
                    if (!filename.endsWith("." + ext)) {
                        filename = filename + "." + ext;
                    }
                    String string = ImportPersonendaten.doImport(filename, false);
                    break block11;
                }
                Popup.error("Die ausgew\u00e4hlte Datei hat die falsche Dateiendung.");
                return;
            }
            catch (Exception e) {
                ErrorHandler.handleError(log, e);
            }
        }
    }

    private void exportPersonendaten() {
        try {
            Object exporter;
            String extName;
            String ext;
            int index = 0;
            String[] dateiformate = new String[]{"SignumSemita-Format", "CSV-Format"};
            if (dateiformate.length > 1) {
                PopupRadiobuttonDialog dialog = new PopupRadiobuttonDialog(MainApplicationWindow.getInstance().getShell(), "Dateityp", new String[]{"SignumSemita-Format", "CSV-Format"});
                dialog.open();
                if (dialog.getReturnCode() != 0) {
                    return;
                }
                index = dialog.getIndex();
            } else {
                index = 0;
            }
            String filename = "";
            if (index == 0) {
                ext = "json";
                extName = "SignumSemita-Format";
                filename = PopupFileDialog.openSaveFileDialog("SignumSemita_Personen", new String[]{"*." + ext}, new String[]{extName});
                if (!filename.endsWith("." + ext)) {
                    filename = filename + "." + ext;
                }
            } else if (index == 1) {
                ext = "csv";
                extName = "CSV-Format";
                filename = PopupFileDialog.openSaveFileDialog("SignumSemita_Personen", new String[]{"*." + ext}, new String[]{extName});
                if (!filename.endsWith("." + ext)) {
                    filename = filename + "." + ext;
                }
            }
            if (Util.isEmpty(filename)) {
                return;
            }
            String result = "";
            if (filename.endsWith(".csv")) {
                exporter = new ExportPersonendaten();
                int n = ((ExportPersonendaten)exporter).export(filename);
                Popup.info("Der Export von " + n + " Datens\u00e4tzen war erfolgreich");
                return;
            }
            if (!filename.endsWith(".json")) {
                Popup.error("Die ausgew\u00e4hlte Datei hat die falsche Endung.");
                return;
            }
            exporter = new JsonModule();
            int n = ((JsonModule)exporter).exportPersonendaten(filename);
            Popup.info("Der Export von " + n + " Datens\u00e4tzen war erfolgreich");
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    @Override
    public boolean isLoadAllDataDuringInitialization() {
        return false;
    }
}

