/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupFilterController;
import de.cni.client.gui.popup.filter.PopupFilterTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Resources;
import de.cni.common.datamodel.IBusinessObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FilterDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(FilterDialog.class);
    public static final int ABORT_ID = 0;
    public static final int SELECTED_ID = 1;
    public static final int TRASH_ID = 1;
    public static final int SEARCH_ID = 1;
    public final String ABORT_LABEL = "Abbrechen";
    public final String SELECTED_LABEL = "Ok";
    Image ABORT_IMAGE = Resources.getInstance().getImage(Resources.ICON.SMALL_TERMINATE);
    Image TRASH_IMAGE = Resources.getInstance().getImage(Resources.ICON.BIG_TRASH);
    Image SEARCH_IMAGE = Resources.getInstance().getImage(Resources.ICON.SMALL_SEARCH);
    Image SELECT_IMAGE = Resources.getInstance().getImage(Resources.ICON.SMALL_SELECT_ITEM);
    public PopupFilterController controller;
    private PopupFilterTile filterTile;
    private IBusinessObject filterObject;

    public FilterDialog(PopupFilterController controller, Shell shell, IBusinessObject filterObject) {
        super(shell);
        this.controller = controller;
        this.filterObject = filterObject;
    }

    public void handleShellCloseEvent() {
        this.controller.setData(null);
        super.handleShellCloseEvent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buttonPressed(int buttonId) {
        try {
            this.setReturnCode(buttonId);
            if (buttonId == 1) {
                this.filterObject = this.filterTile.getData();
                if (!this.filterTile.checkFilterCriteria(this.filterObject)) {
                    return;
                }
                IBusinessObject result = this.controller.selectOneRecordFromDB(this.filterObject);
                if (result == null) return;
                this.controller.setData(result);
                this.close();
                return;
            } else {
                this.close();
            }
            return;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Suchkriterium");
        this.setMessage("Bitte geben Sie ein Suchkriterium ein.", 1);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.filterTile = this.controller.createPopupFilterTile();
            this.filterTile.createContent(composite);
            this.filterTile.setData(this.filterObject);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Ok", true);
        this.createButton(parent, 0, "Abbrechen", false);
    }

    public IBusinessObject getData() {
        try {
            return this.filterTile.getData();
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
            return null;
        }
    }

    public void setData(IBusinessObject filterObject) {
        try {
            this.filterTile.setData(filterObject);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
    }
}

