/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.BrowserWrapper;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.calculation.AnalyseAspektElement;
import de.cni.common.calculation.AnalyseElement;
import de.cni.common.calculation.AnalyseResult;
import de.cni.common.calculation.AnalyseSchluesselThemaCalculator;
import de.cni.common.calculation.AnalyseUrsacheElement;
import de.cni.common.calculation.HerrscherResult;
import de.cni.common.calculation.HerrscherResultList;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.TexteHandler;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class PopupAnalyseTile {
    private static Log log = LogFactory.getLog(PopupAnalyseTile.class);
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(1);
    AnalyseResult analyseResult;
    BrowserWrapper beschreibung;
    List<ButtonWrapper> buttonList;
    TexteHandler texteHandler;
    boolean core = !GlobalData.getInstance().getSettings().isEigeneAnalysetexte();
    int stufe = GlobalData.getInstance().getSettings().getStufe1();
    String klasse = "";
    int[] excludeArray = new int[]{0};

    protected PopupAnalyseTile() {
        this.texteHandler = new TexteHandler(this.core, this.klasse, this.stufe);
    }

    protected void createContent(Composite parent, AnalyseResult analyseResult, HerrscherResultList herrscherResultList) throws MappingException {
        List<HerrscherResult> list;
        ButtonWrapper b;
        log.debug((Object)"createContent - Start");
        this.buttonList = new ArrayList<ButtonWrapper>();
        Composite c0 = GuiContainer.newFillComposite(parent, 2);
        Composite c1 = GuiContainer.newAnalyseComposite(c0);
        this.beschreibung = this.guiUtil.createBrowserBlock(c0, "Beschreibung", 0, parent.getShell().getDisplay().getBounds().width / 2, 1, 0);
        String text = "";
        if (!Util.isEmpty(analyseResult.getUeberschrift())) {
            Iterator<AnalyseElement> button = this.guiUtil.createAnalyseButton(c1, analyseResult.getUeberschrift());
            this.buttonList.add((ButtonWrapper)((Object)button));
            ((ButtonWrapper)((Object)button)).addSelectionListener(new AnalyseResultListener(analyseResult));
            text = Formatter.append(text, analyseResult.getUeberschrift(), "\n");
        }
        if (analyseResult.getAnalyseAspektElementList() != null) {
            for (AnalyseAspektElement e : analyseResult.getAnalyseAspektElementList()) {
                b = this.guiUtil.createAnalyseButton(c1, e.toString());
                this.buttonList.add(b);
                b.addSelectionListener(new AnalyseAspektListener(e));
            }
        }
        for (AnalyseElement element : analyseResult.getAnalyseElementList().getListAnalyseElement()) {
            if (element.isWithHeader()) {
                b = this.guiUtil.createAnalyseButton(c1, element.getText1());
                this.buttonList.add(b);
                b.addSelectionListener(new AnalyseUeberschriftListener(element));
            }
            for (AnalyseUrsacheElement e : element.getAnalyseUrsacheElementList()) {
                ButtonWrapper b2 = this.guiUtil.createAnalyseButton(c1, "    * " + e.getText());
                this.buttonList.add(b2);
                b2.addSelectionListener(new AnalyseUrsacheElementListener(e));
            }
        }
        if (analyseResult.isHausFlag() && (list = herrscherResultList.getList(analyseResult.getHaus())) != null) {
            this.guiUtil.createAnalyseText(c1, "Herrscher");
            int i = 0;
            for (HerrscherResult result : list) {
                String buttonText = i++ == 0 ? result.toRandolfString() : "  -->" + result.toRandolfString();
                ButtonWrapper b3 = this.guiUtil.createAnalyseButton(c1, buttonText);
                this.buttonList.add(b3);
                b3.addSelectionListener(new HerrscherResultListener(result));
            }
        }
        log.debug((Object)"createContent - Mitte");
        parent.pack();
        this.beschreibung.setUrlOrValue(this.texteHandler.getText(analyseResult));
        log.debug((Object)"createContent - Ende");
    }

    protected void setData(AnalyseResult analyseRsult) throws MappingException, DatabaseException {
        this.analyseResult = analyseRsult;
    }

    protected AnalyseResult getData() throws MappingException, DatabaseException {
        return null;
    }

    public void enable(boolean flag) {
    }

    protected class HerrscherResultListener
    implements SelectionListener {
        HerrscherResult element;

        public HerrscherResultListener(HerrscherResult element) {
            this.element = element;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            log.debug((Object)"Event: HerrscherResultListener- widgetSelected");
            PopupAnalyseTile.this.beschreibung.setUrlOrValue(PopupAnalyseTile.this.texteHandler.getText(this.element));
        }
    }

    protected class AnalyseUeberschriftListener
    implements SelectionListener {
        AnalyseElement element;

        public AnalyseUeberschriftListener(AnalyseElement element) {
            this.element = element;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            log.debug((Object)"Event: AnalyseUeberschriftListener- widgetSelected");
            PopupAnalyseTile.this.beschreibung.setUrlOrValue(PopupAnalyseTile.this.texteHandler.getText(this.element));
        }
    }

    protected class AnalyseResultListener
    implements SelectionListener {
        AnalyseResult analyseResult;

        public AnalyseResultListener(AnalyseResult analyseResult) {
            this.analyseResult = analyseResult;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            try {
                log.debug((Object)"Event: AnalyseResultListener- widgetSelected");
                String text = PopupAnalyseTile.this.texteHandler.getText(this.analyseResult);
                PopupAnalyseTile.this.beschreibung.setUrlOrValue(text);
                if (this.analyseResult.isHausFlag()) {
                    AnalyseSchluesselThemaCalculator c = new AnalyseSchluesselThemaCalculator();
                    c.calculateHaus(this.analyseResult, PopupAnalyseTile.this.core);
                    return;
                }
            }
            catch (Exception e) {
                ErrorHandler.handleError(log, e);
            }
        }
    }

    protected class AnalyseUrsacheElementListener
    implements SelectionListener {
        AnalyseUrsacheElement element;

        public AnalyseUrsacheElementListener(AnalyseUrsacheElement element) {
            this.element = element;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            boolean stufe = false;
            String klasse = "";
            PopupAnalyseTile.this.beschreibung.setUrlOrValue(PopupAnalyseTile.this.texteHandler.getText(this.element.getAnalyse().getTextkey(), PopupAnalyseTile.this.excludeArray));
        }
    }

    protected class AnalyseAspektListener
    implements SelectionListener {
        AnalyseAspektElement element;

        public AnalyseAspektListener(AnalyseAspektElement element) {
            this.element = element;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            PopupAnalyseTile.this.beschreibung.setUrlOrValue("");
        }
    }
}

