/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupBrowserTile;
import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.core.Util;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupBrowserDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupBrowserDialog.class);
    public static final int OK_ID = 0;
    public static final int PRINT_ID = 1;
    public static final int SAVE_ID = 2;
    PopupBrowserTile tile = null;
    String value;
    String name;
    boolean onlyInfoPopup = false;
    boolean withSaveButton = true;
    int limit = 0;

    public PopupBrowserDialog(Shell parentShell, int limit, String name, String value) {
        super(parentShell);
        this.name = name;
        this.value = value;
        this.tile = new PopupBrowserTile(name);
        this.limit = limit;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Browser");
            this.setMessage("Daten", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.setData(this.value);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            if (buttonId == 2) {
                String data = this.tile.getData();
                String path = PopupFileDialog.openSaveFileDialog(this.name, new String[]{"*.html"}, new String[]{"html"});
                if (!Util.isEmpty(path)) {
                    File file = new File(path);
                    FileUtils.writeStringToFile((File)file, (String)data);
                }
                return;
            }
            if (buttonId == 1) {
                this.value = this.tile.getData();
                this.tile.print();
            }
            this.value = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.value = this.tile.getData();
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public String getBusinessObject() {
        return this.value;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Drucken", false);
        }
        if (this.withSaveButton) {
            this.createButton(parent, 2, "Speichern", false);
        }
        this.createButton(parent, 0, "OK", true);
    }
}

