/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupFilterController;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.MappingException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class PopupFilterTile {
    final int layoutNumColumns = 3;
    protected PopupFilterController controller = null;
    protected IBusinessObject filterObject = null;
    protected Group group = null;
    protected WidgetFactory guiUtil = new WidgetFactory(2);

    protected PopupFilterTile(PopupFilterController controller) {
        this.controller = controller;
    }

    protected final Composite createContent(Composite parent) {
        try {
            this.group = GuiContainer.newGroup(parent, this.controller.getPopupName(), 1, 1);
            GridData data = new GridData(768);
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            Composite c = new Composite((Composite)this.group, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)data);
            this.createFilterContent(c);
            this.createButtons((Composite)this.group);
            return this.group;
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler beim Seitenaufbau. " + e.getMessage());
            return null;
        }
    }

    protected final void createButtons(Composite parent) {
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.pack = false;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)buttonLayout);
        Button clearButton = new Button(composite, 8);
        clearButton.setImage(Resources.getInstance().getImage(Resources.ICON.BIG_TRASH));
        clearButton.setToolTipText("Suchkriterium zur\u00fccksetzen");
        Button selectButton = new Button(composite, 8);
        selectButton.setImage(Resources.getInstance().getImage(Resources.ICON.SMALL_SEARCH));
        selectButton.setToolTipText("Suchen");
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopupFilterTile.this.controller.clearFilter();
            }
        });
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IBusinessObject filterObject;
                    IBusinessObject bo = PopupFilterTile.this.getData();
                    if (PopupFilterTile.this.checkFilterCriteria(bo) && (filterObject = PopupFilterTile.this.controller.selectOneRecordFromDB(bo)) != null) {
                        PopupFilterTile.this.setData(filterObject);
                    }
                }
                catch (Exception ex) {
                    MainApplicationWindow.getInstance().popupError("technischer Fehler. " + ex.getMessage());
                }
            }
        });
    }

    protected boolean checkFilterCriteria(IBusinessObject bo) {
        return true;
    }

    protected abstract void createFilterContent(Composite var1) throws MappingException;

    protected abstract void setData(IBusinessObject var1) throws MappingException;

    protected abstract IBusinessObject getData() throws MappingException;
}

