/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupComboDialog;
import de.cni.client.gui.popup.filter.PopupEditComboDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Gruppe;
import de.cni.common.datamodel.admin.PersonGruppe;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PopupGruppe {
    private static Log log = LogFactory.getLog(PopupGruppe.class);
    Gruppe gruppe = null;
    String[] allGroups = null;
    SqLiteDatabase db = new SqLiteDatabase();
    List<IBusinessObject> gruppeList;

    public String[] selectAllGroups(boolean withEmpty) {
        try {
            if (this.allGroups != null) {
                return this.allGroups;
            }
            Gruppe filter = new Gruppe();
            this.gruppeList = this.db.select(filter);
            int size = this.gruppeList.size();
            if (withEmpty) {
                ++size;
            }
            this.allGroups = new String[size];
            int i = 0;
            if (withEmpty) {
                this.allGroups[i++] = "";
            }
            for (IBusinessObject obj : this.gruppeList) {
                this.allGroups[i++] = ((Gruppe)obj).getName();
            }
            return this.allGroups;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }

    public PersonGruppe getPersonGruppe(Personendaten pd) {
        try {
            this.selectAllGroups(false);
            PopupEditComboDialog dialog = new PopupEditComboDialog(MainApplicationWindow.getInstance().getShell(), "Gruppe", this.allGroups);
            dialog.setEmptyAllowed(false);
            dialog.open();
            int buttonPressed = dialog.getReturnCode();
            if (buttonPressed != 0) {
                return null;
            }
            String value = dialog.getBusinessObject();
            boolean found = false;
            for (IBusinessObject obj : this.gruppeList) {
                Gruppe g = (Gruppe)obj;
                if (!Util.equals(g.getName(), value)) continue;
                found = true;
                this.gruppe = g;
                break;
            }
            if (!found) {
                String title = "Neue Gruppe anlegen";
                String message = "Die Gruppe '" + value + "' gibt es noch nicht. M\u00f6chten Sie die Gruppe anlegen?\n\nDann k\u00f6nnen Sie jetzt noch eine Beschreibung zur Gruppe erfassen.";
                String beschreibung = Popup.valuePopup(title, message, "Beschreibung der Gruppe", "", false, 10);
                if (beschreibung == null) {
                    return null;
                }
                if (beschreibung != null) {
                    this.gruppe = new Gruppe();
                    this.gruppe.setName(value);
                    this.gruppe.setBeschreibung(beschreibung);
                    this.gruppe = (Gruppe)this.db.save(this.gruppe);
                }
            }
            PersonGruppe pg = new PersonGruppe();
            pg.setPersonId(pd.getId());
            pg.setGruppeId(this.gruppe.getId());
            pg.setGruppe(this.gruppe.getName());
            pg.setBeschreibung(this.gruppe.getBeschreibung());
            pg = (PersonGruppe)this.db.save(pg);
            return pg;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }

    public String getGruppe() {
        this.selectAllGroups(false);
        PopupComboDialog dialog = new PopupComboDialog(MainApplicationWindow.getInstance().getShell(), "Gruppe", this.allGroups);
        dialog.setEmptyAllowed(false);
        dialog.open();
        int buttonPressed = dialog.getReturnCode();
        if (buttonPressed != 0) {
            return null;
        }
        String value = dialog.getBusinessObject();
        return value;
    }

    public List<IBusinessObject> getPersonList(String gruppe) {
        try {
            Personendaten filter = new Personendaten();
            filter.setFilterGruppe(gruppe);
            List<IBusinessObject> list = this.db.select(filter);
            return list;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }
}

