/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupLatLonTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.GlobalData;
import de.cni.common.datamodel.GmsKoordinate;
import de.cni.common.validation.IValidator;
import de.cni.common.validation.ValidatorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupLatLonDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupLatLonDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    PopupLatLonTile tile = null;
    GmsKoordinate gms;
    boolean onlyInfoPopup;

    public PopupLatLonDialog(Shell parentShell) {
        this(parentShell, null, false);
    }

    public PopupLatLonDialog(Shell parentShell, GmsKoordinate gms, boolean onlyInfoPopup) {
        super(parentShell);
        this.gms = gms;
        this.onlyInfoPopup = onlyInfoPopup;
        this.tile = new PopupLatLonTile();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Daten erfassen");
            this.setMessage("Bitte erg\u00e4nzen Sie die Daten.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.gms);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.gms = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.gms = this.tile.getData();
                if (!this.validation(this.gms)) {
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    public GmsKoordinate getBusinessObject() {
        return this.gms;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    private boolean validation(GmsKoordinate gms) {
        IValidator v = ValidatorFactory.createValidator(gms, GlobalData.getInstance().getBrand());
        if (!v.isValid(gms)) {
            Popup.warning(v.getErrorText());
            return false;
        }
        return true;
    }
}

