/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.datamodel.GmsKoordinate;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class PopupLatLonTile {
    private static Log log = LogFactory.getLog(PopupLatLonTile.class);
    final int layoutNumColumns = 3;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(2);
    GmsKoordinate gms;
    TextWrapper latitudeGrad;
    TextWrapper latitudeMinuten;
    TextWrapper latitudeSekunden;
    TextWrapper latitudeVorzeichen;
    ButtonWrapper latitudePositiv;
    ButtonWrapper latitudeNegativ;
    TextWrapper longitudeGrad;
    TextWrapper longitudeMinuten;
    TextWrapper longitudeSekunden;
    TextWrapper longitudeVorzeichen;
    ButtonWrapper longitudePositiv;
    ButtonWrapper longitudeNegativ;

    protected PopupLatLonTile() {
    }

    protected void createContent(Composite parent) throws MappingException {
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite c1 = GuiContainer.newComposite(spacer, 5);
        this.guiUtil.setDefaultSpan(1);
        this.guiUtil.createLabel(c1, "Breitengrad (Lat.), G/M/S");
        this.latitudeGrad = this.guiUtil.createLeftNumberText(c1, "Grad", 30, 3);
        this.latitudeMinuten = this.guiUtil.createLeftNumberText(c1, "Minuten", 30, 3);
        this.latitudeSekunden = this.guiUtil.createLeftNumberText(c1, "Sekunden", 30, 3);
        Composite c1a = GuiContainer.newComposite(c1, 2);
        this.latitudePositiv = this.guiUtil.createRadiobox(c1a, "N", "n\u00f6rdliche Breite");
        this.latitudeNegativ = this.guiUtil.createRadiobox(c1a, "S", "s\u00fcdliche Breite");
        this.guiUtil.createLabel(c1, "L\u00e4ngengrad (Long.), G/M/S");
        this.longitudeGrad = this.guiUtil.createLeftNumberText(c1, "Grad", 30, 3);
        this.longitudeMinuten = this.guiUtil.createLeftNumberText(c1, "Minuten", 30, 3);
        this.longitudeSekunden = this.guiUtil.createLeftNumberText(c1, "Sekunden", 30, 3);
        Composite c1b = GuiContainer.newComposite(c1, 2);
        this.longitudePositiv = this.guiUtil.createRadiobox(c1b, "O", "\u00f6stliche L\u00e4nge");
        this.longitudeNegativ = this.guiUtil.createRadiobox(c1b, "W", "westliche L\u00e4nge");
    }

    protected void setData(GmsKoordinate gms) throws MappingException, DatabaseException {
        this.gms = gms;
        this.latitudeGrad.setValue(gms.getLatitudeGrad());
        this.latitudeMinuten.setValue(gms.getLatitudeMinuten());
        this.latitudeSekunden.setValue(gms.getLatitudeSekunden());
        this.latitudePositiv.setValue(!gms.isLatitudeNegativ());
        this.latitudeNegativ.setValue(gms.isLatitudeNegativ());
        this.longitudeGrad.setValue(gms.getLongitudeGrad());
        this.longitudeMinuten.setValue(gms.getLongitudeMinuten());
        this.longitudeSekunden.setValue(gms.getLongitudeSekunden());
        this.longitudePositiv.setValue(!gms.isLongitudeNegativ());
        this.longitudeNegativ.setValue(gms.isLongitudeNegativ());
    }

    protected GmsKoordinate getData() throws MappingException, DatabaseException {
        this.gms.setLatitudeGrad(this.latitudeGrad.getIntValue());
        this.gms.setLatitudeMinuten(this.latitudeMinuten.getIntValue());
        this.gms.setLatitudeSekunden(this.latitudeSekunden.getIntValue());
        this.gms.setLatitudeNegativ(this.latitudeNegativ.getValue());
        this.gms.setLongitudeGrad(this.longitudeGrad.getIntValue());
        this.gms.setLongitudeMinuten(this.longitudeMinuten.getIntValue());
        this.gms.setLongitudeSekunden(this.longitudeSekunden.getIntValue());
        this.gms.setLongitudeNegativ(this.longitudeNegativ.getValue());
        return this.gms;
    }

    public void enable(boolean flag) {
        this.latitudeGrad.getWidget().setEditable(flag);
        this.latitudeMinuten.getWidget().setEditable(flag);
        this.latitudeSekunden.getWidget().setEditable(flag);
        this.latitudePositiv.getWidget().setEnabled(flag);
        this.latitudeNegativ.getWidget().setEnabled(flag);
        this.longitudeGrad.getWidget().setEditable(flag);
        this.longitudeMinuten.getWidget().setEditable(flag);
        this.longitudeSekunden.getWidget().setEditable(flag);
        this.longitudePositiv.getWidget().setEnabled(flag);
        this.longitudeNegativ.getWidget().setEnabled(flag);
    }
}

