/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.PopupPersonendatenAndHausTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.calculation.Horoskop;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupPersonendatenAndHausDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupPersonendatenAndHausDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    private PopupPersonendatenAndHausTile tile = null;
    private boolean onlyInfoPopup;
    ExchangeParameter exchangeParameter;
    Horoskop horoskop;
    Selection selection;

    public PopupPersonendatenAndHausDialog(Shell parentShell, Horoskop horoskop, Selection selection) {
        super(parentShell);
        this.horoskop = horoskop;
        this.selection = selection;
        this.tile = new PopupPersonendatenAndHausTile(selection);
        this.onlyInfoPopup = false;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle(this.horoskop.name + ": zwei Horoskope vergleichen");
            String message = this.selection.isPersonenUndHaus() ? "Bitte w\u00e4hlen Sie zwei Personen aus. Ein Haus kann optional vorgeben werden." : (this.selection.isPersonen() ? "Bitte w\u00e4hlen Sie zwei Personen aus." : "Sie k\u00f6nnen ein Haus ausw\u00e4hlen (optional) oder leer das Feld lassen.");
            this.setMessage(message, 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.exchangeParameter);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.exchangeParameter = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.exchangeParameter = this.tile.getData();
                if (!this.isValid()) {
                    Popup.warning("Sie m\u00fcssen zwei Personen ausw\u00e4hlen!");
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    private boolean isValid() {
        if (!this.selection.isPersonen()) {
            return true;
        }
        return this.exchangeParameter != null && this.exchangeParameter.personendaten1 != null && this.exchangeParameter.personendaten1.getId() != 0 && this.exchangeParameter.personendaten2 != null && this.exchangeParameter.personendaten2.getId() != 0;
    }

    public ExchangeParameter getValue() {
        return this.exchangeParameter;
    }

    public void setValue(ExchangeParameter exchangeParameter) {
        this.exchangeParameter = exchangeParameter;
    }

    public static enum Selection {
        Personen,
        Haus,
        PersonenUndHaus;


        public boolean isPersonen() {
            return this == Personen || this == PersonenUndHaus;
        }

        public boolean isHaus() {
            return this == Haus || this == PersonenUndHaus;
        }

        public boolean isPersonenUndHaus() {
            return this == PersonenUndHaus;
        }
    }
}

