/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.PopupPersonendatenAndHausDialog;
import de.cni.client.gui.popup.page.PopupPageDialog;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class PopupPersonendatenAndHausTile {
    private static Log log = LogFactory.getLog(PopupPersonendatenAndHausTile.class);
    final int layoutNumColumns = 3;
    public ExchangeParameter returnValue = null;
    private TextWrapper person1;
    private TextWrapper person2;
    private ComboWrapper haus;
    private ButtonWrapper person1Button;
    private ButtonWrapper person2Button;
    private PopupPersonendatenAndHausDialog.Selection selection;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(1);

    protected PopupPersonendatenAndHausTile(PopupPersonendatenAndHausDialog.Selection selection) {
        this.selection = selection;
        this.returnValue = new ExchangeParameter();
        this.returnValue.personendaten1 = new Personendaten();
        this.returnValue.personendaten2 = new Personendaten();
    }

    protected void createContent(Composite parent) throws MappingException {
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite c = GuiContainer.newComposite(spacer, 3);
        if (this.selection.isPersonen()) {
            this.guiUtil.createLabel(c, "Person 1");
            this.person1 = this.guiUtil.createText(c, "", 180, 0);
            this.person1Button = this.guiUtil.createPushButton(c, "Person ausw\u00e4hlen", null);
            this.guiUtil.disableOneWidget(this.person1);
            this.guiUtil.createLabel(c, "Person 2");
            this.person2 = this.guiUtil.createText(c, "", 180, 0);
            this.person2Button = this.guiUtil.createPushButton(c, "Person ausw\u00e4hlen", null);
            this.guiUtil.disableOneWidget(this.person2);
        }
        if (this.selection.isHaus()) {
            this.guiUtil.createLabel(c, "Haus");
            this.haus = this.guiUtil.createCombo(c, new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"}, "Haus", 90);
            this.guiUtil.disableOneWidget(this.person2);
        }
        if (this.selection.isPersonen()) {
            this.person1.getWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PopupPersonendatenAndHausTile.this.setPersonendaten1(PopupPersonendatenAndHausTile.this.getPersonendaten(PopupPersonendatenAndHausTile.this.returnValue.personendaten1));
                }
            });
            this.person1.getWidget().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent arg0) {
                    PopupPersonendatenAndHausTile.this.setPersonendaten1(PopupPersonendatenAndHausTile.this.getPersonendaten(PopupPersonendatenAndHausTile.this.returnValue.personendaten1));
                }
            });
            this.person2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PopupPersonendatenAndHausTile.this.setPersonendaten2(PopupPersonendatenAndHausTile.this.getPersonendaten(PopupPersonendatenAndHausTile.this.returnValue.personendaten2));
                }
            });
            this.person2.getWidget().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent arg0) {
                    PopupPersonendatenAndHausTile.this.setPersonendaten2(PopupPersonendatenAndHausTile.this.getPersonendaten(PopupPersonendatenAndHausTile.this.returnValue.personendaten2));
                }
            });
        }
    }

    private Personendaten getPersonendaten(Personendaten personendaten) {
        PopupPageDialog ppd = new PopupPageDialog(new PersonendatenController(), personendaten, MainApplicationWindow.getInstance().getShell(), PopupPageDialog.Mode.SELECT, null);
        ppd.open();
        if (ppd.getButtonPressedId() == 1) {
            personendaten = (Personendaten)ppd.getBusinessObject();
            return personendaten;
        }
        return null;
    }

    private void setPersonendaten1(Personendaten p) {
        if (!this.selection.isPersonen()) {
            return;
        }
        if (p == null || p.getId() == 0) {
            this.person1.setValue("");
            this.returnValue.personendaten1 = null;
        } else {
            this.person1.setValue(Formatter.append(p.getVorname(), p.getNachname(), " "));
            this.returnValue.personendaten1 = p;
        }
    }

    private void setPersonendaten2(Personendaten p) {
        if (!this.selection.isPersonen()) {
            return;
        }
        if (p == null || p.getId() == 0) {
            this.person2.setValue("");
            this.returnValue.personendaten2 = null;
        } else {
            this.person2.setValue(Formatter.append(p.getVorname(), p.getNachname(), " "));
            this.returnValue.personendaten2 = p;
        }
    }

    protected void setData(ExchangeParameter returnValue) throws MappingException {
        this.returnValue = returnValue;
        if (this.selection.isPersonen()) {
            this.setPersonendaten1(returnValue.personendaten1);
            this.setPersonendaten2(returnValue.personendaten2);
        }
        if (this.selection.isHaus()) {
            this.haus.setValueByText(Converter.intToString(returnValue.haus));
        }
    }

    protected ExchangeParameter getData() throws MappingException {
        if (this.selection.isHaus()) {
            this.returnValue.haus = Converter.stringToInt(this.haus.getStringValue());
        }
        return this.returnValue;
    }

    public void enable(boolean flag) {
        if (this.selection.isPersonen()) {
            if (flag) {
                this.guiUtil.enableOneWidget(this.person1Button);
                this.guiUtil.enableOneWidget(this.person2Button);
            } else {
                this.guiUtil.disableOneWidget(this.person1Button);
                this.guiUtil.disableOneWidget(this.person2Button);
            }
        }
        if (this.selection.isHaus()) {
            if (flag) {
                this.guiUtil.enableOneWidget(this.haus);
            } else {
                this.guiUtil.disableOneWidget(this.haus);
            }
        }
    }
}

