/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.PopupPersonendatenZusatzfilterTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Analyse;
import de.cni.common.datamodel.admin.PersonendatenZusatzfilter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupPersonendatenZusatzfilterDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupPersonendatenZusatzfilterDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    private PopupPersonendatenZusatzfilterTile tile = null;
    private boolean onlyInfoPopup;
    PersonendatenZusatzfilter personendatenZusatzfilter;
    boolean core;

    public PopupPersonendatenZusatzfilterDialog(Shell parentShell, PersonendatenZusatzfilter personendatenZusatzfilter, boolean core) {
        super(parentShell);
        this.tile = new PopupPersonendatenZusatzfilterTile(personendatenZusatzfilter, core);
        this.onlyInfoPopup = false;
        this.personendatenZusatzfilter = personendatenZusatzfilter;
        this.core = core;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Zus\u00e4tzliche Filterkriterien ausw\u00e4hlen");
            this.setMessage("Zus\u00e4tzliche Filterkriterien ausw\u00e4hlen.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.enable(!this.onlyInfoPopup);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.personendatenZusatzfilter = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.personendatenZusatzfilter = this.tile.getData();
                if (!this.isValid()) {
                    return;
                }
                this.close();
            } else if (!this.onlyInfoPopup && buttonId == 2) {
                this.personendatenZusatzfilter = new PersonendatenZusatzfilter(true);
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 2, "Zur\u00fccksetzen", false);
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    private boolean isValid() {
        String fehler = "";
        List<Analyse> list = this.personendatenZusatzfilter.getAnalyse();
        for (int i = 0; i < list.size(); ++i) {
            Analyse a = list.get(i);
            if (a.isValid()) continue;
            fehler = "Zeile " + (i + 1) + " ist ung\u00fcltig.\n";
        }
        if (!Util.isEmpty(fehler)) {
            Popup.infoCourier("Die Eingabe ist nicht g\u00fcltig\n\n" + fehler + "\n" + Analyse.hint());
            return false;
        }
        return true;
    }

    public PersonendatenZusatzfilter getValue() {
        List<Analyse> list = this.personendatenZusatzfilter.getAnalyse();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isEmpty()) continue;
            list.remove(i);
        }
        return this.personendatenZusatzfilter;
    }

    public void setValue(PersonendatenZusatzfilter personendatenZusatzfilter) {
        List<Analyse> list = personendatenZusatzfilter.getAnalyse();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isEmpty()) continue;
            list.remove(i);
        }
        this.personendatenZusatzfilter = personendatenZusatzfilter;
    }
}

