/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.PopupPlanetenzyklusTile;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupPlanetenzyklusDialog
extends TitleAreaDialog {
    private static Log log = LogFactory.getLog(PopupPlanetenzyklusDialog.class);
    public static final int OK_ID = 0;
    public static final int ABORT_ID = 1;
    public static final int EMPTY_ID = 2;
    private PopupPlanetenzyklusTile tile = new PopupPlanetenzyklusTile();
    private boolean onlyInfoPopup = false;
    ExchangeParameter exchangeParameter;

    public PopupPlanetenzyklusDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (!this.onlyInfoPopup) {
            this.setTitle("Planeten-Zyklus");
            this.setMessage("Bitte w\u00e4hlen Sie die Parameter f\u00fcr die Berechnung aus.", 1);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.tile.createContent(composite);
            this.tile.setData(this.exchangeParameter);
            this.tile.enable(!this.onlyInfoPopup);
            this.tile.setData(this.exchangeParameter);
        }
        catch (Exception e) {
            MainApplicationWindow.getInstance().popupError("technischer Fehler. " + e.getMessage());
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.exchangeParameter = null;
            this.setReturnCode(buttonId);
            if (!this.onlyInfoPopup && buttonId == 0) {
                this.exchangeParameter = this.tile.getData();
                if (!this.isValid()) {
                    Popup.warning("Sie m\u00fcssen einen Aspekt und mindestens einen Planeten ausw\u00e4hlen!");
                    return;
                }
                this.close();
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
        if (!this.onlyInfoPopup) {
            this.createButton(parent, 1, "Abbrechen", false);
        }
    }

    private boolean isValid() {
        return this.exchangeParameter != null && this.exchangeParameter.planet1 >= 0 && this.exchangeParameter.planet2 >= 0;
    }

    public ExchangeParameter getValue() {
        return this.exchangeParameter;
    }

    public void setValue(ExchangeParameter exchangeParameter) {
        this.exchangeParameter = exchangeParameter;
    }
}

