/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.Constants;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.TkzGms;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;

public class PopupTkzGmsTile {
    private static Log log = LogFactory.getLog(PopupTkzGmsTile.class);
    final int layoutNumColumns = 3;
    IBusinessObjectVerwaltung<IBusinessObject> bean = null;
    WidgetFactory guiUtil = new WidgetFactory(2);
    TkzGms gms;
    ComboWrapper tkz;
    TextWrapper grad;
    TextWrapper minuten;
    TextWrapper sekunden;
    private String[] tkzArray = new String[Constants.tkz.length + 1];

    protected PopupTkzGmsTile() {
        this.tkzArray[0] = "";
        for (int i = 0; i < Constants.tkz.length; ++i) {
            this.tkzArray[i + 1] = Constants.tkz[i];
        }
    }

    protected void createContent(Composite parent) throws MappingException {
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite c1 = GuiContainer.newComposite(spacer, 5);
        this.guiUtil.setDefaultSpan(1);
        this.guiUtil.createLabel(c1, "Tierkreiszeichen");
        Composite cRow = this.guiUtil.createRowComposite(c1, 1, 4);
        this.tkz = this.guiUtil.createCombo(cRow, this.tkzArray, "Tierkreiszeichen", 180);
        this.guiUtil.createLabel(c1, "rel. Winkel, G/M/S");
        this.grad = this.guiUtil.createLeftNumberText(c1, "Grad", 30, 3);
        this.minuten = this.guiUtil.createLeftNumberText(c1, "Minuten", 30, 3);
        this.sekunden = this.guiUtil.createLeftNumberText(c1, "Sekunden", 30, 3);
    }

    protected void setData(TkzGms gms) throws MappingException, DatabaseException {
        this.gms = gms;
        this.grad.setValue(gms.getGrad());
        this.minuten.setValue(gms.getMinuten());
        this.sekunden.setValue(gms.getSekunden());
        this.tkz.setValueByText(this.tkzArray[gms.getTkzIdx() + 1]);
    }

    protected TkzGms getData() throws MappingException, DatabaseException {
        int g = this.grad.getIntValue();
        int m = this.minuten.getIntValue();
        int s = this.sekunden.getIntValue();
        int tkzIdx = this.tkz.getSelectionIndex();
        this.gms.setGrad(g);
        this.gms.setMinuten(m);
        this.gms.setSekunden(s);
        this.gms.setTkzIdx(tkzIdx - 1);
        return this.gms;
    }

    public void enable(boolean flag) {
        this.grad.getWidget().setEditable(flag);
        this.minuten.getWidget().setEditable(flag);
        this.sekunden.getWidget().setEditable(flag);
    }
}

