/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.filter;

import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.IWrapper;
import de.cni.client.gui.util.LabelWrapper;
import de.cni.client.gui.util.Popup;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.Util;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.ValidationException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class PopupTokenReplacerTile {
    private static Log log = LogFactory.getLog(PopupTokenReplacerTile.class);
    private static int LEN_TEXT = 0;
    final int layoutNumColumns = 3;
    Group group;
    LabelWrapper key;
    TextWrapper value;
    LabelWrapper[] keyArray;
    IWrapper[] valueArray;
    WidgetFactory guiUtil = new WidgetFactory(2);
    Map<String, String> tokenmap;
    String text;

    protected PopupTokenReplacerTile(String text, Map<String, String> tokenmap) {
        this.tokenmap = tokenmap;
        this.text = text;
        this.keyArray = new LabelWrapper[tokenmap.size()];
        this.valueArray = new IWrapper[tokenmap.size()];
    }

    protected void createContent(Composite parent) {
        Composite spacer = GuiContainer.newSpacer(parent);
        Composite c = GuiContainer.newFillComposite(spacer, 3);
        int swtStyle = 578;
        this.guiUtil.createDummy(c);
        this.guiUtil.createDummy(c);
        this.guiUtil.createDummy(c);
        int i = 0;
        for (String keyString : this.tokenmap.keySet()) {
            if (keyString.startsWith("AUSWAHL")) {
                String bezeichnung = "";
                String value = "";
                String[] itemArray = new String[]{""};
                try {
                    String[] tokens = keyString.split(":");
                    bezeichnung = tokens[1];
                    value = tokens[2];
                    itemArray = new String[tokens.length - 3];
                    for (int z = 0; z < tokens.length - 3; ++z) {
                        itemArray[z] = tokens[z + 3];
                    }
                }
                catch (Exception e) {
                    ErrorHandler.handleError(log, "Im Textbaustein ist das Format des Auswahl-Tokens '" + keyString + "' nicht korrekt.");
                }
                this.keyArray[i] = this.guiUtil.createLabel(c, bezeichnung);
                this.keyArray[i].getWidget().setToolTipText(keyString);
                this.valueArray[i] = this.guiUtil.createCombo(c, itemArray, value, LEN_TEXT);
                ((ComboWrapper)this.valueArray[i]).setStringValue(value);
            } else {
                this.keyArray[i] = this.guiUtil.createLabel(c, keyString);
                this.keyArray[i].getWidget().setToolTipText(keyString);
                this.valueArray[i] = this.guiUtil.createText(c, keyString, 0, LEN_TEXT);
                ((TextWrapper)this.valueArray[i]).setValue(this.tokenmap.get(keyString));
            }
            ++i;
        }
        this.guiUtil.createDummy(c);
        this.guiUtil.createDummy(c);
        this.guiUtil.createDummy(c);
        this.guiUtil.setChanged(false);
    }

    protected Map<String, String> getData() throws MappingException, DatabaseException, ValidationException {
        for (int i = 0; i < this.tokenmap.size(); ++i) {
            String value;
            String key = this.keyArray[i].getWidget().getToolTipText();
            if (this.valueArray[i] instanceof TextWrapper) {
                value = ((TextWrapper)this.valueArray[i]).getValue();
                this.tokenmap.put(key, value);
            }
            if (!(this.valueArray[i] instanceof ComboWrapper)) continue;
            value = ((ComboWrapper)this.valueArray[i]).getStringValue();
            if (!Util.equals(value, ((ComboWrapper)this.valueArray[i]).getWidget().getItems())) {
                throw new ValidationException("In der  Auswahlliste " + this.keyArray[i].getWidget().getText() + " wurde noch kein Wert ausgew\u00e4hlt");
            }
            this.tokenmap.put(key, value);
        }
        return this.tokenmap;
    }

    public boolean isValid(Map<String, String> tokenmap) {
        for (String value : tokenmap.values()) {
            if (!Util.isEmpty(value) && !value.contains("%%")) continue;
            Popup.info("Sie haben noch nicht f\u00fcr alle Variablen g\u00fcltige Wert erfasst");
            return false;
        }
        return true;
    }
}

