/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.popup.page;

import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.page.IDoubleClickHandler;
import de.cni.client.gui.templates.tableAndDetail.TableDetailPageController;
import de.cni.client.gui.templates.treeAndDetail.TreeDetailPageController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.validation.popupselection.ISelectionValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PopupPageDialog
extends TitleAreaDialog
implements IDoubleClickHandler {
    private static Log log = LogFactory.getLog(PopupPageDialog.class);
    private int minSizeX;
    private int minSizeY;
    public static final int ABORT_ID = 0;
    public static final int SELECT_ID = 1;
    public static final int EMPTY_ID = 2;
    public static final int INFO_ID = 3;
    public static final int SAVE_ID = 4;
    public final String SELECT_LABEL = "\u00dcbernehmen";
    public final String ABORT_LABEL = "Abbrechen";
    public final String CLOSE_LABEL = "Beenden";
    public final String EMPTY_LABEL = "Keinen";
    public final String INFO_LABEL = "Info";
    public final String SAVE_LABEL = "Speichern";
    private IPageController controller;
    private Object initObject;
    private IBusinessObject businessObject;
    private ISelectionValidator validator;
    int buttonPressedId;
    Mode mode = Mode.SELECT;

    public PopupPageDialog(IPageController controller, Object initObject, Shell shell, Mode mode, ISelectionValidator validator) {
        super(shell);
        this.controller = controller;
        this.initObject = initObject;
        this.validator = validator;
        this.mode = mode;
        controller.setPopupMode();
        if (controller instanceof TableDetailPageController) {
            ((TableDetailPageController)controller).setDoubleClickHandler(this);
        }
        if (controller instanceof TreeDetailPageController) {
            ((TreeDetailPageController)controller).setDoubleClickHandler(this);
        }
    }

    public void setMinSizeX(int minSizeX) {
        this.minSizeX = minSizeX;
    }

    public void setMinSizeY(int minSizeY) {
        this.minSizeY = minSizeY;
    }

    @Override
    public void onDoubleClick(Object object) {
        this.buttonPressed(1);
    }

    protected void buttonPressed(int buttonId) {
        try {
            this.buttonPressedId = buttonId;
            if (buttonId == 1) {
                this.businessObject = this.controller.getCurrentBusinessObject();
                if (this.validator != null && !this.validator.isSelectionValid(this.businessObject)) {
                    MainApplicationWindow.getInstance().popupError(this.validator.getErrorText());
                    return;
                }
            } else if (buttonId == 4) {
                this.controller.save();
                this.businessObject = this.controller.getCurrentBusinessObject();
            }
            this.close();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.controller.getTitle());
        return contents;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        if (this.minSizeX > 0) {
            shellSize.x = this.minSizeX;
        }
        if (this.minSizeY > 0) {
            shellSize.y = this.minSizeY;
        }
        return shellSize;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.controller.initializeValue(this.initObject);
        this.controller.openPage(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.mode == Mode.SELECT) {
            this.createButton(parent, 1, "\u00dcbernehmen", false);
            this.createButton(parent, 2, "Keinen", false);
            this.createButton(parent, 0, "Abbrechen", false);
        } else if (this.mode == Mode.NEW) {
            this.createButton(parent, 4, "Speichern", false);
            this.createButton(parent, 0, "Abbrechen", false);
        } else {
            this.createButton(parent, 0, "Beenden", false);
            this.getButton(0).setFocus();
        }
    }

    public IBusinessObject getBusinessObject() {
        return this.businessObject;
    }

    public void setBusinessObject(IBusinessObject businessObject) {
        this.businessObject = businessObject;
    }

    public int getButtonPressedId() {
        return this.buttonPressedId;
    }

    public static enum Mode {
        SHOW,
        SELECT,
        NEW,
        EDIT,
        SELECT_AND_INFO;

    }
}

