/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.templates.tableAndDetail;

import de.cni.client.calculation.CalculatorFactoryClient;
import de.cni.client.calculation.IBoCalculatorClient;
import de.cni.client.gui.action.toolbar.EditAction;
import de.cni.client.gui.action.toolbar.IEditable;
import de.cni.client.gui.action.toolbar.INewable;
import de.cni.client.gui.action.toolbar.IRefreshable;
import de.cni.client.gui.action.toolbar.ISaveable;
import de.cni.client.gui.action.toolbar.ISearchable;
import de.cni.client.gui.action.toolbar.IUndoable;
import de.cni.client.gui.action.toolbar.NewAction;
import de.cni.client.gui.action.toolbar.RefreshAction;
import de.cni.client.gui.action.toolbar.SaveAction;
import de.cni.client.gui.pageflow.IPageController;
import de.cni.client.gui.pageflow.PageController;
import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.popup.page.IDoubleClickHandler;
import de.cni.client.gui.templates.filter.IFilterController;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPage;
import de.cni.client.gui.templates.tableAndDetail.ITableDetailPageController;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiContainer;
import de.cni.common.core.Brand;
import de.cni.common.core.GlobalData;
import de.cni.common.core.LicenseHandler;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.validation.IValidator;
import de.cni.common.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;

public abstract class TableDetailPageController
extends PageController
implements ITableDetailPageController,
IPageController,
IFilterController,
INewable,
ISaveable,
IEditable,
IRefreshable,
ISearchable,
IUndoable {
    private static Log log = LogFactory.getLog(TableDetailPageController.class);
    protected Object initObject = null;
    protected static boolean DO_LOAD_ALL_DATA_DURING_INITIALIZATION = true;
    protected static boolean DO_NOT_LOAD_ALL_DATA_DURING_INITIALIZATION = false;
    protected static boolean READWRITE_PAGE = true;
    protected static boolean READONLY_PAGE = false;
    protected ITableDetailPage tableDetailPage;
    protected InitialContext context;
    protected List<IBusinessObject> businessObjectList;
    protected IBusinessObject currentFilter;
    protected IBusinessObject currentBusinessObject;
    protected IBusinessObjectVerwaltung<IBusinessObject> bean;
    protected IPageController.PageSelectionStatus pageSelectionStatus;
    protected IPageController.PageEditStatus pageEditStatus;
    protected List<IContributionItem> toolbarItems;
    protected boolean withText = true;
    boolean loadAllDataDuringInitialization;
    boolean processIsActive = false;
    protected IDoubleClickHandler doubleClickHandler;
    protected IValidator validator = null;

    @Override
    public boolean isLoadAllDataDuringInitialization() {
        return this.loadAllDataDuringInitialization;
    }

    protected void addToolbarItem(ActionContributionItem item) {
        this.addToolbarItem(item, false);
    }

    protected void addToolbarItem(LicenseHandler.LicenseType minLicenseType, ActionContributionItem item, boolean withText) {
        if (LicenseHandler.getInstance().isAllowed(minLicenseType)) {
            this.addToolbarItem(item, withText);
        }
    }

    protected void addToolbarItem(ActionContributionItem item, boolean withText) {
        if (this.toolbarItems == null) {
            this.toolbarItems = new ArrayList<IContributionItem>();
        }
        if (withText) {
            item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        }
        this.toolbarItems.add((IContributionItem)item);
    }

    protected void addToolbarItem(Brand brand, ActionContributionItem item) {
        if (GlobalData.getInstance().getBrand() == brand) {
            this.addToolbarItem(item);
        }
    }

    public TableDetailPageController(boolean loadAllDataDuringInitialization) {
        this(loadAllDataDuringInitialization, READWRITE_PAGE);
    }

    public TableDetailPageController(boolean loadAllDataDuringInitialization, boolean writeAllowed) {
        try {
            this.loadAllDataDuringInitialization = loadAllDataDuringInitialization;
            this.toolbarItems = new ArrayList<IContributionItem>();
            if (writeAllowed) {
                this.addToolbarItem(new ActionContributionItem((IAction)new NewAction(this)), this.withText);
                this.addToolbarItem(new ActionContributionItem((IAction)new SaveAction(this)), this.withText);
                if (!GlobalData.getInstance().isAlwaysEnabled()) {
                    this.addToolbarItem(new ActionContributionItem((IAction)new EditAction(this)), this.withText);
                }
            }
            this.addToolbarItem(new ActionContributionItem((IAction)new RefreshAction(this)), this.withText);
            this.pageSelectionStatus = IPageController.PageSelectionStatus.noSelection;
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            this.bean = this.getServerBean();
            log.debug((Object)("TableDetailPageController initialisiert: " + (this.getPage() == null ? "unbekannt" : this.getPage().getName())));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("technischer Fehler. " + e.getMessage()));
        }
    }

    @Override
    public IPageController getPageController() {
        return this;
    }

    @Override
    public void initializeValue(Object initObject) {
        this.businessObjectList = new ArrayList<IBusinessObject>();
        this.currentBusinessObject = initObject != null ? (IBusinessObject)initObject : this.createNewBusinessObject();
        this.initObject = initObject;
        log.debug((Object)"Initiale Werte gesetzt");
    }

    @Override
    public void openPage(Composite parent) {
        this.pageSelectionStatus = IPageController.PageSelectionStatus.noSelection;
        this.pageEditStatus = IPageController.PageEditStatus.disabled;
        this.tableDetailPage = this.createNewTableDetailPage(this);
        this.tableDetailPage.createContent(parent);
        this.getToolbarWrapper().initialize(MainApplicationWindow.getInstance().getToolBarManager());
        this.getToolbarWrapper().setToolbar(this.toolbarItems);
        this.businessObjectList = new ArrayList<IBusinessObject>();
        this.tableDetailPage.setData(this.businessObjectList);
        if (this.initObject != null) {
            this.tableDetailPage.setFilter((IBusinessObject)this.initObject);
        }
        if (this.loadAllDataDuringInitialization || this.initObject != null) {
            this.search((IBusinessObject)this.initObject);
        }
        this.tableDetailPage.handleSelectionChanged();
        this.tableDetailPage.handleEditChanged();
        parent.layout();
        GuiContainer.finalizeChanges();
    }

    @Override
    public void newObject() {
        log.debug((Object)"newObject aufgerufen");
        if (!this.isDiscardChanges()) {
            return;
        }
        this.setPageEditStatus(IPageController.PageEditStatus.enabledforNew);
        this.currentBusinessObject = this.createNewBusinessObject();
        IBoCalculatorClient calculator = CalculatorFactoryClient.createCalculator(this.currentBusinessObject);
        try {
            calculator.setDefaultValues(this.currentBusinessObject);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
        this.tableDetailPage.setSelection(this.currentBusinessObject);
        this.tableDetailPage.setBusinessObject(this.currentBusinessObject);
        this.tableDetailPage.handleSelectionChanged();
        this.tableDetailPage.handleEditChanged();
    }

    @Override
    public void refresh() {
        if (this.currentFilter != null) {
            this.select(this.currentFilter);
        }
    }

    @Override
    public void search() {
        IBusinessObject filter;
        this.currentFilter = filter = this.tableDetailPage.getFilter();
        this.select(filter);
    }

    public void search(IBusinessObject businessObject) {
        if (businessObject != null) {
            IBusinessObject filter;
            this.tableDetailPage.setFilter(businessObject);
            this.currentFilter = filter = businessObject;
            this.select(filter);
        } else {
            this.search();
        }
    }

    private void select(IBusinessObject filter) {
        try {
            filter = this.enhanceFilter(filter);
            if (!this.checkFilter(filter)) {
                return;
            }
            List<IBusinessObject> selectedList = this.doSelect(filter);
            if (!this.isSelectionValid(selectedList)) {
                return;
            }
            this.businessObjectList = selectedList;
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            this.tableDetailPage.setData(this.businessObjectList);
            if (this.businessObjectList.size() == 1) {
                this.setSelection(this.businessObjectList.get(0));
            } else {
                this.setSelection(this.currentBusinessObject);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            this.initializeValue(null);
        }
        this.tableDetailPage.handleSelectionChanged();
        this.tableDetailPage.handleEditChanged();
    }

    protected List<IBusinessObject> doSelect(IBusinessObject filter) {
        List<IBusinessObject> selectedList = null;
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            selectedList = db.select(filter);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            selectedList = new ArrayList<IBusinessObject>();
        }
        selectedList = this.postSelect(filter, selectedList);
        return selectedList;
    }

    protected List<IBusinessObject> postSelect(IBusinessObject filter, List<IBusinessObject> selectedList) {
        return selectedList;
    }

    @Override
    public void selectionChanged(Object object, int cnt) {
        if (this.processIsActive) {
            return;
        }
        this.processIsActive = true;
        IBusinessObject firstBusinessObject = (IBusinessObject)object;
        if (cnt == 0 || cnt == 1 && firstBusinessObject == this.currentBusinessObject) {
            this.processIsActive = false;
            return;
        }
        if (cnt > 1) {
            this.tableDetailPage.setSelection(this.currentBusinessObject);
            this.processIsActive = false;
            return;
        }
        if (firstBusinessObject != this.currentBusinessObject) {
            int answer = this.discardChangesPopup();
            if (answer == 2) {
                this.tableDetailPage.setSelection(this.currentBusinessObject);
                this.processIsActive = false;
                return;
            }
            if (answer == 0) {
                this.tableDetailPage.setSelection(firstBusinessObject);
            }
        }
        this.pageEditStatus = IPageController.PageEditStatus.disabled;
        this.tableDetailPage.setEnabled(false);
        if (cnt == 0) {
            this.pageSelectionStatus = IPageController.PageSelectionStatus.noSelection;
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
        } else if (cnt == 1) {
            this.pageSelectionStatus = IPageController.PageSelectionStatus.oneLineSelected;
        } else {
            this.pageSelectionStatus = IPageController.PageSelectionStatus.multiLinesSelected;
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
        }
        this.tableDetailPage.handleSelectionChanged();
        this.tableDetailPage.handleEditChanged();
        if (cnt == 1) {
            this.currentBusinessObject = firstBusinessObject;
            log.debug((Object)("selected row: " + firstBusinessObject.getId()));
            this.tableDetailPage.setBusinessObject(this.currentBusinessObject);
        } else {
            this.tableDetailPage.setEnabled(false);
            this.tableDetailPage.setBusinessObject(this.createNewBusinessObject());
        }
        this.processIsActive = false;
    }

    @Override
    public void save() throws DatabaseException, CalculationException {
        this.currentBusinessObject = this.tableDetailPage.getBusinessObject();
        this.currentBusinessObject.setLetzterBearbeiter(GlobalData.getInstance().getUser().getBearbeiter());
        CalculatorFactoryClient.createCalculator(this.currentBusinessObject).prepareSave(this.currentBusinessObject);
        IBusinessObject objectBeforeSave = this.currentBusinessObject;
        this.preSaveAction(this.currentBusinessObject);
        IBusinessObject savedBusinessObject = null;
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            savedBusinessObject = db.save(this.currentBusinessObject);
        }
        catch (Exception e) {
            throw new DatabaseException(DatabaseException.ErrorType.customText, "Fehler beim Speicher. " + e.getClass() + ", " + e.getMessage());
        }
        this.currentBusinessObject = savedBusinessObject;
        boolean found = false;
        for (int index = 0; index < this.businessObjectList.size() && !found; ++index) {
            IBusinessObject businessObjectInList = this.businessObjectList.get(index);
            if (!businessObjectInList.isIdentical(savedBusinessObject)) continue;
            this.businessObjectList.set(index, savedBusinessObject);
            found = true;
        }
        if (!found) {
            this.businessObjectList.add(savedBusinessObject);
        }
        this.tableDetailPage.setBusinessObject(savedBusinessObject);
        this.pageEditStatus = IPageController.PageEditStatus.disabled;
        this.pageSelectionStatus = IPageController.PageSelectionStatus.oneLineSelected;
        this.tableDetailPage.setSelection(savedBusinessObject);
        this.tableDetailPage.handleSelectionChanged();
        this.tableDetailPage.handleEditChanged();
        this.currentBusinessObject = savedBusinessObject;
        this.tableDetailPage.setChanged(false);
        this.postSaveAction(objectBeforeSave);
    }

    @Override
    public void undo() {
        try {
            this.tableDetailPage.setBusinessObject(this.currentBusinessObject);
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
        }
    }

    @Override
    public boolean deleteLine() {
        try {
            if (!MainApplicationWindow.getInstance().popupQuestion("M\u00f6chten Sie den Datensatz wirklich l\u00f6schen?")) {
                return false;
            }
            this.pageEditStatus = IPageController.PageEditStatus.disabled;
            Iterator<IBusinessObject> iterator = this.tableDetailPage.getSelectedBusinessObject().iterator();
            while (iterator.hasNext()) {
                IBusinessObject object;
                IBusinessObject businessObject = object = iterator.next();
                log.info((Object)("L\u00f6schen von Business-Objekt id=" + businessObject.getId()));
                if (businessObject.getId() > 0) {
                    SqLiteDatabase db = new SqLiteDatabase();
                    db.delete(businessObject);
                }
                this.businessObjectList.remove(businessObject);
            }
            this.pageSelectionStatus = IPageController.PageSelectionStatus.noSelection;
            this.tableDetailPage.handleSelectionChanged();
            this.tableDetailPage.clear();
            this.tableDetailPage.handleEditChanged();
            this.tableDetailPage.refresh();
            return true;
        }
        catch (Exception e) {
            ErrorHandler.handleUnknownError(log, e);
            return false;
        }
    }

    @Override
    public boolean newLine() {
        return false;
    }

    @Override
    public void edit() {
        log.debug((Object)"edit aufgerufen");
        this.pageEditStatus = this.pageEditStatus != IPageController.PageEditStatus.disabled ? IPageController.PageEditStatus.disabled : (this.currentBusinessObject.getId() == 0 ? IPageController.PageEditStatus.enabledforNew : IPageController.PageEditStatus.enabledforUpdate);
        this.tableDetailPage.handleEditChanged();
    }

    @Override
    public void clearFilter() {
        this.tableDetailPage.setFilter(this.createNewBusinessObject());
    }

    @Override
    public IBusinessObject getCurrentBusinessObject() {
        return this.currentBusinessObject;
    }

    @Override
    public void setCurrentBusinessObject(IBusinessObject currentBusinessObject) {
        this.currentBusinessObject = currentBusinessObject;
    }

    @Override
    public List<IBusinessObject> getBusinessObjectList() {
        return this.businessObjectList;
    }

    @Override
    public void setBusinessObjectList(List<IBusinessObject> businessObjectList) {
        this.businessObjectList = businessObjectList;
    }

    @Override
    public IPageController.PageSelectionStatus getPageSelectionStatus() {
        return this.pageSelectionStatus;
    }

    @Override
    public IPageController.PageEditStatus getPageEditStatus() {
        return this.pageEditStatus;
    }

    @Override
    public void setPageSelectionStatus(IPageController.PageSelectionStatus pageSelectionStatus) {
        this.pageSelectionStatus = pageSelectionStatus;
    }

    @Override
    public void setPageEditStatus(IPageController.PageEditStatus pageEditStatus) {
        this.pageEditStatus = pageEditStatus;
    }

    @Override
    public boolean isDataChanged() {
        return this.tableDetailPage.isDataChanged();
    }

    public void setSelection(IBusinessObject businessObject) {
        boolean found = false;
        for (IBusinessObject bo : this.businessObjectList) {
            if (bo.getId() != businessObject.getId()) continue;
            found = true;
            this.currentBusinessObject = bo;
            break;
        }
        if (!found && this.businessObjectList.size() > 0) {
            found = true;
            this.currentBusinessObject = this.businessObjectList.get(0);
        }
        if (!found) {
            this.tableDetailPage.clear();
        } else {
            this.pageSelectionStatus = IPageController.PageSelectionStatus.oneLineSelected;
            this.tableDetailPage.setSelection(this.currentBusinessObject);
            this.tableDetailPage.setBusinessObject(this.currentBusinessObject);
            this.tableDetailPage.handleSelectionChanged();
            this.tableDetailPage.handleEditChanged();
        }
    }

    @Override
    public IBusinessObject enhanceFilter(IBusinessObject filter) {
        return filter;
    }

    @Override
    public boolean checkFilter(IBusinessObject filter) {
        return true;
    }

    protected boolean isSelectionValid(List<IBusinessObject> selectedList) {
        return true;
    }

    protected void preSaveAction(IBusinessObject oldObject) {
    }

    protected void postSaveAction(IBusinessObject oldObject) {
    }

    protected abstract IBusinessObject createNewBusinessObject();

    protected abstract ITableDetailPage createNewTableDetailPage(ITableDetailPageController var1);

    protected abstract IBusinessObjectVerwaltung<IBusinessObject> getServerBean();

    public IDoubleClickHandler getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public void setDoubleClickHandler(IDoubleClickHandler doubleClickHandler) {
        this.doubleClickHandler = doubleClickHandler;
    }

    @Override
    public void doubleClick(Object object) {
        if (this.doubleClickHandler != null) {
            this.doubleClickHandler.onDoubleClick(object);
        }
    }

    @Override
    public boolean isSaveable() {
        boolean ret = true;
        IBusinessObject bo = this.tableDetailPage.getBusinessObject();
        if (bo == null) {
            return false;
        }
        this.validator = ValidatorFactory.createValidator(bo, GlobalData.getInstance().getBrand());
        if (this.validator != null) {
            ret = this.validator.isValid(bo);
        }
        return ret;
    }

    @Override
    public String getSaveableValidationError() {
        if (this.validator != null && !Util.isEmpty(this.validator.getErrorText())) {
            return this.validator.getErrorText();
        }
        return "";
    }

    @Override
    protected void doDiscardChanges() {
        this.tableDetailPage.setChanged(false);
    }

    @Override
    public String getTitle() {
        return this.getPage().getTitle();
    }

    @Override
    public void setFocusOnFilterHeader() {
        this.tableDetailPage.getFilterHeaderTile().setFocus();
    }
}

