/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.tiles.table;

import de.cni.client.gui.tiles.table.UserLabelProvider;
import de.cni.client.gui.tiles.table.templates.SortableTableController;
import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.User;
import org.eclipse.jface.viewers.ITableLabelProvider;

public class UserTableController
extends SortableTableController {
    public static final int COLIDX_USERNAME = 1;
    public static final int COLIDX_VORNAME = 2;
    public static final int COLIDX_NACHNAME = 3;
    public static final int COLIDX_CNT = 4;
    public static final String COL_USERNAME = Converter.intToString(1);
    public static final String COL_VORNAME = Converter.intToString(2);
    public static final String COL_NACHNAME = Converter.intToString(3);

    public UserTableController() {
        this.groupname = "Benutzer";
        this.columnNameArray = new String[]{"Benutzername", "Vorname", "Nachname"};
        this.columnWidthArray = new int[]{95, 95, 95};
        this.alignmentArray = new int[]{16384, 16384, 16384};
    }

    @Override
    public ITableLabelProvider createLabelProvider() {
        return new UserLabelProvider();
    }

    @Override
    public int compare(int column, Object o1, Object o2) {
        int rc = super.compare(column, o1, o2);
        User user1 = (User)o1;
        User user2 = (User)o2;
        switch (column) {
            case 1: {
                rc = Util.compare(user1.getUsername(), user2.getUsername());
            }
        }
        return rc;
    }
}

