/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.jaret.util.ui.datechooser.TimeChooser;
import java.util.Date;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AdvancedTimeChooser
extends TimeChooser {
    Color bgEnabledColor = Display.getDefault().getSystemColor(25);
    Color bgDisabledColor = Display.getDefault().getSystemColor(22);
    int myThreshold = 0;
    String myOldValue = "";

    public AdvancedTimeChooser(Composite parent, int style, int threshold) {
        super(parent, style);
        this.myThreshold = threshold;
        this.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (!AdvancedTimeChooser.this.isEnabled() || !AdvancedTimeChooser.this.isEditable()) {
                    return;
                }
                switch (event.keyCode) {
                    case 0x100000A: {
                        AdvancedTimeChooser.this.setText(Converter.dateToString(new Date()));
                    }
                }
            }
        });
    }

    public boolean validateInput() {
        String text = this.getTextField().getText();
        if (!Util.isEmpty(text)) {
            this.myOldValue = Converter.prepareDateString(text, this.myThreshold);
            this.getTextField().setText(this.myOldValue);
        }
        return super.validateInput();
    }

    public String getMyOldValue() {
        return this.myOldValue;
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        if (flag) {
            this.getTextField().setBackground(this.bgEnabledColor);
        } else {
            this.getTextField().setBackground(this.bgDisabledColor);
        }
    }

    public void setEditable(boolean flag) {
        super.setEditable(flag);
        if (flag) {
            this.getTextField().setBackground(this.bgEnabledColor);
        } else {
            this.getTextField().setBackground(this.bgDisabledColor);
        }
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!this.isEditable()) {
            this.getTextField().setBackground(this.bgDisabledColor);
        }
    }
}

