/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.calculation.Horoskop;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.SqLiteDatabase;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class AstroCombo {
    private String[] horoskopArray = new String[Horoskop.values().length + 1];
    private String[] planeten1Array = new String[Constants.planeten.length + 1];
    private String[] tkzArray = new String[Constants.tkz.length + 1];
    private String[] hausArray = new String[13];
    private String[] aspektArray = new String[AspektTyp.values().length + 1];
    private String[] textArray = null;

    public AstroCombo(boolean core) {
        int i;
        this.horoskopArray[0] = "";
        for (i = 0; i < Horoskop.values().length; ++i) {
            this.horoskopArray[i + 1] = Horoskop.values()[i].getName();
        }
        this.planeten1Array[0] = "";
        for (i = 0; i < Constants.planeten.length; ++i) {
            this.planeten1Array[i + 1] = Constants.planeten[i];
        }
        this.tkzArray[0] = "";
        for (i = 0; i < Constants.tkz.length; ++i) {
            this.tkzArray[i + 1] = Constants.tkz[i];
        }
        this.hausArray[0] = "";
        for (i = 0; i < 12; ++i) {
            this.hausArray[i + 1] = Converter.intToString(i + 1);
        }
        this.aspektArray[0] = "";
        for (i = 0; i < AspektTyp.values().length; ++i) {
            this.aspektArray[i + 1] = AspektTyp.getAspekt((int)i).langname;
        }
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            List<String> list = db.selectAnalyseText1(core);
            list.add(0, "");
            this.textArray = new String[list.size()];
            list.toArray(this.textArray);
        }
        catch (Exception e) {
            this.textArray = new String[1];
            this.textArray[0] = "";
        }
    }

    public ComboWrapper createHoroskopCombo(WidgetFactory widgetFactory, Composite c) {
        return this.createHoroskopCombo(widgetFactory, c, 0);
    }

    public ComboWrapper createPlanetenCombo(WidgetFactory widgetFactory, Composite c) {
        return this.createPlanetenCombo(widgetFactory, c, 0);
    }

    public ComboWrapper createAspektCombo(WidgetFactory widgetFactory, Composite c) {
        return this.createAspektCombo(widgetFactory, c, 0);
    }

    public ComboWrapper createTkzCombo(WidgetFactory widgetFactory, Composite c) {
        return this.createTkzCombo(widgetFactory, c, 0);
    }

    public ComboWrapper createHausCombo(WidgetFactory widgetFactory, Composite c) {
        return this.createHausCombo(widgetFactory, c, 0);
    }

    public ComboWrapper createTextCombo(WidgetFactory widgetFactory, Composite c) {
        return this.createTextCombo(widgetFactory, c, 0);
    }

    public ComboWrapper createHoroskopCombo(WidgetFactory widgetFactory, Composite c, int length) {
        ComboWrapper cw = widgetFactory.createCombo(c, this.horoskopArray, "Horoskop", length);
        return cw;
    }

    public ComboWrapper createPlanetenCombo(WidgetFactory widgetFactory, Composite c, int length) {
        ComboWrapper cw = widgetFactory.createCombo(c, this.planeten1Array, "Planet", length);
        return cw;
    }

    public ComboWrapper createAspektCombo(WidgetFactory widgetFactory, Composite c, int length) {
        ComboWrapper cw = widgetFactory.createCombo(c, this.aspektArray, "Aspekt", length);
        return cw;
    }

    public ComboWrapper createTkzCombo(WidgetFactory widgetFactory, Composite c, int length) {
        ComboWrapper cw = widgetFactory.createCombo(c, this.tkzArray, "Tierkreiszeichen", length);
        return cw;
    }

    public ComboWrapper createHausCombo(WidgetFactory widgetFactory, Composite c, int length) {
        ComboWrapper cw = widgetFactory.createCombo(c, this.hausArray, "Haus", length);
        return cw;
    }

    public ComboWrapper createTextCombo(WidgetFactory widgetFactory, Composite c, int length) {
        ComboWrapper cw = widgetFactory.createCombo(c, this.textArray, "Text", length);
        return cw;
    }

    public String getValueAsString(ComboWrapper cw) {
        return cw.getStringValue();
    }

    public int getPlanetId(ComboWrapper cw) {
        return cw.getWidget().getSelectionIndex() - 1;
    }

    public String setValueAsString(ComboWrapper cw, String s) {
        return cw.setStringValue(s);
    }
}

