/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.IWrapper;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.core.Verschluesselung;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BrowserWrapper
implements IWrapper<Browser> {
    private static Log log = LogFactory.getLog(BrowserWrapper.class);
    protected String id;
    protected boolean emptyAllowed = true;
    protected Browser widget;
    protected String value;
    protected boolean active = true;
    protected Font defaultFont = null;
    protected Verschluesselung verschuesselung;

    public BrowserWrapper() {
        this.widget = null;
        this.active = false;
    }

    public BrowserWrapper(Brand[] brands, Composite parent, int style) {
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            this.widget = new Browser(parent, 0);
            this.widget.setFont(GlobalData.getInstance().getDefaultFont());
            log.debug((Object)"Verschluesselung initialisieren - vorher");
            this.verschuesselung = new Verschluesselung();
            log.debug((Object)"Verschluesselung initialisieren - nachher");
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    public void print() {
        this.widget.execute("javascript:window.print();");
    }

    public void setUrlOrValue(String s) {
        if (this.widget != null) {
            if ((s = Util.NotNull(s)).startsWith("URL:")) {
                String currentDir = System.getProperty("user.dir");
                System.out.println("User.dir=" + currentDir);
                String url = s.substring(4);
                this.setUrl(url);
            } else {
                String currentDir = System.getProperty("user.dir");
                System.out.println("User.dir=" + currentDir);
                this.widget.setText(s);
            }
        }
    }

    private void setUrl(String url) {
        if (url.endsWith("html")) {
            try {
                File f = new File(url);
                if (f.exists() && f.isFile()) {
                    this.widget.setUrl(url);
                    return;
                }
                f = new File(url + "c");
                if (f.exists() && f.isFile()) {
                    String currentDir = System.getProperty("user.dir");
                    String baseTag = "<base href='file://" + currentDir + "/texte/' >";
                    String s = this.verschuesselung.entschluessel(url + "c");
                    s = s.replace("<head>", "<head>" + baseTag);
                    this.widget.setText(s);
                }
            }
            catch (Exception e) {
                this.widget.setText("URL nicht gefunden: " + url);
            }
            return;
        }
        this.widget.setUrl(url);
    }

    public String getValue() {
        if (this.widget != null) {
            this.value = this.widget.getText();
        }
        return this.value;
    }

    @Override
    public Control getControlWidget() {
        return this.widget;
    }

    public void setToolTipBrowser(String text) {
        if (this.widget != null) {
            this.widget.setToolTipText(text);
        }
    }

    @Override
    public Browser getWidget() {
        return this.widget;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
    }

    @Override
    public void setFocus() {
        if (this.widget != null) {
            this.widget.setFocus();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

