/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.pageflow.PageFlowController;
import de.cni.client.gui.util.IWrapper;
import de.cni.client.gui.util.PermissionHandler;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.GlobalData;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ButtonWrapper
implements IWrapper<Button> {
    String id;
    Button widget;
    boolean value;
    boolean active = true;
    Font defaultFont = GlobalData.getInstance().getDefaultFont();

    public ButtonWrapper() {
        this.widget = null;
        this.active = false;
    }

    public ButtonWrapper(Brand[] brands, Composite parent, Resources.ICON image) {
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            Button widget = new Button(parent, 8);
            Font smallFont = new Font((Device)Display.getCurrent(), "SansSerif", 7, 0);
            widget.setFont(smallFont);
            widget.setImage(Resources.getInstance().getImage(image));
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    public ButtonWrapper(Brand[] brands, Composite parent, int style, boolean small) {
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            this.widget = this.newButton(parent, style, small);
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    private Button newButton(Composite parent, int style, boolean small) {
        Button widget = new Button(parent, style);
        if (small) {
            Font smallFont = new Font((Device)Display.getCurrent(), "SansSerif", 7, 0);
            widget.setFont(smallFont);
        } else {
            widget.setFont(this.defaultFont);
        }
        return widget;
    }

    public void setValue(Boolean value) {
        this.value = value;
        if (this.widget != null) {
            this.widget.setSelection(value.booleanValue());
        }
    }

    public boolean getValue() {
        if (this.widget != null) {
            this.value = this.widget.getSelection();
        }
        return this.value;
    }

    @Override
    public Control getControlWidget() {
        return this.widget;
    }

    @Override
    public Button getWidget() {
        return this.widget;
    }

    public boolean isActive() {
        return this.active;
    }

    public void addAction(final IAction action) {
        if (this.widget == null) {
            return;
        }
        this.widget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.widget != null) {
            this.widget.addSelectionListener(listener);
        }
    }

    @Override
    public void setFocus() {
        if (this.widget != null) {
            this.widget.setFocus();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id, WidgetFactory widgetFactory) {
        if (this.widget != null) {
            this.id = id;
            if (!PermissionHandler.getInstance().isElementAllowd(PageFlowController.getInstance().getCurrentPage(), id)) {
                widgetFactory.disableOneWidget((Control)this.widget);
            }
            if (GlobalData.getInstance().getUserSetting() != null && GlobalData.getInstance().getUserSetting().isTechNames()) {
                this.widget.setToolTipText("ID=" + id);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.getWidget() == null) {
            return;
        }
        if (enabled && !PermissionHandler.getInstance().isElementAllowd(PageFlowController.getInstance().getCurrentPage(), this.id)) {
            return;
        }
        this.getWidget().setEnabled(enabled);
    }
}

