/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.SaveUserException;
import de.cni.common.exceptions.ServerException;
import de.cni.common.exceptions.ValidationException;
import org.apache.commons.logging.Log;

public class ErrorHandler {
    public static void handleError(Log log, String text) {
        MainApplicationWindow.getInstance().popupError(text);
        log.error((Object)text);
    }

    public static void handleUnknownError(Log log, Exception e) {
        if (e instanceof DatabaseException || e instanceof MappingException || e instanceof ServerException || e instanceof SaveUserException || e instanceof ValidationException || e instanceof CalculationException) {
            ErrorHandler.handleError(log, e);
        } else {
            ErrorHandler.handleError(log, "Technischer Fehler.", e);
            e.printStackTrace();
        }
    }

    public static void handleError(Log log, Exception e) {
        ErrorHandler.handleError(log, "", e);
    }

    public static void handleError(Log log, String text, Exception e) {
        String message = Util.NotNull(e.getMessage());
        if (Util.isEmpty(message)) {
            message = "Fehlertyp: " + e.getClass().getSimpleName();
        }
        String errorString = Formatter.blankTrailingString(text) + message;
        MainApplicationWindow.getInstance().popupError(errorString);
        log.error((Object)errorString);
    }
}

