/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.pageflow.Page;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.GuiElements;
import de.cni.common.core.GlobalData;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Berechtigung;
import de.cni.common.datamodel.admin.Rolle;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionHandler {
    private static Log log = LogFactory.getLog(PermissionHandler.class);
    private List<String> rolesList = null;
    private boolean handlerDisabled = true;
    private static PermissionHandler instance = new PermissionHandler();
    private HashMap<String, Boolean> elementHasWhitelistEntry = new HashMap();
    private HashMap<String, Boolean> pageHasWhitelistEntry = new HashMap();
    private HashMap<String, Boolean> whitelist = new HashMap();
    private HashMap<String, Boolean> elementHasBlacklistEntry = new HashMap();
    private HashMap<String, Boolean> pageHasBlacklistEntry = new HashMap();
    private HashMap<String, Boolean> blacklist = new HashMap();

    private PermissionHandler() {
        try {
            Berechtigung filter = new Berechtigung();
            IBusinessObjectVerwaltung<IBusinessObject> bean = ServerConnection.getInstance().getObjectVerwaltung();
            if (bean == null) {
                return;
            }
            List<IBusinessObject> berechtigungList = bean.select(filter);
            for (Berechtigung berechtigung : berechtigungList) {
                String key;
                if (berechtigung.getGrandtype().equals(Berechtigung.Grandtype.Erlaubnis.name())) {
                    key = berechtigung.getPage() + "." + berechtigung.getElement() + "." + berechtigung.getRole();
                    this.whitelist.put(key, true);
                    if (!this.isPageRule(berechtigung)) {
                        key = berechtigung.getPage() + "." + berechtigung.getElement();
                        this.elementHasWhitelistEntry.put(key, true);
                    } else {
                        key = berechtigung.getPage() + "." + berechtigung.getRole();
                        this.pageHasWhitelistEntry.put(key, true);
                    }
                }
                if (!berechtigung.getGrandtype().equals(Berechtigung.Grandtype.Sperre.name())) continue;
                key = berechtigung.getPage() + "." + berechtigung.getElement() + "." + berechtigung.getRole();
                this.blacklist.put(key, true);
                if (!this.isPageRule(berechtigung)) {
                    key = berechtigung.getPage() + "." + berechtigung.getElement();
                    this.elementHasBlacklistEntry.put(key, true);
                    continue;
                }
                key = berechtigung.getPage() + "." + berechtigung.getRole();
                this.pageHasBlacklistEntry.put(key, true);
            }
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, "Die Berechtigungsinformationen k\u00f6nnen nicht gelesen werden.", e);
        }
    }

    public boolean isPageAllowd(Page page) {
        try {
            if (this.handlerDisabled) {
                return true;
            }
            if (page == Page.login || page == Page.logout) {
                return true;
            }
            for (String role : this.getRolesList()) {
                if (!this.isPageAllowed(page, role)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    public boolean isPageAllowed(Page page, String role) {
        try {
            if (this.handlerDisabled) {
                return true;
            }
            if (page == Page.login || page == Page.logout) {
                return true;
            }
            if (this.whitelist.containsKey((Object)((Object)page) + "." + GuiElements.GANZE_SEITE + "." + role)) {
                return true;
            }
            return !this.blacklist.containsKey((Object)((Object)page) + "." + GuiElements.GANZE_SEITE + "." + role) && !this.blacklist.containsKey("<Alle>." + GuiElements.GANZE_SEITE + "." + role);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    public boolean isElementAllowd(Page page, String element) {
        try {
            if (this.handlerDisabled) {
                return true;
            }
            boolean ret = true;
            if (Util.isEmpty(element)) {
                return true;
            }
            for (String role : this.getRolesList()) {
                if (!this.isPageAllowed(page, role)) continue;
                if (this.whitelist.containsKey((Object)((Object)page) + "." + element + "." + role) || this.whitelist.containsKey("<Alle>." + element + "." + role)) {
                    return true;
                }
                if (this.blacklist.containsKey((Object)((Object)page) + "." + element + "." + role) || this.blacklist.containsKey("<Alle>." + element + "." + role)) {
                    ret = false;
                    continue;
                }
                return true;
            }
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorHandler.handleError(log, e);
            return false;
        }
    }

    private List<String> getRolesList() {
        if (this.rolesList == null) {
            this.rolesList = new ArrayList<String>();
            for (Rolle rolle : GlobalData.getInstance().getUser().getRolleList()) {
                this.rolesList.add(rolle.getRolle());
            }
        }
        return this.rolesList;
    }

    private boolean isPageRule(Berechtigung berechtigung) {
        return Util.isEmpty(berechtigung.getElement()) || berechtigung.getElement().equals(GuiElements.GANZE_SEITE);
    }

    public static PermissionHandler getInstance() {
        return instance;
    }

    public static void setInstance(PermissionHandler instance) {
        PermissionHandler.instance = instance;
    }
}

