/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.PersonendatenController;
import de.cni.client.gui.popup.filter.PopupTextColumnDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.client.paint.Controlpanel;
import de.cni.common.calculation.Aspektarium;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.TransitCalculator;
import de.cni.common.calculation.TransitRange;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PopupRohdaten {
    private static Log log = LogFactory.getLog(PersonendatenController.class);

    public static void popupRadixdaten(Personendaten pd) {
        try {
            HoroskopCalculator hk = new HoroskopCalculator();
            hk.calculateRadix(pd);
            Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());
            PopupRohdaten.popupHoroskopdaten(hk, controlpanel);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public static void popupGeburtsdaten(Personendaten pd) {
        try {
            FormattedStringBuffer sb = new FormattedStringBuffer();
            if (pd != null) {
                if (!Util.isEmpty(pd.getGeburtsdatumString())) {
                    sb.println("Geburt:\t" + pd.getGeburtsdatumString());
                }
                sb.println("Breite:\t" + Util.lat2dms(pd.getLatitude()));
                sb.println("L\u00e4nge:\t" + Util.lon2dms(pd.getLongitude()));
            }
            Popup.info(sb.toString());
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public static void popupHoroskopdaten(HoroskopCalculator horoskopCalculator, Controlpanel controlpanel) {
        try {
            List<TransitRange> transitRangeList;
            TransitCalculator transitCalculator;
            boolean inter;
            boolean withTabs = true;
            boolean withSymbols = false;
            Astrodaten a1 = horoskopCalculator.getAstrodaten1();
            Astrodaten a2 = horoskopCalculator.getAstrodaten2();
            String s1 = a1 != null ? a1.toString() : "";
            String s2 = a2 != null ? a2.toString() : "";
            AspektariumCalculator cal = new AspektariumCalculator(horoskopCalculator.getHoroskop(), controlpanel);
            Horoskop horoskop = horoskopCalculator.getHoroskop();
            String sa1 = "";
            String sa2 = "";
            String sa3 = "";
            if (a1 != null) {
                inter = false;
                Aspektarium aspektarium1 = cal.berechneAspekte(a1);
                if (TransitCalculator.isCalculationAllowed(horoskop)) {
                    transitCalculator = new TransitCalculator(horoskopCalculator, controlpanel, aspektarium1.getPlanetListe(), aspektarium1.getAspektArray());
                    transitRangeList = transitCalculator.calculate(1, inter);
                    transitCalculator.copyToAspektArray(transitRangeList, aspektarium1.getTransitVonArray(), aspektarium1.getTransitBisArray());
                }
                sa1 = aspektarium1.asString(inter, withSymbols);
            }
            if (a2 != null) {
                inter = false;
                Aspektarium aspektarium2 = cal.berechneAspekte(a2);
                if (TransitCalculator.isCalculationAllowed(horoskop)) {
                    transitCalculator = new TransitCalculator(horoskopCalculator, controlpanel, aspektarium2.getPlanetListe(), aspektarium2.getAspektArray());
                    transitRangeList = transitCalculator.calculate(2, inter);
                    transitCalculator.copyToAspektArray(transitRangeList, aspektarium2.getTransitVonArray(), aspektarium2.getTransitBisArray());
                }
                sa2 = aspektarium2.asString(inter, withSymbols);
            }
            if (a2 != null) {
                inter = true;
                Aspektarium interaspektarium = cal.berechneInterAspekte(a1, a2, a2.offset);
                if (horoskop != Horoskop.KompositTransit) {
                    if (TransitCalculator.isCalculationAllowed(horoskop)) {
                        transitCalculator = new TransitCalculator(horoskopCalculator, controlpanel, interaspektarium.getPlanetListe(), interaspektarium.getAspektArray());
                        transitRangeList = transitCalculator.calculate(0, inter);
                        transitCalculator.copyToAspektArray(transitRangeList, interaspektarium.getTransitVonArray(), interaspektarium.getTransitBisArray());
                    }
                    sa3 = interaspektarium.asString(inter, withSymbols);
                } else {
                    if (TransitCalculator.isCalculationAllowed(horoskop)) {
                        transitCalculator = new TransitCalculator(horoskopCalculator, controlpanel, interaspektarium.getPlanetListe(), interaspektarium.getAspektArray());
                        transitRangeList = transitCalculator.calculate(0, inter);
                        transitCalculator.copyToAspektArray(transitRangeList, interaspektarium.getTransitVonArray(), interaspektarium.getTransitBisArray());
                    }
                    sa3 = interaspektarium.asString(inter, withSymbols);
                }
            }
            new PopupTextColumnDialog(MainApplicationWindow.getInstance().getShell(), horoskopCalculator, controlpanel, withTabs, withSymbols, s1, sa1, s2, sa2, sa3).open();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }
}

