/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.common.core.Formatter;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class Resources {
    private static Log log = LogFactory.getLog(Resources.class);
    public static Resources instance = new Resources();
    private HashMap<String, ImageDescriptor> imageRegistry;

    private Resources() {
        try {
            log.debug((Object)"Start Resources");
            this.imageRegistry = new HashMap();
            this.putToRegistry(ICON.TITLE_ICON, "/application.gif");
            this.putToRegistry(ICON.MAIN_PAGE, "/main_page.jpg");
            this.putToRegistry(ICON.BIG_NEW, "/new_wiz.gif");
            this.putToRegistry(ICON.BIG_EDIT, "/write_obj.gif");
            this.putToRegistry(ICON.BIG_READ, "/read_obj.gif");
            this.putToRegistry(ICON.BIG_SAVE, "/save_edit.gif");
            this.putToRegistry(ICON.BIG_REFRESH, "/update.gif");
            this.putToRegistry(ICON.SMALL_REFRESH, "/small_refresh.gif");
            this.putToRegistry(ICON.BIG_PRINT, "/print.gif");
            this.putToRegistry(ICON.BIG_SYNC, "/sync.gif");
            this.putToRegistry(ICON.HISTORY, "/history_working_set_obj.gif");
            this.putToRegistry(ICON.UNDOHISTORY, "/undohistory.gif");
            this.putToRegistry(ICON.UNDO, "/undo.gif");
            this.putToRegistry(ICON.COPY, "/copy.gif");
            this.putToRegistry(ICON.PASTE, "/paste.gif");
            this.putToRegistry(ICON.CALCULATOR, "/calculator.gif");
            this.putToRegistry(ICON.SMALL_SEARCH, "/search.gif");
            this.putToRegistry(ICON.SMALL_TERMINATE, "/terminate_co.gif");
            this.putToRegistry(ICON.SMALL_TRASH, "/trash_small.gif");
            this.putToRegistry(ICON.BIG_TRASH, "/trash.gif");
            this.putToRegistry(ICON.SMALL_UP, "/prev_nav.gif");
            this.putToRegistry(ICON.SMALL_DOWN, "/next_nav.gif");
            this.putToRegistry(ICON.SMALL_ADD, "/add_obj.gif");
            this.putToRegistry(ICON.SMALL_REMOVE, "/delete_obj.gif");
            this.putToRegistry(ICON.SMALL_SELECT_ITEM, "/tasks_tsk.gif");
            this.putToRegistry(ICON.SMALL_FORWARD_NAV, "/forward_nav.gif");
            this.putToRegistry(ICON.SMALL_BACKWARD_NAV, "/backward_nav.gif");
            this.putToRegistry(ICON.SMALL_UNDO, "/undo_edit.gif");
            this.putToRegistry(ICON.SMALL_REDO, "/redo_edit.gif");
            this.putToRegistry(ICON.SMALL_FILTER, "/filter.gif");
            this.putToRegistry(ICON.SMALL_FILTER_RED, "/filter_red.gif");
            this.putToRegistry(ICON.SMALL_NO_FILTER, "/no_filter.gif");
            this.putToRegistry(ICON.BOOLEAN_TRUE, "/enabled_co.gif");
            this.putToRegistry(ICON.BOOLEAN_FALSE, "/disabled_co.gif");
            this.putToRegistry(ICON.BOOLEAN_SUCCESS, "/boolean_success.gif");
            this.putToRegistry(ICON.BOOLEAN_FAILED, "/boolean_failed.gif");
            this.putToRegistry(ICON.RED, "/red.gif");
            this.putToRegistry(ICON.GREEN, "/green.gif");
            this.putToRegistry(ICON.EXCHANGE, "/exchange.gif");
            this.putToRegistry(ICON.ITEM_REMOVED, "/item_removed1.gif");
            this.putToRegistry(ICON.ITEM_OK, "/item_ok.gif");
            this.putToRegistry(ICON.EURO, "/euro.png");
            this.putToRegistry(ICON.EURO_STORNIERT, "/euro_storniert.png");
            this.putToRegistry(ICON.EURO_ROT, "/euro1_rot.png");
            this.putToRegistry(ICON.EURO_GELB, "/euro1_gelb.png");
            this.putToRegistry(ICON.EURO_GRUEN, "/euro1_gruen.png");
            this.putToRegistry(ICON.EURO_BLAU, "/euro1_blau.png");
            this.putToRegistry(ICON.EURO_GRAU, "/euro1_grau.png");
            this.putToRegistry(ICON.RECHNUNG, "/euro.png");
            this.putToRegistry(ICON.PLUS, "/plus.gif");
            this.putToRegistry(ICON.MINUS, "/minus.gif");
            this.putToRegistry(ICON.VALIDATE, "/validate.gif");
            this.putToRegistry(ICON.CALCULATE, "/calculator.gif");
            this.putToRegistry(ICON.INFO, "/info.gif");
            this.putToRegistry(ICON.CHECKED, "/checked.gif");
            this.putToRegistry(ICON.DETAILS, "/focus_small.gif");
            this.putToRegistry(ICON.LETTER, "/letter.gif");
            this.putToRegistry(ICON.WORD, "/word.gif");
            this.putToRegistry(ICON.POPUPLIST, "/popuplist.gif");
            this.putToRegistry(ICON.WEBSERVICE_GEODATEN, "/places.png");
            this.putToRegistry(ICON.ANALYSE_KONSTELLATION, "/analyse_konstellation.gif");
            this.putToRegistry(ICON.ANALYSE_HERRSCHER, "/analyse_herrscher.gif");
            this.putToRegistry(ICON.RADIX, "/radix.gif");
            this.putToRegistry(ICON.SOLAR, "/solar.png");
            this.putToRegistry(ICON.SEPTAR, "/septar.png");
            this.putToRegistry(ICON.TRANSIT, "/transit.png");
            this.putToRegistry(ICON.AKTUALITAET, "/aktualitaet.png");
            this.putToRegistry(ICON.SYNASTRIE, "/synastrie.png");
            this.putToRegistry(ICON.KOMPOSIT, "/komposit.png");
            this.putToRegistry(ICON.KOMPOTRANSIT, "/kompoTransit.gif");
            this.putToRegistry(ICON.MULTIKOMPOSIT, "/multikomposit.png");
            this.putToRegistry(ICON.KOMPOSITSEPTAR, "/kompositseptar.png");
            this.putToRegistry(ICON.TEMPOSIT, "/temposit.png");
            this.putToRegistry(ICON.SEPTOSIT, "/septosit.png");
            this.putToRegistry(ICON.ROTATE_LEFT, "/rotate_left.png");
            this.putToRegistry(ICON.ROTATE_RIGHT, "/rotate_right.png");
            this.putToRegistry(ICON.BATCH, "/batch.gif");
            this.putToRegistry(ICON.LONGBATCH, "/longbatch.gif");
            for (ICON_SIZE size : ICON_SIZE.values()) {
                for (ICON_COLOR color : new ICON_COLOR[]{ICON_COLOR.standard, ICON_COLOR.black}) {
                    this.putToRegistry(ICON.TKZ_FISCHE, size, color, "/Tkz/Fische.png");
                    this.putToRegistry(ICON.TKZ_JUNGFRAU, size, color, "/Tkz/Jungfrau.png");
                    this.putToRegistry(ICON.TKZ_KREBS, size, color, "/Tkz/Krebs.png");
                    this.putToRegistry(ICON.TKZ_LOEWE, size, color, "/Tkz/Loewe.png");
                    this.putToRegistry(ICON.TKZ_SCHUETZE, size, color, "/Tkz/Schuetze.png");
                    this.putToRegistry(ICON.TKZ_SKORPION, size, color, "/Tkz/Skorpion.png");
                    this.putToRegistry(ICON.TKZ_STEINBOCK, size, color, "/Tkz/Steinbock.png");
                    this.putToRegistry(ICON.TKZ_STIER, size, color, "/Tkz/Stier.png");
                    this.putToRegistry(ICON.TKZ_WAAGE, size, color, "/Tkz/Waage.png");
                    this.putToRegistry(ICON.TKZ_WASSERMANN, size, color, "/Tkz/Wassermann.png");
                    this.putToRegistry(ICON.TKZ_WIDDER, size, color, "/Tkz/Widder.png");
                    this.putToRegistry(ICON.TKZ_ZWILLINGE, size, color, "/Tkz/Zwillinge.png");
                }
            }
            for (ICON_SIZE size : ICON_SIZE.values()) {
                for (ICON_COLOR color : new ICON_COLOR[]{ICON_COLOR.standard, ICON_COLOR.black, ICON_COLOR.red}) {
                    this.putToRegistry(ICON.PLANET_SONNE, size, color, "/Planeten/Sonne.png");
                    this.putToRegistry(ICON.PLANET_MOND, size, color, "/Planeten/Mond.png");
                    this.putToRegistry(ICON.PLANET_MERKUR, size, color, "/Planeten/Merkur.png");
                    this.putToRegistry(ICON.PLANET_VENUS, size, color, "/Planeten/Venus.png");
                    this.putToRegistry(ICON.PLANET_MARS, size, color, "/Planeten/Mars.png");
                    this.putToRegistry(ICON.PLANET_JUPITER, size, color, "/Planeten/Jupiter.png");
                    this.putToRegistry(ICON.PLANET_SATURN, size, color, "/Planeten/Saturn.png");
                    this.putToRegistry(ICON.PLANET_URANUS, size, color, "/Planeten/Uranus.png");
                    this.putToRegistry(ICON.PLANET_NEPTUN, size, color, "/Planeten/Neptun.png");
                    this.putToRegistry(ICON.PLANET_PLUTO, size, color, "/Planeten/Pluto.png");
                }
                this.putToRegistry(ICON.PLANET_AC, size, ICON_COLOR.standard, "/Planeten/AC.png");
                this.putToRegistry(ICON.PLANET_DC, size, ICON_COLOR.standard, "/Planeten/DC.png");
                this.putToRegistry(ICON.PLANET_MC, size, ICON_COLOR.standard, "/Planeten/MC.png");
                this.putToRegistry(ICON.PLANET_IC, size, ICON_COLOR.standard, "/Planeten/IC.png");
            }
            this.putToRegistry(ICON.ASPEKT_KONJUNKTION, "/Aspekte/Konjunktion.png");
            this.putToRegistry(ICON.ASPEKT_OPPOSITION, "/Aspekte/Opposition.png");
            this.putToRegistry(ICON.ASPEKT_QUADRAT, "/Aspekte/Quadrat.png");
            this.putToRegistry(ICON.ASPEKT_SEXTIL, "/Aspekte/Sextil.png");
            this.putToRegistry(ICON.ASPEKT_TRIGON, "/Aspekte/Trigon.png");
            log.debug((Object)"Ende Resources");
        }
        catch (Exception e) {
            log.error((Object)("Fehler beim Laden der Resourcen. " + e.getMessage()));
        }
    }

    private void putToRegistry(ICON icon, String filename) {
        String key = this.getIconKey(icon, null, null);
        String path = this.getIconPath(null, null) + filename;
        this.imageRegistry.put(key, ImageDescriptor.createFromFile(Resources.class, (String)("/" + path)));
    }

    private void putToRegistry(ICON icon, ICON_SIZE size, ICON_COLOR color, String filename) {
        String key = this.getIconKey(icon, size, color);
        String path = this.getIconPath(size, color) + filename;
        log.debug((Object)("putToRegistry: key = " + key + ",   path = " + path));
        this.imageRegistry.put(this.getIconKey(icon, size, color), ImageDescriptor.createFromFile(Resources.class, (String)("/" + this.getIconPath(size, color) + filename)));
    }

    public static Resources getInstance() {
        return instance;
    }

    public ImageDescriptor getImageDescriptor(ICON icon) throws InternalError {
        return this.getImageDescriptor(icon, null, null);
    }

    public ImageDescriptor getImageDescriptor(ICON icon, ICON_SIZE size, ICON_COLOR color) {
        try {
            return this.imageRegistry.get(this.getIconKey(icon, size, color));
        }
        catch (Exception e) {
            String error = "Icon nicht gefunden. " + this.getIconDescription(icon, size, color);
            e.printStackTrace();
            log.error((Object)error);
            throw new InternalError(error);
        }
    }

    public Image getImage(ICON icon) throws InternalError {
        return this.getImage(icon, null, null);
    }

    public Image getImage(ICON icon, ICON_SIZE size, ICON_COLOR color) throws InternalError {
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = this.imageRegistry.get(this.getIconKey(icon, size, color));
            Image i = imageDescriptor.createImage();
            log.debug((Object)("Descriptor=" + imageDescriptor.toString()));
            log.debug((Object)("Image erzeugt. Key=" + this.getIconKey(icon, size, color) + ", Size(" + i.getImageData().width + "," + i.getImageData().height + ")"));
            return i;
        }
        catch (Exception e) {
            String error = "Icon nicht gefunden. " + this.getIconDescription(icon, size, color);
            if (imageDescriptor != null) {
                error = error + ", Pfad=" + imageDescriptor.toString();
            }
            e.printStackTrace();
            log.error((Object)error);
            throw new InternalError(error);
        }
    }

    public String getIconKey(ICON icon, ICON_SIZE size, ICON_COLOR color) throws InternalError {
        String iconName = icon != null ? icon.name() : null;
        String sizeName = size != null ? size.name() : ICON_SIZE.standard.name();
        String colorName = color != null ? color.name() : ICON_COLOR.standard.name();
        String s = Formatter.append(sizeName, colorName, iconName, "/");
        return s;
    }

    public String getIconPath(ICON_SIZE size, ICON_COLOR color) throws InternalError {
        String sizeName = size != null ? size.name() : ICON_SIZE.standard.name();
        String colorName = color != null ? color.name() : ICON_COLOR.standard.name();
        String s = Formatter.append(sizeName, colorName, "/");
        return s;
    }

    private String getIconDescription(ICON icon, ICON_SIZE size, ICON_COLOR color) {
        String iconName = icon != null ? icon.name() : null;
        String sizeName = size != null ? size.name() : ICON_SIZE.standard.name();
        String colorName = color != null ? color.name() : ICON_COLOR.standard.name();
        String text = "Name=" + iconName + ", Size=" + sizeName + ", Color=" + colorName;
        return text;
    }

    public static enum ICON {
        MAIN_PAGE,
        TITLE_ICON,
        BIG_NEW,
        BIG_EDIT,
        BIG_SAVE,
        BIG_READ,
        BIG_REFRESH,
        BIG_PRINT,
        BIG_SYNC,
        CALCULATOR,
        HISTORY,
        UNDOHISTORY,
        UNDO,
        COPY,
        PASTE,
        SMALL_UP,
        SMALL_DOWN,
        SMALL_ADD,
        SMALL_REMOVE,
        SMALL_SEARCH,
        SMALL_TERMINATE,
        SMALL_TRASH,
        SMALL_REFRESH,
        BIG_TRASH,
        SMALL_SELECT_ITEM,
        SMALL_FORWARD_NAV,
        SMALL_BACKWARD_NAV,
        SMALL_UNDO,
        SMALL_REDO,
        SMALL_FILTER,
        SMALL_FILTER_RED,
        SMALL_NO_FILTER,
        BOOLEAN_TRUE,
        BOOLEAN_FALSE,
        BOOLEAN_SUCCESS,
        BOOLEAN_FAILED,
        ITEM_REMOVED,
        ITEM_OK,
        VALIDATE,
        CALCULATE,
        INFO,
        CHECKED,
        DETAILS,
        RED,
        GREEN,
        EXCHANGE,
        LETTER,
        POPUPLIST,
        WORD,
        EURO,
        EURO_STORNIERT,
        EURO_ROT,
        EURO_GELB,
        EURO_GRUEN,
        EURO_BLAU,
        EURO_GRAU,
        ZODIAC1,
        ZODIAC2,
        ZODIAC3,
        PLUS,
        MINUS,
        WEBSERVICE_GEODATEN,
        ROTATE_LEFT,
        ROTATE_RIGHT,
        TKZ_FISCHE,
        TKZ_JUNGFRAU,
        TKZ_KREBS,
        TKZ_LOEWE,
        TKZ_SKORPION,
        TKZ_STEINBOCK,
        TKZ_STIER,
        TKZ_SCHUETZE,
        TKZ_WAAGE,
        TKZ_WASSERMANN,
        TKZ_WIDDER,
        TKZ_ZWILLINGE,
        PLANET_SONNE,
        PLANET_MOND,
        PLANET_MERKUR,
        PLANET_VENUS,
        PLANET_MARS,
        PLANET_JUPITER,
        PLANET_SATURN,
        PLANET_URANUS,
        PLANET_NEPTUN,
        PLANET_PLUTO,
        PLANET_AC,
        PLANET_MC,
        PLANET_IC,
        PLANET_DC,
        ASPEKT_KONJUNKTION,
        ASPEKT_OPPOSITION,
        ASPEKT_QUADRAT,
        ASPEKT_SEXTIL,
        ASPEKT_TRIGON,
        RADIX,
        SOLAR,
        SEPTAR,
        TRANSIT,
        AKTUALITAET,
        SYNASTRIE,
        KOMPOSIT,
        KOMPOTRANSIT,
        MULTIKOMPOSIT,
        KOMPOSITSEPTAR,
        TEMPOSIT,
        SEPTOSIT,
        ANALYSE_KONSTELLATION,
        ANALYSE_HERRSCHER,
        RECHNUNG,
        BATCH,
        LONGBATCH;

    }

    public static enum ICON_COLOR {
        standard,
        black,
        blue,
        red;

    }

    public static enum ICON_SIZE {
        standard,
        small,
        medium,
        large;

    }
}

