/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.action.toolbar.IHighlightAction;
import de.cni.client.gui.pageflow.PageFlowController;
import de.cni.client.gui.util.PermissionHandler;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;

public class ToolbarWrapper {
    ToolBarManager tbm;
    boolean active = true;

    public void initialize(ToolBarManager tbm) {
        this.tbm = tbm;
    }

    public void setToolbar(IContributionItem[] items) {
        if (this.isActive()) {
            this.tbm.removeAll();
            for (IContributionItem item : items) {
                if (item == null) continue;
                this.tbm.add(item);
                ActionContributionItem ai = (ActionContributionItem)item;
                this.setEnabled(ai.getAction().getId(), true);
            }
            this.tbm.update(true);
        }
    }

    public void resetToolbar() {
        if (this.isActive() && this.tbm != null) {
            this.tbm.removeAll();
            this.tbm.update(true);
        }
    }

    public void setToolbar(List<IContributionItem> list) {
        if (this.isActive() && this.tbm != null) {
            this.tbm.removeAll();
            for (IContributionItem item : list) {
                if (item == null) continue;
                this.tbm.add(item);
                ActionContributionItem ai = (ActionContributionItem)item;
                this.setEnabled(ai.getAction().getId(), true);
            }
            this.tbm.update(true);
        }
    }

    public void removeToolbarItems(IContributionItem[] items) {
        if (this.isActive()) {
            for (IContributionItem item : items) {
                if (item == null) continue;
                this.tbm.remove(item);
            }
            this.tbm.update(true);
        }
    }

    public void removeToolbarItems(IContributionItem item) {
        if (this.isActive()) {
            if (item != null) {
                this.tbm.remove(item);
            }
            this.tbm.update(true);
        }
    }

    public void addToolbarItems(IContributionItem[] items) {
        if (this.isActive()) {
            for (IContributionItem item : items) {
                if (item == null) continue;
                this.tbm.add(item);
                ActionContributionItem ai = (ActionContributionItem)item;
                this.setEnabled(ai.getAction().getId(), true);
            }
            this.tbm.update(true);
        }
    }

    public void addToolbarItem(IContributionItem item) {
        if (this.isActive()) {
            if (item != null) {
                this.tbm.add(item);
                ActionContributionItem ai = (ActionContributionItem)item;
                this.setEnabled(ai.getAction().getId(), true);
            }
            this.tbm.update(true);
        }
    }

    public void setEnabled(String id, boolean enabled) {
        IContributionItem item = this.tbm.find(id);
        if (item != null) {
            if (!PermissionHandler.getInstance().isElementAllowd(PageFlowController.getInstance().getCurrentPage(), id)) {
                ActionContributionItem ai = (ActionContributionItem)item;
                ai.getAction().setEnabled(false);
                return;
            }
            ActionContributionItem ai = (ActionContributionItem)item;
            ai.getAction().setEnabled(enabled);
        }
    }

    public void setHighlight(String id, boolean highlight) {
        IContributionItem item = this.tbm.find(id);
        if (item != null) {
            ActionContributionItem ai = (ActionContributionItem)item;
            IAction action = ai.getAction();
            if (!(action instanceof IHighlightAction)) {
                return;
            }
            ((IHighlightAction)action).setHighligh(highlight);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

