/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.pageflow.PageFlowController;
import de.cni.client.gui.util.AdvancedDateChooser;
import de.cni.client.gui.util.AdvancedTimeChooser;
import de.cni.client.gui.util.BrowserWrapper;
import de.cni.client.gui.util.ButtonWrapper;
import de.cni.client.gui.util.ComboWrapper;
import de.cni.client.gui.util.DateChooserWrapper;
import de.cni.client.gui.util.EnablingRegistry;
import de.cni.client.gui.util.FormattedTextWrapper;
import de.cni.client.gui.util.GuiContainer;
import de.cni.client.gui.util.IWrapper;
import de.cni.client.gui.util.LabelWrapper;
import de.cni.client.gui.util.PermissionHandler;
import de.cni.client.gui.util.Resources;
import de.cni.client.gui.util.StyledTextWrapper;
import de.cni.client.gui.util.TextWrapper;
import de.cni.client.gui.util.TimeChooserWrapper;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.Converter;
import de.cni.common.core.Domain;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.exceptions.MappingException;
import de.jaret.util.ui.datechooser.IFieldIdentifier;
import de.jaret.util.ui.datechooser.SimpleFieldIdentifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class WidgetFactory {
    private static Log log = LogFactory.getLog(WidgetFactory.class);
    public static Color bgEnabledColor = Display.getDefault().getSystemColor(25);
    public static Color bgDisabledColor = Display.getDefault().getSystemColor(22);
    public static Color fgDisabledColor = Display.getDefault().getSystemColor(21);
    public static int TEXTBLOCKHIGHT = 90;
    public EnablingRegistry enablingRegistry = new EnablingRegistry();
    public boolean changed = false;
    int defaultSpan = 1;
    boolean langtext = true;
    Brand[] brands;

    public WidgetFactory() {
    }

    public WidgetFactory(int defaultSpan) {
        this.defaultSpan = defaultSpan;
    }

    public TextWrapper createDummyText() {
        return new TextWrapper();
    }

    public FormattedTextWrapper createDummyCurrencyText() {
        return new FormattedTextWrapper();
    }

    public ButtonWrapper createDummyButton() {
        return new ButtonWrapper();
    }

    public DateChooserWrapper createDummyDateChooser() {
        return new DateChooserWrapper();
    }

    public LabelWrapper createDummy(Composite parent) {
        return new LabelWrapper(this.brands, parent, 0);
    }

    public LabelWrapper createDummy(Brand brand, Composite parent) {
        if (GlobalData.getInstance().hasBrand(brand)) {
            return this.createDummy(parent);
        }
        return null;
    }

    public TextWrapper createLabelAndText(Composite parent, String text, int length, int limit) {
        this.createLabel(parent, text);
        return this.createText(parent, text, length, limit);
    }

    public FormattedTextWrapper createLabelAndCurrencyText(Composite parent, String text, int length) {
        this.createLabel(parent, text);
        return this.createCurrencyTextSpan(parent, text, length, this.defaultSpan);
    }

    public TextWrapper createLabelAndLeftNumberText(Composite parent, String text, int length, int limit) {
        this.createLabel(parent, text);
        return this.createLeftNumberText(parent, text, length, limit);
    }

    public DateChooserWrapper createLabelAndDateChooser(Composite parent, String text, int length) {
        this.createLabel(parent, text);
        return this.createDateChooser(parent, text, length, this.defaultSpan, true);
    }

    public ButtonWrapper createLabelAndCheckbox(Composite parent, String text) {
        this.createLabel(parent, text);
        return this.createButton(parent, "", text, 32);
    }

    public LabelWrapper createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, text, 0);
    }

    public LabelWrapper createLabel(Composite parent, String text, String tip) {
        return this.createLabel(parent, text, tip, 0);
    }

    public LabelWrapper createLabel(Composite parent, String text, int width) {
        return this.createLabel(parent, text, text, width);
    }

    public LabelWrapper createLabel(Composite parent, String text, String tip, int width) {
        LabelWrapper wrapper;
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        if (width > 0) {
            labelGridData.widthHint = width;
        }
        if (!(wrapper = new LabelWrapper(this.brands, parent, 131072)).isActive()) {
            return wrapper;
        }
        Label l = wrapper.getWidget();
        l.setText(text);
        l.setLayoutData((Object)labelGridData);
        l.setToolTipText(tip);
        return wrapper;
    }

    public LabelWrapper createClickableLabel(Composite parent, String text) {
        LabelWrapper wrapper;
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        labelGridData.verticalAlignment = 4;
        labelGridData.minimumHeight = 0;
        labelGridData.heightHint = 40;
        int width = 0;
        if (width > 0) {
            labelGridData.widthHint = width;
        }
        if (!(wrapper = new LabelWrapper(this.brands, parent, 16384)).isActive()) {
            return wrapper;
        }
        Label l = wrapper.getWidget();
        l.setText(text);
        l.setLayoutData((Object)labelGridData);
        return wrapper;
    }

    public LabelWrapper createLeftAllignedLabel(Composite parent, String text) {
        return this.createLeftAllignedLabel(parent, text, text, 0);
    }

    public LabelWrapper createLeftAllignedLabel(Composite parent, String text, String tip, int width) {
        LabelWrapper wrapper;
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        if (width > 0) {
            labelGridData.widthHint = width;
        }
        if (!(wrapper = new LabelWrapper(this.brands, parent, 16384)).isActive()) {
            return wrapper;
        }
        Label l = wrapper.getWidget();
        l.setText(text);
        l.setLayoutData((Object)labelGridData);
        l.setToolTipText(tip);
        return wrapper;
    }

    public LabelWrapper createPictureLabel(Composite parent, String text, String tip, Image image) {
        LabelWrapper labelWrapper1 = new LabelWrapper(this.brands, parent, 131072);
        Label l1 = labelWrapper1.getWidget();
        l1.setText(text);
        l1.setToolTipText(tip);
        LabelWrapper wrapper = new LabelWrapper(this.brands, parent, 16384);
        Label l = wrapper.getWidget();
        l.setToolTipText(tip);
        l.setBackgroundImage(image);
        return wrapper;
    }

    public LabelWrapper createTextLabel(Composite parent, String tip, int length, int limit) {
        GridData labelGridData = new GridData();
        labelGridData.grabExcessHorizontalSpace = false;
        labelGridData.widthHint = length;
        labelGridData.horizontalSpan = this.defaultSpan;
        LabelWrapper wrapper = new LabelWrapper(parent, 18432);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Label l = wrapper.getWidget();
        l.setLayoutData((Object)labelGridData);
        return wrapper;
    }

    public TextWrapper createTextSpan(Composite parent, String tip, int length, int limit, int spanWidth, int swtFormat) {
        GridData textGridData = new GridData();
        if (length == 0) {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
            textGridData.widthHint = 30;
        } else if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
            textGridData.minimumWidth = -length;
            textGridData.widthHint = -length;
        }
        textGridData.horizontalSpan = spanWidth;
        TextWrapper wrapper = new TextWrapper(this.brands, parent, 0x800 | swtFormat);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Text widget = wrapper.getWidget();
        if (limit > 0) {
            widget.setTextLimit(limit);
        }
        widget.setToolTipText(tip);
        widget.setLayoutData((Object)textGridData);
        this.enablingRegistry.addToDisableList((Control)widget);
        this.enablingRegistry.addToEnableList((Control)widget);
        widget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WidgetFactory.this.setChanged(true);
            }
        });
        return wrapper;
    }

    public TextWrapper createTextBlock(Composite parent, String tip, int length, int height, int limit, int swtFormat) {
        GridData textGridData = new GridData();
        if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        }
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        if (height > 0) {
            textGridData.minimumHeight = height;
            textGridData.heightHint = height;
        } else {
            textGridData.verticalAlignment = 4;
            textGridData.grabExcessVerticalSpace = true;
        }
        TextWrapper wrapper = new TextWrapper(this.brands, parent, 0x4800 | swtFormat);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Text widget = wrapper.getWidget();
        if (limit > 0) {
            widget.setTextLimit(limit);
        }
        widget.setToolTipText(tip);
        widget.setLayoutData((Object)textGridData);
        this.enablingRegistry.addToDisableList((Control)widget);
        this.enablingRegistry.addToEnableList((Control)widget);
        widget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WidgetFactory.this.setChanged(true);
            }
        });
        return wrapper;
    }

    public TextWrapper createText(Composite parent, String tip, int length, int limit) {
        TextWrapper wrapper = this.createTextSpan(parent, tip, length, limit, 1, 0);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        for (int i = 1; i < this.defaultSpan; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        return wrapper;
    }

    public TextWrapper createInfoText(Composite parent, String tip, int length) {
        GridData textGridData = new GridData();
        if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
        }
        TextWrapper wrapper = new TextWrapper(this.brands, parent, 18440);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Text widget = wrapper.getWidget();
        widget.setLayoutData((Object)textGridData);
        for (int i = 1; i < this.defaultSpan; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        return wrapper;
    }

    public TextWrapper createPasswordText(Composite parent, String tip, int length, int limit) {
        return this.createTextSpan(parent, tip, length, limit, this.defaultSpan, 0x400000);
    }

    public TextWrapper createCustomizedText(Composite parent, String tip, int length, int limit, int swtFormat) {
        return this.createTextSpan(parent, tip, length, limit, this.defaultSpan, swtFormat);
    }

    public FormattedTextWrapper createFormattedTextSpan(Composite parent, String tip, int length, int limit, int spanWidth, int swtFormat) {
        GridData textGridData = new GridData();
        if (length == 0) {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
        } else if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
            textGridData.minimumWidth = -length;
            textGridData.widthHint = -length;
        }
        textGridData.horizontalSpan = spanWidth;
        FormattedTextWrapper wrapper = new FormattedTextWrapper(this.brands, parent, 0x800 | swtFormat);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        final FormattedText widget = wrapper.getWidget();
        widget.getControl().setToolTipText(tip);
        if (limit > 0) {
            widget.getControl().setTextLimit(limit);
        }
        widget.getControl().setLayoutData((Object)textGridData);
        this.enablingRegistry.addToDisableList((Control)widget.getControl());
        this.enablingRegistry.addToEnableList((Control)widget.getControl());
        widget.getControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WidgetFactory.this.setChanged(true);
            }
        });
        widget.getControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                widget.getControl().setSelection(widget.getControl().getText().length(), 0);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        return wrapper;
    }

    public FormattedTextWrapper createCurrencyTextSpan(Composite parent, String tip, int length, int span) {
        String formatString = "-###,###,###,##0.00";
        FormattedTextWrapper wrapper = this.createFormattedTextSpan(parent, tip, length, 20, 1, 131072);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        wrapper.setNullAllowedNumberFormatter("-###,###,###,##0.00");
        for (int i = 1; i < span; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        return wrapper;
    }

    public FormattedTextWrapper createNullNotAllowedCurrencyTextSpan(Composite parent, String tip, int length, int span) {
        String formatString = "-###,###,###,##0.00";
        FormattedTextWrapper wrapper = this.createCurrencyTextSpan(parent, tip, length, span);
        wrapper.setNumberFormatter("-###,###,###,##0.00");
        return wrapper;
    }

    public FormattedTextWrapper createCurrencyText(Composite parent, String tip, int length) {
        return this.createCurrencyTextSpan(parent, tip, length, this.defaultSpan);
    }

    public FormattedTextWrapper createNullNotAllowedCurrencyText(Composite parent, String tip, int length) {
        return this.createNullNotAllowedCurrencyTextSpan(parent, tip, length, this.defaultSpan);
    }

    public TextWrapper createRightNumberText(Composite parent, String tip, int length, int limit) {
        TextWrapper wrapper = this.createNumberTextSpan(parent, tip, length, limit, 1, 131072);
        for (int i = 1; i < this.defaultSpan; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        return wrapper;
    }

    public TextWrapper createLeftNumberText(Composite parent, String tip, int length, int limit) {
        TextWrapper wrapper = this.createNumberTextSpan(parent, tip, length, limit, 1, 16384);
        for (int i = 1; i < this.defaultSpan; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        return wrapper;
    }

    public TextWrapper createLeftNumberTextSpan(Composite parent, String tip, int length, int limit, int span) {
        return this.createNumberTextSpan(parent, tip, length, limit, span, 16384);
    }

    public TextWrapper createRightNumberTextSpan(Composite parent, String tip, int length, int limit, int span) {
        return this.createNumberTextSpan(parent, tip, length, limit, span, 131072);
    }

    public TextWrapper createNumberTextSpan(Composite parent, String tip, int length, int limit, int span, int swtFormat) {
        TextWrapper wrapper = this.createTextSpan(parent, tip, length, limit, span, swtFormat);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Text widget = wrapper.getWidget();
        widget.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        return wrapper;
    }

    public TextWrapper createSignedRightNumberTextSpan(Composite parent, String tip, int length, int limit, int span) {
        return this.createSignedNumberTextSpan(parent, tip, length, limit, span, 131072);
    }

    public TextWrapper createSignedNumberTextSpan(Composite parent, String tip, int length, int limit, int span, int swtFormat) {
        TextWrapper wrapper = this.createTextSpan(parent, tip, length, limit, span, swtFormat);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Text widget = wrapper.getWidget();
        widget.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.getSource();
                String oldS = text.getText();
                String newS = oldS.substring(0, e.start) + e.text + oldS.substring(e.end);
                if (!Util.isEmpty(newS) && !newS.matches("[+-]{0,1}[0-9]{0,3}[,]{0,1}[0-9]{0,1}")) {
                    e.doit = false;
                }
            }
        });
        return wrapper;
    }

    public ComboWrapper createComboWithEmptyItem(Composite parent, Domain domain, String tip, int length, int limit) throws MappingException {
        return this.createComboSpan(parent, domain, tip, length, limit, false, this.defaultSpan, true, true);
    }

    public ComboWrapper createComboSpan(Composite parent, Domain domain, String tip, int length, int limit, boolean setChangedFlagWhenPressed, int span) throws MappingException {
        return this.createComboSpan(parent, domain, tip, length, limit, setChangedFlagWhenPressed, span, true, false);
    }

    public ComboWrapper createComboSpan(Composite parent, Domain domain, String tip, int length, int limit, boolean setChangedFlagWhenPressed, int span, boolean grap, boolean withEmptyItem) throws MappingException {
        GridData textGridData = new GridData();
        if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = grap;
        }
        textGridData.horizontalSpan = 1;
        final ComboWrapper wrapper = new ComboWrapper(this.brands, parent, domain, this.langtext, limit, 18440, withEmptyItem);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Combo widget = wrapper.getWidget();
        widget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                wrapper.onContentChanged();
            }
        });
        WidgetFactory.overrideDisabledColors((Control)widget);
        for (int i = 1; i < span; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        if (limit > 0) {
            widget.setTextLimit(limit);
        }
        widget.setToolTipText(tip);
        widget.setLayoutData((Object)textGridData);
        this.enablingRegistry.addToDisableList((Control)widget);
        this.enablingRegistry.addToEnableList((Control)widget);
        if (setChangedFlagWhenPressed) {
            widget.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WidgetFactory.this.setChanged(true);
                }
            });
        }
        return wrapper;
    }

    public ComboWrapper createCombo(Composite parent, Domain domain, String tip, int length, int limit, boolean setChangedFlagWhenPressed) throws MappingException {
        return this.createComboSpan(parent, domain, tip, length, limit, setChangedFlagWhenPressed, this.defaultSpan);
    }

    public ComboWrapper createCombo(Composite parent, Domain domain, String tip, int length, int limit) throws MappingException {
        return this.createCombo(parent, domain, tip, length, limit, true);
    }

    public ComboWrapper createUnregisteredCombo(Composite parent, Domain domain, String tip, int length, int limit) throws MappingException {
        return this.createCombo(parent, domain, tip, length, limit, false);
    }

    public ComboWrapper createCombo(Composite parent, String[] list, String tip, int length) {
        ComboWrapper wrapper = new ComboWrapper(this.brands, parent, list, 18440);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Combo widget = wrapper.getWidget();
        WidgetFactory.overrideDisabledColors((Control)widget);
        for (int i = 1; i < this.defaultSpan; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        GridData textGridData = new GridData();
        if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
        }
        textGridData.horizontalSpan = 1;
        widget.setItems(list);
        widget.setToolTipText(tip);
        widget.setLayoutData((Object)textGridData);
        this.enablingRegistry.addToDisableList((Control)widget);
        this.enablingRegistry.addToEnableList((Control)widget);
        return wrapper;
    }

    public ComboWrapper createWritableCombo(Composite parent, String[] list, String tip, int length) {
        ComboWrapper wrapper = new ComboWrapper(this.brands, parent, list, 18436);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Combo widget = wrapper.getWidget();
        WidgetFactory.overrideDisabledColors((Control)widget, -1, -4);
        for (int i = 1; i < this.defaultSpan; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        GridData textGridData = new GridData();
        if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
        }
        textGridData.horizontalSpan = 1;
        widget.setItems(list);
        widget.setToolTipText(tip);
        widget.setLayoutData((Object)textGridData);
        this.enablingRegistry.addToDisableList((Control)widget);
        this.enablingRegistry.addToEnableList((Control)widget);
        return wrapper;
    }

    public DateChooserWrapper createDateChooser(Composite parent, String tip, int length) {
        return this.createDateChooser(parent, tip, length, this.defaultSpan, true);
    }

    public DateChooserWrapper createDateChooser(Composite parent, String tip, int length, int span) {
        return this.createDateChooser(parent, tip, length, span, true);
    }

    public DateChooserWrapper createDateChooser(Composite parent, String tip, int length, int span, boolean grap) {
        DateChooserWrapper wrapper = new DateChooserWrapper(this.brands, parent, 16384);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        final AdvancedDateChooser widget = wrapper.getWidget();
        GridData textGridData = new GridData();
        if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = grap;
        }
        textGridData.horizontalSpan = 1;
        String dateTip = "Datum im Format TT.MM.JJJJ oder TT.MM.JJ oder TTMMJJ oder TTMMJJJJ\nF1 = aktuelles Datum\nF2 = fiktives Buchungsdatum";
        tip = Util.isEmpty(tip) ? dateTip : tip + "\n" + dateTip;
        Control[] c = widget.getChildren();
        if (c.length > 0 && c[0] != null) {
            ((Text)c[0]).setToolTipText(tip);
        }
        for (int i = 1; i < span; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        widget.setDate(null);
        widget.setInvalidInputBehaviour(2);
        widget.setFieldIdentifier((IFieldIdentifier)new SimpleFieldIdentifier(".", new int[]{5, 2, 1}));
        widget.setLayoutData(textGridData);
        this.enablingRegistry.addToDisableList((Control)widget);
        this.enablingRegistry.addToEnableList((Control)widget);
        widget.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EnablingRegistry.isEnabled((Object)widget) && !Util.equals(Converter.dateToString(widget.getInitialValue()), Converter.dateToString(widget.getDate()))) {
                    WidgetFactory.this.setChanged(true);
                }
            }
        });
        return wrapper;
    }

    public TimeChooserWrapper createTimeChooser(Composite parent, String tip, int length) {
        return this.createTimeChooser(parent, tip, length, this.defaultSpan);
    }

    public TimeChooserWrapper createTimeChooser(Composite parent, String tip, int length, int span) {
        TimeChooserWrapper wrapper = new TimeChooserWrapper(this.brands, parent, 16384);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        final AdvancedTimeChooser widget = wrapper.getWidget();
        GridData textGridData = new GridData();
        if (length > 0) {
            textGridData.minimumWidth = length;
            textGridData.widthHint = length;
        } else {
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
        }
        textGridData.horizontalSpan = 1;
        if (Util.isEmpty(tip)) {
            tip = "Uhrzeit im Format 'HH:MM'";
        }
        for (int i = 1; i < span; ++i) {
            new LabelWrapper(this.brands, parent);
        }
        widget.setDate(null);
        widget.setInvalidInputBehaviour(1);
        widget.setFieldIdentifier((IFieldIdentifier)new SimpleFieldIdentifier(".", new int[]{5, 2, 1}));
        widget.setLayoutData(textGridData);
        this.enablingRegistry.addToDisableList((Control)widget);
        this.enablingRegistry.addToEnableList((Control)widget);
        widget.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (EnablingRegistry.isEnabled((Object)widget)) {
                    WidgetFactory.this.setChanged(true);
                }
            }
        });
        return wrapper;
    }

    public ButtonWrapper createPushButton(Composite parent, String text, String tip, Resources.ICON image, boolean setChangedFlagWhenPressed, boolean forceSmall) {
        ButtonWrapper wrapper = image == null && Util.isEmpty(text) || forceSmall ? new ButtonWrapper(this.brands, parent, 8, true) : new ButtonWrapper(this.brands, parent, 8, false);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Button button = wrapper.getWidget();
        button.setToolTipText(tip);
        if (image == null) {
            if (Util.isEmpty(text)) {
                button.setText(". . .");
            } else {
                button.setText(text);
            }
        } else {
            button.setImage(Resources.getInstance().getImage(image));
        }
        this.enablingRegistry.addToDisableList((Control)button);
        this.enablingRegistry.addToEnableList((Control)button);
        if (setChangedFlagWhenPressed) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WidgetFactory.this.setChanged(true);
                }
            });
        }
        return wrapper;
    }

    public LabelWrapper createAnalyseText(Composite parent, String text) {
        LabelWrapper t = this.createLeftAllignedLabel(parent, text);
        return t;
    }

    public ButtonWrapper createAnalyseButton(Composite parent, String text) {
        ButtonWrapper wrapper;
        Resources.ICON image = null;
        boolean setChangedFlagWhenPressed = false;
        boolean forceSmall = false;
        String tip = "";
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 4;
        buttonGridData.verticalAlignment = 4;
        buttonGridData.verticalIndent = 0;
        buttonGridData.heightHint = 40;
        buttonGridData.grabExcessHorizontalSpace = true;
        int width = 0;
        if (width > 0) {
            buttonGridData.widthHint = width;
        }
        if (!(wrapper = image == null && Util.isEmpty(text) || forceSmall ? new ButtonWrapper(this.brands, parent, 8, true) : new ButtonWrapper(this.brands, parent, 8, false)).isActive()) {
            return wrapper;
        }
        Button button = wrapper.getWidget();
        button.setToolTipText(tip);
        if (image == null) {
            if (Util.isEmpty(text)) {
                button.setText(". . .");
            } else {
                button.setText(text);
            }
        } else {
            button.setImage(Resources.getInstance().getImage(image));
        }
        button.setLayoutData((Object)buttonGridData);
        button.setAlignment(16384);
        this.enablingRegistry.addToDisableList((Control)button);
        this.enablingRegistry.addToEnableList((Control)button);
        if (setChangedFlagWhenPressed) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WidgetFactory.this.setChanged(true);
                }
            });
        }
        return wrapper;
    }

    public ButtonWrapper createSmallPushButton(Composite parent, String tip, Resources.ICON image) {
        return this.createPushButton(parent, "", tip, image, true, true);
    }

    public ButtonWrapper createUnregisteredSmallPushButton(Composite parent, String tip, Resources.ICON image) {
        return this.createPushButton(parent, "", tip, image, false, true);
    }

    public ButtonWrapper createPushButton(Composite parent, String tip, Resources.ICON image) {
        return this.createPushButton(parent, "", tip, image, true, false);
    }

    public ButtonWrapper createUnregisteredPushButton(Composite parent, String tip, Resources.ICON image) {
        return this.createPushButton(parent, "", tip, image, false, false);
    }

    public ButtonWrapper createPushButton(Composite parent, String text, String tip, Resources.ICON image) {
        return this.createPushButton(parent, text, tip, image, true, false);
    }

    public ButtonWrapper createUnregisteredPushButton(Composite parent, String text, String tip, Resources.ICON image) {
        return this.createPushButton(parent, text, tip, image, false, false);
    }

    public ButtonWrapper createUnregisteredFillPushButton(Composite parent, String text, String tip, Resources.ICON image) {
        ButtonWrapper bw = this.createPushButton(parent, text, tip, image, false, false);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        bw.getWidget().setLayoutData((Object)gd);
        return bw;
    }

    public ButtonWrapper createCheckbox(Composite parent, String text, String tip) {
        if (Util.isEmpty(tip) && !Util.isEmpty(text)) {
            tip = text;
        }
        return this.createButton(parent, text, tip, 32);
    }

    public ButtonWrapper createCheckbox(Composite parent, String tip) {
        return this.createButton(parent, "", tip, 32);
    }

    public ButtonWrapper createRadiobox(Composite parent, String text, String tip) {
        if (Util.isEmpty(tip) && !Util.isEmpty(text)) {
            tip = text;
        }
        return this.createButton(parent, text, tip, 16);
    }

    public ButtonWrapper createRadiobox(Composite parent, String tip) {
        return this.createButton(parent, "", tip, 16);
    }

    public ButtonWrapper createButton(Composite parent, String text, String tip, int type) {
        GridData gridData = new GridData();
        gridData.horizontalSpan = this.defaultSpan;
        ButtonWrapper wrapper = new ButtonWrapper(this.brands, parent, type, false);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        Button button = wrapper.getWidget();
        if (!Util.isEmpty(text)) {
            button.setText(text);
        }
        button.setToolTipText(tip);
        button.setLayoutData((Object)gridData);
        this.enablingRegistry.addToDisableList((Control)button);
        this.enablingRegistry.addToEnableList((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WidgetFactory.this.setChanged(true);
            }
        });
        return wrapper;
    }

    public TextWrapper createTextBlock(Composite parent, String groupText) {
        return this.createTextBlock(parent, groupText, TEXTBLOCKHIGHT, 2, 0);
    }

    public TextWrapper createTextBlock(Composite parent, String groupText, int height, int span, int style) {
        log.debug((Object)"WidgetFactory - W1");
        log.debug((Object)("WidgetFactory - height=" + height + " span=" + span + " style=" + style));
        GridData groupGridData = new GridData(1808);
        groupGridData.horizontalSpan = span;
        groupGridData.grabExcessVerticalSpace = true;
        log.debug((Object)"WidgetFactory - W2");
        if (height > 0) {
            groupGridData.heightHint = height;
        }
        log.debug((Object)"WidgetFactory - W3");
        Group group = GuiContainer.newGroup(parent, 0);
        log.debug((Object)"WidgetFactory - W4");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)groupGridData);
        log.debug((Object)"WidgetFactory - W5");
        group.setText(groupText);
        log.debug((Object)"WidgetFactory - W6");
        TextWrapper wrapper = new TextWrapper(this.brands, (Composite)group, 0x42 | style);
        log.debug((Object)"WidgetFactory - W7");
        if (!wrapper.isActive()) {
            return wrapper;
        }
        log.debug((Object)"WidgetFactory - W8");
        wrapper.getWidget().setLayoutData((Object)new GridData(1808));
        log.debug((Object)"WidgetFactory - W9");
        wrapper.getWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WidgetFactory.this.setChanged(true);
            }
        });
        this.enablingRegistry.addToDisableList((Control)wrapper.getWidget());
        this.enablingRegistry.addToEnableList((Control)wrapper.getWidget());
        return wrapper;
    }

    public BrowserWrapper createBrowserBlock(Composite parent, String groupText, int height, int width, int span, int style) {
        GridData groupGridData = new GridData(1808);
        groupGridData.horizontalSpan = span;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.grabExcessVerticalSpace = true;
        if (height > 0) {
            groupGridData.heightHint = height;
        }
        if (width > 0) {
            groupGridData.widthHint = width;
        }
        Group group = GuiContainer.newGroup(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)groupGridData);
        group.setText(groupText);
        log.debug((Object)"Vor Browser-Wrapper");
        BrowserWrapper wrapper = new BrowserWrapper(this.brands, (Composite)group, 0x42 | style);
        log.debug((Object)"Nach Browser-Wrapper");
        if (!wrapper.isActive()) {
            return wrapper;
        }
        wrapper.getWidget().setLayoutData((Object)new GridData(1808));
        this.enablingRegistry.addToDisableList((Control)wrapper.getWidget());
        this.enablingRegistry.addToEnableList((Control)wrapper.getWidget());
        return wrapper;
    }

    public TextWrapper createScrollTextBlock(Composite parent, String groupText, int height, int span) {
        GridData groupGridData = new GridData(1808);
        groupGridData.horizontalSpan = span;
        groupGridData.heightHint = height;
        Group group = GuiContainer.newGroup(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)groupGridData);
        group.setText(groupText);
        TextWrapper wrapper = new TextWrapper(this.brands, (Composite)group, 578);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        wrapper.getWidget().setLayoutData((Object)new GridData(1808));
        this.enablingRegistry.addToDisableList((Control)wrapper.getWidget());
        this.enablingRegistry.addToEnableList((Control)wrapper.getWidget());
        wrapper.getWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WidgetFactory.this.setChanged(true);
            }
        });
        return wrapper;
    }

    public StyledTextWrapper createScrollTextBlock1(Composite parent, String groupText, int height, int width, int span) {
        GridData groupGridData = new GridData(1808);
        groupGridData.horizontalSpan = span;
        groupGridData.heightHint = height;
        groupGridData.widthHint = width;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.grabExcessVerticalSpace = true;
        Group group = GuiContainer.newGroup(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)groupGridData);
        group.setText(groupText);
        StyledTextWrapper wrapper = new StyledTextWrapper(this.brands, (Composite)group, 770);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        wrapper.getWidget().setLayoutData((Object)new GridData(1808));
        return wrapper;
    }

    public TextWrapper createInfoBlock(Composite parent, String groupText) {
        return this.createInfoBlock(parent, groupText, TEXTBLOCKHIGHT, 0, 2, false);
    }

    public TextWrapper createScrollInfoBlock(Composite parent, String groupText) {
        return this.createInfoBlock(parent, groupText, TEXTBLOCKHIGHT, 0, 2, true);
    }

    public TextWrapper createInfoBlock(Composite parent, String groupText, int height, int width, int span, boolean scroll) {
        TextWrapper wrapper;
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = span;
        if (height > 0) {
            groupGridData.heightHint = height;
        }
        if (width > 0) {
            groupGridData.widthHint = width;
        }
        Group group = GuiContainer.newGroup(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)groupGridData);
        group.setText(groupText);
        int style = 74;
        if (scroll) {
            style = style | 0x200 | 0x100;
        }
        if (!(wrapper = new TextWrapper(this.brands, (Composite)group, style)).isActive()) {
            return wrapper;
        }
        wrapper.getWidget().setLayoutData((Object)new GridData(1808));
        return wrapper;
    }

    public TextWrapper createInfoBlock(Composite parent, String groupText, int span) {
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = span;
        groupGridData.heightHint = 90;
        Group group = GuiContainer.newGroup(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)groupGridData);
        group.setText(groupText);
        TextWrapper wrapper = new TextWrapper(this.brands, (Composite)group, 74);
        if (!wrapper.isActive()) {
            return wrapper;
        }
        wrapper.getWidget().setLayoutData((Object)new GridData(1808));
        return wrapper;
    }

    public Composite createRowComposite(Composite parent, int columns) {
        if (!ApplicationProperties.getInstance().hasBrand(this.brands)) {
            return null;
        }
        return this.createRowComposite(parent, columns, 1);
    }

    public Composite createRowComposite(Composite parent, int columns, int span) {
        if (!ApplicationProperties.getInstance().hasBrand(this.brands)) {
            return null;
        }
        Composite rowComposite = new Composite(parent, 0);
        GridLayout rowLayout = new GridLayout();
        rowLayout.numColumns = columns;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        GridData rowData1 = new GridData(768);
        rowData1.horizontalSpan = span;
        rowData1.horizontalAlignment = 4;
        rowData1.grabExcessHorizontalSpace = true;
        rowComposite.setLayout((Layout)rowLayout);
        rowComposite.setLayoutData((Object)rowData1);
        return rowComposite;
    }

    public void enableAllWidgets() {
        this.enablingRegistry.enableAllElements();
    }

    public void disableAllWidgets() {
        this.enablingRegistry.disableAllElements();
    }

    public void disableOneWidget(Control widget) {
        if (widget != null) {
            this.enablingRegistry.removeFromDisabledList(widget);
            this.enablingRegistry.disableOneElement(widget);
        }
    }

    public void enableOneWidget(Control widget) {
        if (widget != null) {
            if (!this.enablingRegistry.disabled) {
                this.enablingRegistry.enableOneElement(widget);
            } else {
                this.enablingRegistry.addToDisabledList(widget);
            }
        }
    }

    public void disableOneWidget(IWrapper<?> wrapper) {
        if (wrapper != null) {
            this.disableOneWidget(wrapper.getControlWidget());
        }
    }

    public void enableOneWidget(IWrapper<?> wrapper) {
        if (wrapper != null) {
            if (!PermissionHandler.getInstance().isElementAllowd(PageFlowController.getInstance().getCurrentPage(), wrapper.getId())) {
                this.disableOneWidget(wrapper.getControlWidget());
                return;
            }
            this.enableOneWidget(wrapper.getControlWidget());
        }
    }

    public void forceEnableOneWidget(IWrapper<?> wrapper) {
        if (wrapper != null) {
            this.forceEnableOneWidget((Control)wrapper.getWidget());
        }
    }

    public void forceEnableOneWidget(Control widget) {
        if (widget != null) {
            this.enablingRegistry.enableOneElement(widget);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enableAllWidgets();
        } else {
            this.disableAllWidgets();
        }
    }

    public static void overrideDisabledColors(Control aControl, final int offsetX, final int offsetY) {
        aControl.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent theE) {
                Combo combo;
                int _y;
                int _x;
                String _text;
                Control _c = (Control)theE.widget;
                Point _controlSize = _c.getSize();
                if (theE.widget instanceof Text) {
                    _text = ((Text)theE.widget).getText();
                    if (((Text)theE.widget).getEditable() && ((Text)theE.widget).getEnabled()) {
                        return;
                    }
                    Point _textSize = theE.gc.stringExtent(_text);
                    _x = _c.getBorderWidth() + 2;
                    _y = (_controlSize.y - _textSize.y) / 2 - _c.getBorderWidth();
                } else if (theE.widget instanceof Combo) {
                    combo = (Combo)theE.widget;
                    System.out.print("Event ");
                    log.debug((Object)"ausgef\u00fchrt");
                    log.debug((Object)("getBackgroundMode =" + combo.getBackgroundMode()));
                    log.debug((Object)("getBounds =" + combo.getBounds()));
                    log.debug((Object)("getSize =" + combo.getSize()));
                    log.debug((Object)("getBorderWidth =" + combo.getBorderWidth()));
                    log.debug((Object)("getClientArea =" + combo.getClientArea()));
                    log.debug((Object)("getLocation =" + combo.getLocation()));
                    log.debug((Object)("_controlSize.x " + _controlSize.x));
                    log.debug((Object)("_controlSize.y " + _controlSize.y));
                    log.debug((Object)("getChildren() " + combo.getChildren().length));
                    log.debug((Object)("getChildren() " + combo.getMenu()));
                    if (_c.getEnabled()) {
                        log.debug((Object)"abgebrochen");
                        return;
                    }
                    _text = ((Combo)theE.widget).getText();
                    Point _textSize = theE.gc.stringExtent(_text);
                    log.debug((Object)("_textSize.y " + _textSize.y));
                    log.debug((Object)("_textSize.x " + _textSize.x));
                    theE.gc.getClass();
                    _x = _c.getBorderWidth() + 4;
                    _y = (_controlSize.y - _textSize.y) / 2 - _c.getBorderWidth();
                } else if (theE.widget instanceof CCombo) {
                    combo = (CCombo)theE.widget;
                    System.out.print("Event ");
                    log.debug((Object)"ausgef\u00fchrt");
                    log.debug((Object)("getBackgroundMode =" + combo.getBackgroundMode()));
                    log.debug((Object)("getBounds =" + combo.getBounds()));
                    log.debug((Object)("getSize =" + combo.getSize()));
                    log.debug((Object)("getBorderWidth =" + combo.getBorderWidth()));
                    log.debug((Object)("getClientArea =" + combo.getClientArea()));
                    log.debug((Object)("getLocation =" + combo.getLocation()));
                    log.debug((Object)("_controlSize.x " + _controlSize.x));
                    log.debug((Object)("_controlSize.y " + _controlSize.y));
                    log.debug((Object)("getChildren() " + combo.getChildren().length));
                    log.debug((Object)("getChildren() " + combo.getMenu()));
                    if (_c.getEnabled()) {
                        log.debug((Object)"abgebrochen");
                        return;
                    }
                    _text = ((CCombo)theE.widget).getText();
                    Point _textSize = theE.gc.stringExtent(_text);
                    log.debug((Object)("_textSize.y " + _textSize.y));
                    log.debug((Object)("_textSize.x " + _textSize.x));
                    theE.gc.getClass();
                    _x = _c.getBorderWidth() + 4;
                    _y = (_controlSize.y - _textSize.y) / 2 - _c.getBorderWidth();
                } else {
                    return;
                }
                theE.gc.setForeground(fgDisabledColor);
                Rectangle r = _c.getBounds();
                r.y = 3;
                r.x = 0;
                r.width = _controlSize.x;
                r.height = _controlSize.y;
                theE.gc.setClipping(r);
                theE.gc.drawText(_text, _x + offsetX, _y + offsetY, true);
            }
        });
    }

    public static void overrideDisabledColors(Control aControl) {
        aControl.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent theE) {
                int _y;
                int _x;
                String _text;
                Control _c = (Control)theE.widget;
                Point _controlSize = _c.getSize();
                if (theE.widget instanceof Text) {
                    _text = ((Text)theE.widget).getText();
                    if (((Text)theE.widget).getEditable() && ((Text)theE.widget).getEnabled()) {
                        return;
                    }
                    Point _textSize = theE.gc.stringExtent(_text);
                    _x = _c.getBorderWidth() + 2;
                    _y = (_controlSize.y - _textSize.y) / 2 - _c.getBorderWidth();
                } else if (theE.widget instanceof Combo) {
                    if (_c.getEnabled()) {
                        return;
                    }
                    _text = ((Combo)theE.widget).getText();
                    Point _textSize = theE.gc.stringExtent(_text);
                    _x = _c.getBorderWidth() + 4;
                    _y = (_controlSize.y - _textSize.y) / 2 - _c.getBorderWidth();
                } else {
                    return;
                }
                theE.gc.setForeground(fgDisabledColor);
                theE.gc.drawText(_text, _x, _y, true);
            }
        });
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public int getDefaultSpan() {
        return this.defaultSpan;
    }

    public void setDefaultSpan(int defaultSpan) {
        this.defaultSpan = defaultSpan;
    }

    public void refresh() {
        if (this.enablingRegistry.disabled) {
            this.enablingRegistry.disableAllElements();
        }
    }

    public boolean isEnabled() {
        return !this.enablingRegistry.disabled;
    }

    public Brand[] getBrands() {
        return this.brands;
    }

    public void setBrands(Brand[] brands) {
        this.brands = brands;
    }

    public void setBrand(Brand brand) {
        this.brands = new Brand[1];
        this.brands[0] = brand;
    }

    public void resetBrand() {
        this.brands = null;
    }

    public boolean isLangtext() {
        return this.langtext;
    }

    public void setLangtext(boolean langtext) {
        this.langtext = langtext;
    }
}

