/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.paint;

import de.cni.client.gui.util.Resources;
import de.cni.client.paint.Controlpanel;
import de.cni.client.paint.Disposer;
import de.cni.client.paint.IconFactory;
import de.cni.client.paint.Leinwand;
import de.cni.client.paint.PaintRawData;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.astrologie.Jahresring;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.Aspektarium;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.OrbisCache;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.exceptions.TechnicalException;
import java.util.Date;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class AstroLeinwand
extends Leinwand {
    private Controlpanel controlpanel;
    private Personendaten personendaten;
    private int radius1;
    private int radius2;
    private int radius3;
    private int radius4;
    private int radius5;
    private int radius6;
    private int radius7;
    private int radius8;
    private int radiusPlaneten1;
    private int radiusPlaneten2;
    private int radiusSchablone;
    private IconFactory iconFactory;
    private HoroskopCalculator horoskopCalculator;
    private OrbisCache orbisCache;
    private OrbisCache interOrbisCache;
    private boolean paperVersion = false;
    private Aspektarium aspektarium1;
    private Aspektarium aspektarium2;
    private Aspektarium interaspektarium;

    public AstroLeinwand(PaintRawData paintRawData) throws TechnicalException {
        super(paintRawData);
        if (!(paintRawData.getObjectList().get(0) instanceof Controlpanel)) {
            throw new TechnicalException("Die Klasse AstroLeinwand erwartet als 1. Raw-Parameter eine Controlpanel-Objekt");
        }
        if (!(paintRawData.getObjectList().get(1) instanceof HoroskopCalculator)) {
            throw new TechnicalException("Die Klasse AstroLeinwand erwartet als 2. Raw-Parameter ein HoroskopCalculator-Objekt");
        }
        this.controlpanel = (Controlpanel)paintRawData.getObjectList().get(0);
        this.horoskopCalculator = (HoroskopCalculator)paintRawData.getObjectList().get(1);
        this.orbisCache = this.controlpanel.getOrbisCache();
        this.interOrbisCache = this.controlpanel.getInterOrbisCache();
        this.personendaten = this.horoskopCalculator.getPd1();
        this.iconFactory = new IconFactory();
        this.radius1 = 15;
        this.radius2 = 50;
        this.radius3 = 90;
        this.radius4 = this.round(0.65 * (double)this.maxRadius);
        this.radius5 = this.round(0.8 * (double)this.maxRadius);
        this.radius6 = this.round(0.8 * (double)this.maxRadius);
        this.radius7 = this.round(0.84 * (double)this.maxRadius);
        this.radius8 = this.round(0.94 * (double)this.maxRadius);
        this.radiusPlaneten1 = this.round(0.4 * (double)this.maxRadius);
        this.radiusPlaneten2 = this.round(0.4 * (double)this.maxRadius);
        this.radiusSchablone = this.round(0.9 * (double)this.radius4);
    }

    @Override
    public void paint() {
        this.horoskopCalculator.getClickKoordinaten().initializeGuiInfo(this.controlpanel, this.xCenter, this.yCenter, this.radius2, this.radius3, this.radiusPlaneten1, this.radiusPlaneten2, this.radius4, this.radius5);
        this.gc.setLineWidth(this.controlpanel.getLineWidth());
        this.gc.setAntialias(1);
        this.gc.setAdvanced(true);
        this.gc.setTextAntialias(1);
        if (!this.paperVersion && this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1) {
            if (this.horoskopCalculator.getPd2() != null) {
                this.gc.setFont(this.font10);
                this.gc.setForeground(this.cf.colorBlack);
                super.absoluteText("Person1 = " + this.horoskopCalculator.getPd1().getVorname() + " " + this.horoskopCalculator.getPd1().getNachname(), 20, 5);
                this.gc.setForeground(this.cf.colorRed);
                super.absoluteText("Person 2 = " + this.horoskopCalculator.getPd2().getVorname() + " " + this.horoskopCalculator.getPd2().getNachname(), 20, 20);
                this.gc.setForeground(this.cf.colorBlack);
            } else {
                this.gc.setFont(this.font10);
                this.gc.setForeground(this.cf.colorBlack);
                super.absoluteText(Converter.dateToString(this.horoskopCalculator.getDate1()), 20, 5);
                this.gc.setForeground(this.cf.colorRed);
                super.absoluteText(Converter.dateToString(this.horoskopCalculator.getDate2()), 20, 20);
            }
        }
        this.zentrum();
        Date geburtsdatum = null;
        if (this.horoskopCalculator.getPd1() != null) {
            geburtsdatum = this.horoskopCalculator.getPd1().getGeburtsdatum();
        }
        this.jahresringe(geburtsdatum, this.horoskopCalculator.getAstrodaten1());
        this.monatsringe(geburtsdatum, DateUtil.getToday(), this.horoskopCalculator.getAstrodaten1());
        this.septarringe(geburtsdatum, this.horoskopCalculator.getRelevantDate(), this.horoskopCalculator.getAstrodaten1());
        this.Zwischenskala(this.horoskopCalculator.getAstrodaten1());
        this.Tierkreiszeichen(this.horoskopCalculator.getAstrodaten1());
        this.haeuser(this.horoskopCalculator.getAstrodaten1());
        this.innerCircle();
        if (this.controlpanel.isHoroskop1()) {
            this.drawAcMc(this.horoskopCalculator.getHoroskop(), this.horoskopCalculator.getAstrodaten1(), Satz.Person1);
            this.planeten(this.horoskopCalculator.getAstrodaten1(), this.radiusPlaneten1, Satz.Person1);
        }
        if (this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1 && this.controlpanel.isHoroskop2()) {
            this.drawAcMc(this.horoskopCalculator.getHoroskop(), this.horoskopCalculator.getAstrodaten2(), Satz.Person2);
            this.planeten(this.horoskopCalculator.getAstrodaten2(), this.radiusPlaneten2, Satz.Person2);
        }
        this.aspektarium1 = null;
        this.aspektarium2 = null;
        this.interaspektarium = null;
        if (this.controlpanel.isAspekte1()) {
            this.aspektarium1 = this.aspekte(this.horoskopCalculator.getAstrodaten1(), Satz.Person1);
        }
        if (this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1 && this.controlpanel.isAspekte2()) {
            this.aspektarium2 = this.aspekte(this.horoskopCalculator.getAstrodaten2(), Satz.Person2);
        }
        if (this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1 && this.controlpanel.isInterAspekte()) {
            this.interaspektarium = this.interAspekte(this.horoskopCalculator.getAstrodaten1(), this.horoskopCalculator.getAstrodaten2());
        }
        if (this.controlpanel.isSchablone()) {
            int idx;
            double grad;
            Astrodaten ad;
            if (this.controlpanel.getSchablonePlanetIdSatz1() >= 0) {
                ad = this.horoskopCalculator.getAstrodaten1();
                grad = 0.0;
                idx = this.controlpanel.getSchablonePlanetIdSatz1();
                if (idx < 10) {
                    grad = ad.getPlanetAbs(idx);
                } else if (idx == 10) {
                    grad = ad.housesInfo.getAcAbs();
                } else if (idx == 11) {
                    grad = Trigo.grad(ad.housesInfo.getAcAbs() + 180.0);
                } else if (idx == 12) {
                    grad = ad.housesInfo.getMcAbs();
                } else if (idx == 13) {
                    grad = Trigo.grad(ad.housesInfo.getMcAbs() + 180.0);
                }
                this.controlpanel.setSchabloneAlpha(Trigo.grad(grad + ad.getOffset()));
            }
            if (this.controlpanel.getSchablonePlanetIdSatz2() >= 0) {
                ad = this.horoskopCalculator.getAstrodaten2();
                grad = 0.0;
                idx = this.controlpanel.getSchablonePlanetIdSatz2();
                if (idx < 10) {
                    grad = ad.getPlanetAbs(idx);
                } else if (idx == 10) {
                    grad = ad.housesInfo.getAcAbs();
                } else if (idx == 11) {
                    grad = Trigo.grad(ad.housesInfo.getAcAbs() + 180.0);
                } else if (idx == 12) {
                    grad = ad.housesInfo.getMcAbs();
                } else if (idx == 13) {
                    grad = Trigo.grad(ad.housesInfo.getMcAbs() + 180.0);
                }
                this.controlpanel.setSchabloneAlpha(Trigo.grad(grad + ad.getOffset()));
            }
            double winkel = this.controlpanel.getSchabloneAlpha();
            Astrodaten ad2 = this.horoskopCalculator.getAstrodaten1();
            double ac = ad2.housesInfo.getAc();
            this.controlpanel.setSchabloneWinkelAsString(FormatterGradzahlen.format(FormatterGradzahlen.undoTransfer(winkel, ac)));
            this.drawSchablone(winkel);
        }
        this.horoskopCalculator.getClickKoordinaten().initializeAspektarium(this.aspektarium1, this.aspektarium2, this.interaspektarium);
    }

    private void innerCircle() {
        this.alphaOffset = 0.0;
        this.setAlphaOffset(null, 0.0);
        this.orientation = Leinwand.Orientation.Uhrzeiger;
        this.gc.setFont(this.font10);
        this.gc.setForeground(this.cf.colorBlack);
        int fadenkreuz = 3;
        this.gc.setBackground(this.cf.colorWhite);
        super.astroFillCircle(this.radius1);
        super.astroLineGrad(0.0, fadenkreuz);
        super.astroLineGrad(90.0, fadenkreuz);
        super.astroLineGrad(180.0, fadenkreuz);
        super.astroLineGrad(270.0, fadenkreuz);
        super.astroCircle(this.radius1);
    }

    private void zentrum() {
        this.gc.setForeground(this.cf.colorBlack);
        super.astroCircle(this.radius8);
    }

    private void drawAcMc(Horoskop horoskop, Astrodaten astrodaten, Satz satz) {
        if (satz == Satz.Person1 || horoskop == Horoskop.Synastrie || this.controlpanel.isZweiterAcMc()) {
            this.setAlphaOffset(astrodaten, 0.0);
            Color color = this.getAcMcColor(satz);
            this.drawAcMcWorker(astrodaten.housesInfo.getAcAbs(), 2.0, "AC", "DC", color);
            this.drawAcMcWorker(astrodaten.housesInfo.getMcAbs(), 2.0, "MC", "IC", color);
        }
    }

    private Color getAcMcColor(Satz satz) {
        Color color = this.cf.colorViolet;
        if (this.horoskopCalculator.getHoroskop() == Horoskop.Transit || this.horoskopCalculator.getHoroskop() == Horoskop.Synastrie) {
            if (satz == Satz.Person1) {
                color = this.cf.colorBlack;
            } else if (satz == Satz.Person2) {
                color = this.cf.colorRed;
            }
        }
        return color;
    }

    private void drawAcMcWorker(double alpha, double declination, String text1, String text2, Color color) {
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        this.gc.setForeground(color);
        super.astroLineGrad(alpha, this.radius1, this.maxRadius);
        super.astroLineGrad(alpha + 180.0, this.radius1, this.maxRadius);
        if (this.isMedium() && !this.isPaperVersion()) {
            this.gc.setFont(this.font8);
            super.astroScaleTextGrad(alpha + declination, this.maxRadius - 13, 0.0, text1);
            super.astroScaleTextGrad(alpha + 180.0 + declination, this.maxRadius - 19, 0.0, text2);
        } else {
            this.gc.setFont(this.font10);
            super.astroScaleTextGrad(alpha + declination, (double)this.maxRadius * 0.959, 0.0, text1);
            super.astroScaleTextGrad(alpha + 180.0 + declination, (double)this.maxRadius * 0.959, 0.0, text2);
        }
    }

    private void Zwischenskala(Astrodaten astrodaten) {
        int i;
        if (!this.controlpanel.isZwischenskala()) {
            return;
        }
        this.alphaOffset = 0.0;
        this.setAlphaOffset(astrodaten, 0.0);
        this.orientation = Leinwand.Orientation.Uhrzeiger;
        this.gc.setForeground(this.cf.colorBlack);
        this.astroCircle(this.round(this.radius6));
        int maxStrokeLen = this.radius7 - this.radius6 - 4;
        for (i = 0; i < 360; i += 2) {
            super.astroScaleGrad(i, this.round(this.radius6 + maxStrokeLen / 4), maxStrokeLen / 2);
        }
        for (i = 0; i < 360; i += 10) {
            super.astroScaleGrad(i, this.round(this.radius6 + maxStrokeLen / 2), maxStrokeLen);
        }
    }

    private void planeten(Astrodaten astrodaten, int radiusPlanet, Satz satz) {
        this.setAlphaOffset(astrodaten, 0.0);
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        this.gc.setForeground(this.cf.colorBlack);
        this.gc.setFont(this.font8Bold);
        super.astroCircle(this.radius2);
        super.astroCircle(this.radius3);
        for (int i = 0; i < 10; ++i) {
            int offset;
            if (satz == Satz.Person1 && !this.controlpanel.getPlaneten1()[i] || satz == Satz.Person2 && !this.controlpanel.getPlaneten2()[i]) continue;
            if (i == 8) {
                // empty if block
            }
            this.gc.setForeground(this.cf.colorBlack);
            double longitude = astrodaten.getPlanetAbs(i);
            this.gc.setForeground(this.cf.colorRed);
            int length = 10;
            this.gc.setForeground(this.cf.colorBlack);
            if (this.controlpanel.getIconTypeId() == 1) {
                this.gc.setFont(this.getPlanetenTextFont(this.controlpanel, satz));
                this.gc.setForeground(this.getPlanetenTextColor(this.controlpanel, satz));
                String name = Constants.planetenKuerzel[i];
                offset = this.getPlanetenOffsetText(this.controlpanel, astrodaten.collision(i));
                super.astroScaleTextGrad(longitude, radiusPlanet + offset, 0.0, name);
            } else if (this.controlpanel.getIconTypeId() == 2) {
                this.gc.setFont(this.getPlanetenSymbolFont(this.controlpanel, satz));
                this.gc.setForeground(this.getPlanetenTextColor(this.controlpanel, satz));
                String textSymbol = PlanetInfo.getTextSymbol(i);
                offset = this.getPlanetenOffsetText(this.controlpanel, astrodaten.collision(i));
                super.astroScaleTextGrad(longitude, radiusPlanet + offset, 0.0, textSymbol);
            } else {
                Image iconImage = this.iconFactory.getPlanetImage(this.controlpanel, i, this.getPlanetenIconColor(this.controlpanel, satz));
                int size = iconImage.getImageData().width;
                int offset2 = this.getPlanetenOffsetIcon(size, astrodaten.collision(i));
                super.astroScaleIconGrad(longitude, (double)(radiusPlanet + offset2), 0.0, size, iconImage);
                Disposer.dispose(iconImage);
            }
            this.gc.setFont(this.font8Bold);
            this.gc.setForeground(this.cf.colorBlack);
            super.astroScaleGrad(longitude, radiusPlanet + length / 2, length);
            super.astroScaleGrad(longitude, this.radius4 - length / 2, length);
        }
    }

    private void Tierkreiszeichen(Astrodaten astrodaten) {
        int i;
        this.gc.setForeground(this.cf.colorBlack);
        this.gc.setFont(this.font8);
        double ac = astrodaten.housesInfo.getAc();
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        this.setAlphaOffset(astrodaten, 180.0 + ac);
        this.astroCircle(this.round(this.radius4));
        this.astroCircle(this.round(this.radius5));
        for (i = 0; i < 12; ++i) {
            int j;
            Font f;
            this.gc.setForeground(this.cf.colorBlack);
            String kuerzel = Tkz.name[i];
            int grad = Tkz.getGrad(kuerzel);
            int gradNext = Tkz.getGradNext(kuerzel);
            super.astroLineGrad(grad, this.radius4, this.radius5);
            super.astroLineGrad(grad, this.radius4, this.radius5);
            if (this.controlpanel.getIconTypeId() == 1) {
                f = this.getTkzTextFont(this.controlpanel);
                this.gc.setFont(f);
                super.astroCenterTextGrad(grad, gradNext, this.radius4, this.radius5, Tkz.name[i]);
            } else if (this.controlpanel.getIconTypeId() == 2) {
                f = this.getTkzSymbolFont(this.controlpanel);
                this.gc.setFont(f);
                this.gc.setForeground(this.cf.getTkzColor(i));
                super.astroCenterTextGrad(grad, gradNext, this.radius4, this.radius5, Tkz.nameSymbol[i]);
            } else {
                Image iconImage = this.iconFactory.getTkzImage(this.controlpanel, i);
                super.astroCenterIconGrad(grad, gradNext, this.radius4, this.radius5, iconImage.getImageData().width, iconImage);
                Disposer.dispose(iconImage);
            }
            if (!this.controlpanel.isGradzahlen() && !this.controlpanel.isGradzahlenMitZahl()) continue;
            for (j = grad; j < gradNext; j += 5) {
                super.astroScaleGrad(j, this.round((double)this.radius4 + 2.5), 5.0);
            }
            for (j = grad; j < gradNext; j += 10) {
                super.astroScaleGrad(j, this.round(this.radius4 + 5), 10.0);
            }
        }
        if (GlobalData.getInstance().isBrandOpen()) {
            this.gc.setForeground(this.cf.colorBlack);
            this.gc.setFont(this.font8);
            if (this.controlpanel.isGradzahlenMitZahl()) {
                for (i = 0; i < 360; i += 10) {
                    super.astroScaleTextGrad(i, this.radius4, 10.0, Converter.intToString(i));
                }
            }
        }
    }

    private void haeuser(Astrodaten astrodaten) {
        this.alphaOffset = 0.0;
        this.setAlphaOffset(astrodaten, 0.0);
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        this.gc.setForeground(this.cf.colorBlack);
        this.gc.setFont(this.font9Bold);
        super.astroCircle(this.radius2);
        super.astroCircle(this.radius3);
        for (int i = 1; i <= 12; ++i) {
            double bis;
            double von;
            super.astroLineGrad(astrodaten.getHausBisGrad(i), this.radius2, this.radius3);
            super.astroLineGrad(astrodaten.getHausBisGrad(i), this.radius4 - 40, this.radius4);
            if (this.controlpanel.isHauslinien()) {
                super.astroLineGrad(astrodaten.getHausBisGrad(i), this.radius2, this.radius4);
            }
            if ((von = astrodaten.getHausVonGrad(i)) > (bis = astrodaten.getHausBisGrad(i))) {
                bis += 360.0;
            }
            super.astroCenterTextGrad(von, bis, this.radius2, this.radius3, Converter.intToString(i));
        }
    }

    private void jahresringe(Date geburtsdatum, Astrodaten astrodaten) {
        if (!this.controlpanel.isJahresring() && !this.controlpanel.isZeiger()) {
            return;
        }
        if (this.horoskopCalculator.getHoroskop() != Horoskop.Radix) {
            return;
        }
        int personAlter = Util.getDiffInYears(geburtsdatum);
        this.setAlphaOffset(astrodaten, 180.0);
        this.orientation = Leinwand.Orientation.Uhrzeiger;
        this.gc.setFont(this.font9);
        if (this.isMedium() && GlobalData.getInstance().isWindows()) {
            this.gc.setFont(this.font7);
        }
        if (this.controlpanel.isJahresring()) {
            this.astroCircle(this.round(this.radius7));
        }
        int alter = 0;
        double grad = 0.0;
        int textScaleOffset = 10;
        for (int house = 12; house > 0; --house) {
            double bis;
            double von = astrodaten.getHausVonGrad(house);
            if (von > (bis = astrodaten.getHausBisGrad(house))) {
                bis += 360.0;
            }
            double winkelbereichHaus = Math.abs(bis - von);
            double winkelSchritte = winkelbereichHaus / 7.0;
            for (int i = 1; i <= 7; ++i) {
                if (GlobalData.getInstance().isMacos()) {
                    this.gc.setForeground(this.cf.colorBlack);
                } else {
                    this.gc.setForeground(this.cf.colorBlue);
                }
                ++alter;
                double winkel = this.round(grad + (double)i * winkelSchritte);
                if (this.controlpanel.isJahresring()) {
                    if (alter % 7 == 0) {
                        super.astroLineGrad(winkel, this.radius7, this.radius7 + 12);
                    } else {
                        super.astroLineGrad(winkel, this.radius7, this.radius7 + 5);
                    }
                    if (!this.isSmall() || alter % 7 == 0) {
                        if (alter % 7 == 0) {
                            if (GlobalData.getInstance().isMacos()) {
                                this.gc.setForeground(this.cf.colorRed);
                                super.astroScaleTextGrad(winkel, (double)this.radius7 * 1.02, textScaleOffset, " " + Converter.intToString(alter) + " ");
                            } else {
                                this.gc.setForeground(this.cf.colorRed);
                                super.astroScaleTextGrad(winkel, (double)this.radius7 * 1.005, textScaleOffset, Converter.intToString(alter));
                            }
                        } else if (GlobalData.getInstance().isMacos()) {
                            this.gc.setForeground(this.cf.colorBlack);
                            super.astroScaleTextGrad(winkel, (double)this.radius7 * 1.02, textScaleOffset, " " + Converter.intToString(alter) + " ");
                        } else {
                            this.gc.setForeground(this.cf.colorBlack);
                            super.astroScaleTextGrad(winkel, (double)this.radius7 * 1.005, textScaleOffset, Converter.intToString(alter));
                        }
                    }
                }
                if (GlobalData.getInstance().isMacos()) {
                    this.gc.setForeground(this.cf.colorBlack);
                } else {
                    this.gc.setForeground(this.cf.colorBlue);
                }
                if (!this.controlpanel.isZeiger() || alter != personAlter) continue;
                int width = this.gc.getLineWidth();
                int style = this.gc.getLineStyle();
                this.gc.setLineWidth(2);
                this.gc.setLineStyle(3);
                super.astroLineGrad(winkel, this.maxRadius);
                this.gc.setLineWidth(width);
                this.gc.setLineStyle(style);
            }
            grad += winkelbereichHaus;
        }
    }

    private void septarringe(Date geburtsdatum, Date currentDate, Astrodaten astrodaten) {
        if (!this.controlpanel.isJahresring() && !this.controlpanel.isZeiger()) {
            return;
        }
        if (this.horoskopCalculator.getHoroskop() != Horoskop.Septar) {
            return;
        }
        this.setAlphaOffset(astrodaten, 180.0);
        this.orientation = Leinwand.Orientation.Uhrzeiger;
        if (GlobalData.getInstance().isMacos()) {
            this.gc.setForeground(this.cf.colorBlack);
        } else {
            this.gc.setForeground(this.cf.colorBlue);
        }
        this.gc.setFont(this.font7);
        int geburtsmonat = DateUtil.getMonth(geburtsdatum);
        int septarNr = Jahresring.getSeptarNr(geburtsdatum, currentDate);
        if (this.controlpanel.isJahresring()) {
            this.astroCircle(this.round(this.radius7));
            for (int monat = 0; monat < 84; ++monat) {
                double winkel = Jahresring.getSeptarwinkel(geburtsdatum, septarNr, monat);
                int jahre = (septarNr - 1) * 7;
                Date d = DateUtil.dateAddMonths(geburtsdatum, 12 * jahre + monat);
                int day = DateUtil.getDay(d);
                int month = DateUtil.getMonth(d);
                int year = DateUtil.getYear(d);
                int printmonat = (geburtsmonat + monat - 1) % 12 + 1;
                int textScaleOffset = 7;
                super.astroLineGrad(this.round(winkel), this.radius7, this.radius7 + 7);
                if (printmonat != geburtsmonat) {
                    this.gc.setBackground(this.cf.colorRed);
                    super.astroScaleTextGrad(this.round(winkel), this.radius7, textScaleOffset, day + "." + month);
                    continue;
                }
                this.gc.setForeground(this.cf.colorRed);
                super.astroScaleTextGrad(this.round(winkel), this.radius7, textScaleOffset, Converter.intToLeading0String(year, 4));
                this.gc.setForeground(this.cf.colorBlue);
            }
        }
        if (this.controlpanel.isZeiger()) {
            double todayWinkel = Jahresring.getSeptarwinkel(geburtsdatum, septarNr);
            if (todayWinkel < 0.0) {
                return;
            }
            int width = this.gc.getLineWidth();
            int style = this.gc.getLineStyle();
            this.gc.setLineWidth(2);
            this.gc.setLineStyle(3);
            super.astroLineGrad(Trigo.grad(todayWinkel), this.maxRadius);
            this.gc.setLineWidth(width);
            this.gc.setLineStyle(style);
        }
    }

    private void monatsringe(Date geburtsdatum, Date currentDate, Astrodaten astrodaten) {
        if (!this.controlpanel.isJahresring() && !this.controlpanel.isZeiger()) {
            return;
        }
        if (this.horoskopCalculator.getHoroskop() != Horoskop.Solar && this.horoskopCalculator.getHoroskop() != Horoskop.Transit) {
            return;
        }
        if (this.horoskopCalculator.getHoroskop() != Horoskop.Solar) {
            return;
        }
        this.setAlphaOffset(astrodaten, 0.0);
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        if (GlobalData.getInstance().isMacos()) {
            this.gc.setForeground(this.cf.colorBlack);
        } else {
            this.gc.setForeground(this.cf.colorBlue);
        }
        this.gc.setFont(this.font7);
        Jahresring jahresring = new Jahresring();
        if (this.controlpanel.isJahresring()) {
            this.astroCircle(this.round(this.radius7));
            int textScaleOffset = 5;
            for (int house = 1; house <= 12; ++house) {
                Date d = jahresring.getBeginnDateByHouse(geburtsdatum, currentDate, house);
                double winkel = jahresring.getWinkel(geburtsdatum, d, astrodaten);
                int day = DateUtil.getDay(d);
                int month = DateUtil.getMonth(d);
                super.astroLineGrad(this.round(winkel), this.radius7, this.radius7 + 7);
                if (house == 12) {
                    // empty if block
                }
                super.astroScaleTextGrad(this.round(winkel), this.radius7, textScaleOffset, day + ". " + Constants.monateKurz[month - 1]);
            }
        }
        if (this.controlpanel.isZeiger()) {
            double todayWinkel = jahresring.getWinkel(geburtsdatum, currentDate, astrodaten);
            int width = this.gc.getLineWidth();
            int style = this.gc.getLineStyle();
            this.gc.setLineWidth(2);
            this.gc.setLineStyle(3);
            super.astroLineGrad(todayWinkel, this.maxRadius);
            this.gc.setLineWidth(width);
            this.gc.setLineStyle(style);
        }
    }

    private int getPlanetIconDiagonale(int size) {
        return Trigo.getDiagonale(size);
    }

    private int getPlanetIconDiagonaleOffset(int size) {
        return this.getPlanetIconDiagonale(size) / 2 + 5;
    }

    private Aspektarium aspekte(Astrodaten astrodaten, Satz satz) {
        this.setAlphaOffset(astrodaten, 0.0);
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        AspektariumCalculator aspektariumCalculator = new AspektariumCalculator(this.horoskopCalculator.getHoroskop(), this.controlpanel);
        Aspektarium aspektarium = aspektariumCalculator.berechneAspekte(astrodaten);
        this.drawAspekte(aspektarium, this.radiusPlaneten1, this.radiusPlaneten1, satz, false);
        return aspektarium;
    }

    private Aspektarium interAspekte(Astrodaten astrodaten1, Astrodaten astrodaten2) {
        this.setAlphaOffset(astrodaten1, 0.0);
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        AspektariumCalculator aspektariumCalculator = new AspektariumCalculator(this.horoskopCalculator.getHoroskop(), this.controlpanel);
        Aspektarium interAspektarium = aspektariumCalculator.berechneInterAspekte(astrodaten1, astrodaten2, astrodaten2.offset);
        this.drawAspekte(interAspektarium, this.radiusPlaneten1, this.radiusPlaneten2, Satz.Interaspekt, true);
        return interAspektarium;
    }

    private void drawAspekte(Aspektarium aspektarium, int radius1, int radius2, Satz satz, boolean bidirectional) {
        int linestype = this.gc.getLineStyle();
        if (bidirectional) {
            this.gc.setLineStyle(2);
        }
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < (bidirectional ? 14 : i); ++j) {
                if (aspektarium.getAspekt(i, j) == null || !bidirectional && satz == Satz.Person1 && (!this.controlpanel.getPlaneten1()[i] || !this.controlpanel.getPlaneten1()[j]) || !bidirectional && satz == Satz.Person2 && (!this.controlpanel.getPlaneten2()[i] || !this.controlpanel.getPlaneten2()[j]) || bidirectional && (!this.controlpanel.getPlaneten1()[i] || !this.controlpanel.getPlaneten2()[j]) || i == AspektariumCalculator.ID_DC || i == AspektariumCalculator.ID_IC || j == AspektariumCalculator.ID_DC || j == AspektariumCalculator.ID_IC || aspektarium.getAspekt(i, j) == AspektTyp.empty) continue;
                Color color = this.getAspektColor(aspektarium.getAspekt(i, j), satz);
                this.drawAspektLinieGrad(aspektarium.getPlanet(i).getWinkelAbs(), aspektarium.getInterPlanet(j).getWinkelAbs(), radius1, radius2, color);
            }
        }
        this.gc.setLineStyle(linestype);
    }

    Color getAspektColor(AspektTyp aspektTyp, Satz satz) {
        Horoskop horoskop = this.horoskopCalculator.getHoroskop();
        if (horoskop == Horoskop.Radix || horoskop == Horoskop.Aktualitaet || horoskop == Horoskop.Solar || horoskop == Horoskop.Septar || horoskop == Horoskop.Septosit || horoskop == Horoskop.Temposit || horoskop == Horoskop.Komposit || horoskop == Horoskop.MultiKomposit || horoskop == Horoskop.KompositSeptar) {
            return this.getAspektColorBunt(aspektTyp);
        }
        if (horoskop == Horoskop.Transit || horoskop == Horoskop.KompositTransit || horoskop == Horoskop.Synastrie) {
            if (satz == Satz.Person1) {
                return this.cf.colorBlack;
            }
            if (satz == Satz.Person2) {
                return this.cf.colorRed;
            }
            if (satz == Satz.Interaspekt) {
                return this.getAspektColorBunt(aspektTyp);
            }
        }
        return this.cf.colorGreen;
    }

    private Color getAspektColorBunt(AspektTyp aspektTyp) {
        switch (aspektTyp) {
            case konjunktion: {
                return this.cf.colorRed;
            }
            case opposition: {
                return this.cf.colorRed;
            }
            case quadrat: {
                return this.cf.colorRed;
            }
            case trigon: {
                return this.cf.colorBlue;
            }
            case sextil: {
                return this.cf.colorGreen;
            }
        }
        return this.cf.colorBlack;
    }

    private void setAlphaOffset(Astrodaten astrodaten, double winkel) {
        this.alphaOffset = astrodaten == null ? winkel / 360.0 * 2.0 * Math.PI : (winkel - astrodaten.getOffset()) / 360.0 * 2.0 * Math.PI;
    }

    private Color getPlanetenTextColor(Controlpanel controlpanel, Satz satz) {
        Color color = this.cf.colorBlack;
        if (satz == Satz.Person2) {
            color = this.cf.colorRed;
        }
        return color;
    }

    private Resources.ICON_COLOR getPlanetenIconColor(Controlpanel controlpanel, Satz satz) {
        Resources.ICON_COLOR color = Resources.ICON_COLOR.black;
        if (satz == Satz.Person2) {
            color = Resources.ICON_COLOR.red;
        }
        return color;
    }

    private Font getPlanetenTextFont(Controlpanel controlpanel, Satz satz) {
        Font font = null;
        font = controlpanel.getIconSizeId() == 1 ? this.font8 : (controlpanel.getIconSizeId() == 2 ? this.font10 : (controlpanel.getIconSizeId() == 3 ? this.font12 : this.font10));
        return font;
    }

    private Font getPlanetenSymbolFont(Controlpanel controlpanel, Satz satz) {
        Font font = null;
        font = controlpanel.getIconSizeId() == 1 ? this.font12 : (controlpanel.getIconSizeId() == 2 ? this.font18 : (controlpanel.getIconSizeId() == 3 ? this.font24 : this.font18));
        return font;
    }

    private Font getTkzTextFont(Controlpanel controlpanel) {
        Font font = null;
        font = controlpanel.getIconSizeId() == 1 ? this.font6 : (controlpanel.getIconSizeId() == 2 ? this.font8 : (controlpanel.getIconSizeId() == 3 ? this.font10 : this.font8));
        return font;
    }

    private Font getTkzSymbolFont(Controlpanel controlpanel) {
        Font font = null;
        font = controlpanel.getIconSizeId() == 1 ? this.font12 : (controlpanel.getIconSizeId() == 2 ? this.font18 : (controlpanel.getIconSizeId() == 3 ? this.font24 : this.font18));
        return font;
    }

    private int getPlanetenOffsetText(Controlpanel controlpanel, int cntCollisionen) {
        int offset = 0;
        if (controlpanel.getIconTypeId() == 1) {
            offset = controlpanel.getIconSizeId() == 1 ? 15 + 16 * cntCollisionen : (controlpanel.getIconSizeId() == 2 ? 15 + 18 * cntCollisionen : (controlpanel.getIconSizeId() == 3 ? 24 + 20 * cntCollisionen : 15 + 28 * cntCollisionen));
        } else if (controlpanel.getIconTypeId() == 2) {
            offset = controlpanel.getIconSizeId() == 1 ? 20 + 14 * cntCollisionen : (controlpanel.getIconSizeId() == 2 ? 25 + 16 * cntCollisionen : (controlpanel.getIconSizeId() == 3 ? 30 + 20 * cntCollisionen : 20 + 16 * cntCollisionen));
        }
        return offset;
    }

    private int getPlanetenOffsetIcon(int iconSize, int cntCollisionen) {
        int offset = 2 + this.getPlanetIconDiagonaleOffset(iconSize) + (int)Math.round(0.5 * (double)this.getPlanetIconDiagonale(iconSize) * (double)cntCollisionen);
        return offset;
    }

    public boolean isPaperVersion() {
        return this.paperVersion;
    }

    public void setPaperVersion(boolean paperVersion) {
        this.paperVersion = paperVersion;
        this.iconFactory.setPaperVersion(paperVersion);
    }

    public void drawSchablone(double alpha) {
        this.orientation = Leinwand.Orientation.Gegenuhrzeiger;
        this.gc.setForeground(this.cf.colorBlack);
        this.gc.setBackground(this.cf.colorBlack);
        this.astroCircle(this.radiusSchablone);
        this.drawSchabloneLine(alpha, AspektTyp.konjunktion);
        this.drawSchabloneLine(alpha, AspektTyp.opposition);
        this.drawSchabloneLine(alpha, AspektTyp.quadrat);
        this.drawSchabloneLine(alpha, AspektTyp.sextil);
        this.drawSchabloneLine(alpha, AspektTyp.trigon);
    }

    public void drawSchabloneLine(double alpha, AspektTyp aspektTyp) {
        Color color = this.getAspektColorBunt(aspektTyp);
        this.gc.setForeground(color);
        this.gc.setBackground(color);
        double offset = aspektTyp.winkelbeziehung;
        if (aspektTyp == AspektTyp.konjunktion) {
            this.astrodrawArrow(alpha, 0.0, this.radiusSchablone);
        } else {
            this.astroLineGrad(Trigo.grad(alpha + offset), this.radiusSchablone);
            this.astroLineGrad(Trigo.grad(alpha - offset), this.radiusSchablone);
        }
        Image iconImage = this.iconFactory.getAspektImage(aspektTyp);
        this.astroScaleIconGrad(Trigo.grad(alpha + offset), (double)(this.radius3 + 20), 0.0, 16, iconImage);
        this.astroScaleIconGrad(Trigo.grad(alpha - offset), (double)(this.radius3 + 20), 0.0, 16, iconImage);
        Disposer.dispose(iconImage);
    }

    private boolean isSmall() {
        return this.paintRawData.getSizeY() <= 600;
    }

    private boolean isMedium() {
        return this.paintRawData.getSizeY() <= 768;
    }

    private static enum Satz {
        Person1,
        Person2,
        Interaspekt;

    }
}

