/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.paint;

import de.cni.client.paint.Controlpanel;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.astrologie.AspektariumPlanet;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.AnalyseAspektElement;
import de.cni.common.calculation.AnalyseElementList;
import de.cni.common.calculation.AnalyseFilter;
import de.cni.common.calculation.AnalyseResult;
import de.cni.common.calculation.Aspektarium;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.TextanalyseCalculator;
import de.cni.common.calculation.TransitCalculator;
import de.cni.common.calculation.TransitRange;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ClickKoordinaten {
    int delta = 5;
    boolean transiteInitialized = false;
    public double xcenter;
    public double ycenter;
    double radiusHausInnen;
    double radiusHausAussen;
    double radiusPlaneten1;
    double radiusPlaneten2;
    double radiusTkzInnen;
    double radiusTkzAussen;
    HoroskopCalculator horoskopCalculator;
    Controlpanel controlpanel;
    private Aspektarium aspektarium1;
    private Aspektarium aspektarium2;
    private Aspektarium interaspektarium;

    public ClickKoordinaten(HoroskopCalculator horoskopCalculator) {
        this.horoskopCalculator = horoskopCalculator;
    }

    public void initializeGuiInfo(Controlpanel controlpanel, double xcenter, double ycenter, double radiusHausInnen, double radiusHausAussen, double radiusPlaneten1, double radiusPlaneten2, double radiusTkzInnen, double radiusTkzAussen) {
        this.controlpanel = controlpanel;
        this.xcenter = xcenter;
        this.ycenter = ycenter;
        this.radiusHausInnen = radiusHausInnen;
        this.radiusHausAussen = radiusHausAussen;
        this.radiusPlaneten1 = radiusPlaneten1;
        this.radiusPlaneten2 = radiusPlaneten2;
        this.radiusTkzInnen = radiusTkzInnen;
        this.radiusTkzAussen = radiusTkzAussen;
    }

    public void initializeAspektarium(Aspektarium aspektarium1, Aspektarium aspektarium2, Aspektarium interaspektarium) {
        this.aspektarium1 = aspektarium1;
        this.aspektarium2 = aspektarium2;
        this.interaspektarium = interaspektarium;
        this.transiteInitialized = false;
    }

    private void initializeTransite(Aspektarium aspektarium, int satz, boolean inter) {
        TransitCalculator transitCalculator = new TransitCalculator(this.horoskopCalculator, this.controlpanel, aspektarium.getInterPlanetListe(), aspektarium.getAspektArray());
        List<TransitRange> transitRangeList = transitCalculator.calculate(satz, inter);
        transitCalculator.copyToAspektArray(transitRangeList, aspektarium.getTransitVonArray(), aspektarium.getTransitBisArray());
        this.transiteInitialized = true;
    }

    public AnalyseResult getAllMatches(double winkel, double radius) {
        AnalyseResult result = new AnalyseResult();
        result.setClickKoordinaten(this);
        result.setHoroskopCalculator(this.horoskopCalculator);
        if (this.radiusHausInnen < radius && radius < this.radiusHausAussen) {
            String haus = this.getHouse(this.horoskopCalculator.getAstrodaten1(), winkel);
            AnalyseElementList analyseElementList = this.getAnalysetextHaus(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), haus);
            String ueberschrift = "Haus: " + haus;
            result.setHausFlag(true);
            result.setHaus(haus);
            result.setUeberschrift(ueberschrift);
            result.setAnalyseElementList(analyseElementList);
            return result;
        }
        if (this.radiusTkzInnen < radius && radius < this.radiusTkzAussen) {
            int tkzId = this.getTkzId(this.horoskopCalculator.getAstrodaten1(), winkel);
            String tkzKuerzel = Tkz.kuerzel[tkzId];
            String tkzName = Tkz.name[tkzId];
            AnalyseElementList analyseElementList = this.getAnalysetextTkz(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), tkzName);
            String ueberschrift = "Tierkreiszeichen: " + tkzName;
            result.setTkzFlag(true);
            result.setTkz(tkzName);
            result.setUeberschrift(ueberschrift);
            result.setAnalyseElementList(analyseElementList);
            return result;
        }
        if (this.radiusHausAussen < radius && radius < this.radiusTkzInnen) {
            GuiPlanet guiPlanet = this.getPlanet(winkel);
            String planetName = guiPlanet.name;
            String ueberschrift = "Planet: " + planetName + this.transitSign(guiPlanet);
            List<AnalyseAspektElement> analyseAspektElementList = null;
            analyseAspektElementList = this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1 ? this.getInteraspektList(guiPlanet, this.horoskopCalculator.getHoroskop() != Horoskop.Transit) : this.getAspektList(guiPlanet);
            AnalyseElementList analyseElementList = null;
            this.controlpanel.setHoroskopCalculator(this.horoskopCalculator);
            analyseElementList = this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1 ? (guiPlanet.satz == 1 ? this.getAnalysetextPlanet(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), this.horoskopCalculator.getAstrodaten2(), planetName, null) : this.getAnalysetextPlanet(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), this.horoskopCalculator.getAstrodaten2(), null, planetName)) : this.getAnalysetextPlanet(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), null, planetName, planetName);
            result.setPlanetFlag(true);
            result.setPlanet(guiPlanet.name);
            result.setAnalyseAspektElementList(analyseAspektElementList);
            result.setUeberschrift(ueberschrift);
            result.setAnalyseElementList(analyseElementList);
            return result;
        }
        return result;
    }

    public String transitSign(GuiPlanet guiPlanet) {
        if (guiPlanet.satz != 2) {
            return "";
        }
        return this.horoskopCalculator.getHoroskop().getTransitSign();
    }

    public AnalyseResult getAllMatches(AnalyseResult analyseResult) {
        AnalyseResult result = new AnalyseResult();
        result.setClickKoordinaten(this);
        result.setHoroskopCalculator(this.horoskopCalculator);
        if (analyseResult.isHausFlag()) {
            String haus = analyseResult.getHaus();
            AnalyseElementList analyseElementList = this.getAnalysetextHaus(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), haus);
            String ueberschrift = "Haus: " + haus;
            result.setHausFlag(true);
            result.setHaus(haus);
            result.setUeberschrift(ueberschrift);
            result.setAnalyseElementList(analyseElementList);
            return result;
        }
        if (analyseResult.isTkzFlag()) {
            AnalyseElementList analyseElementList = this.getAnalysetextTkz(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), analyseResult.getTkz());
            String ueberschrift = "Tierkreiszeichen: " + analyseResult.getTkz();
            result.setTkzFlag(true);
            result.setTkz(analyseResult.getTkz());
            result.setUeberschrift(ueberschrift);
            result.setAnalyseElementList(analyseElementList);
            return result;
        }
        if (analyseResult.isPlanetFlag()) {
            GuiPlanet guiPlanet = new GuiPlanet();
            guiPlanet.name = analyseResult.getPlanet();
            guiPlanet.satz = 1;
            guiPlanet.planet = guiPlanet.name2planet(guiPlanet.name);
            String planetName = guiPlanet.name;
            String ueberschrift = "Planet: " + planetName + this.transitSign(guiPlanet);
            List<AnalyseAspektElement> analyseAspektElementList = null;
            analyseAspektElementList = this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1 ? this.getInteraspektList(guiPlanet, this.horoskopCalculator.getHoroskop() != Horoskop.Transit) : this.getAspektList(guiPlanet);
            AnalyseElementList analyseElementList = null;
            analyseElementList = this.horoskopCalculator.getHoroskop().getPlanetenSaetze() > 1 ? (guiPlanet.satz == 1 ? this.getAnalysetextPlanet(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), this.horoskopCalculator.getAstrodaten2(), planetName, null) : this.getAnalysetextPlanet(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), this.horoskopCalculator.getAstrodaten2(), null, planetName)) : this.getAnalysetextPlanet(this.controlpanel, this.horoskopCalculator.getAstrodaten1(), null, planetName, planetName);
            result.setPlanetFlag(true);
            result.setPlanet(guiPlanet.name);
            result.setAnalyseAspektElementList(analyseAspektElementList);
            result.setUeberschrift(ueberschrift);
            result.setAnalyseElementList(analyseElementList);
            return result;
        }
        return result;
    }

    private GuiPlanet getPlanet(double winkel) {
        double diff;
        double wp;
        int i;
        double icAbs;
        double dcAbs;
        double mcAbs;
        double acAbs;
        GuiPlanet gp = new GuiPlanet();
        gp.satz = -1;
        gp.planet = -1;
        double diffMin = 360.0;
        Astrodaten ad = this.horoskopCalculator.getAstrodaten1();
        if (ad == null || this.controlpanel.isHoroskop1()) {
            acAbs = ad.housesInfo.getAcAbs();
            mcAbs = ad.housesInfo.getMcAbs();
            dcAbs = Trigo.grad(acAbs + 180.0);
            icAbs = Trigo.grad(mcAbs + 180.0);
            for (i = 0; i < PlanetInfo.PLANET_MAX; ++i) {
                if (!this.controlpanel.getPlaneten1()[i]) continue;
                wp = ad.getPlanetAbs(i);
                if (i == 10) {
                    wp = acAbs;
                } else if (i == 12) {
                    wp = mcAbs;
                } else if (i == 11) {
                    wp = dcAbs;
                } else if (i == 13) {
                    wp = icAbs;
                }
                diff = Trigo.alphaDiff(winkel, wp);
                if (!(diff < diffMin)) continue;
                diffMin = diff;
                gp.satz = 1;
                gp.planet = i;
                gp.name = Constants.planeten[i];
            }
        }
        if ((ad = this.horoskopCalculator.getAstrodaten2()) != null && this.controlpanel.isHoroskop2()) {
            acAbs = ad.housesInfo.getAcAbs();
            mcAbs = ad.housesInfo.getMcAbs();
            dcAbs = Trigo.grad(acAbs + 180.0);
            icAbs = Trigo.grad(mcAbs + 180.0);
            for (i = 0; i < PlanetInfo.PLANET_MAX - 4; ++i) {
                if (!this.controlpanel.getPlaneten2()[i]) continue;
                wp = ad.getPlanetAbs(i);
                wp = Trigo.grad(wp + ad.getOffset());
                if (i == 10) {
                    wp = acAbs;
                } else if (i == 12) {
                    wp = mcAbs;
                } else if (i == 11) {
                    wp = dcAbs;
                } else if (i == 13) {
                    wp = icAbs;
                }
                diff = Trigo.alphaDiff(winkel, wp);
                if (!(diff < diffMin)) continue;
                diffMin = diff;
                gp.satz = 2;
                gp.planet = i;
                gp.name = Constants.planeten[i];
            }
        }
        return gp;
    }

    private String getHouse(Astrodaten ad, double winkel) {
        for (int i = 1; i < 13; ++i) {
            double bis;
            double von = ad.housesInfo.getHouseVonAbs(i);
            if (!Trigo.isBetween(winkel, von, bis = ad.housesInfo.getHouseBisAbs(i))) continue;
            return Converter.intToString(i);
        }
        return "";
    }

    private int getTkzId(Astrodaten ad, double winkel) {
        for (int i = 0; i < 12; ++i) {
            double bis;
            String kuerzel = Tkz.name[i];
            double von = ad.getTkzVonAbs(kuerzel);
            if (!Trigo.isBetween(winkel, von, bis = ad.getTkzBisAbs(kuerzel))) continue;
            return i;
        }
        return -1;
    }

    private String getTkzKuerzel(Astrodaten ad, double winkel) {
        for (int i = 0; i < 12; ++i) {
            double bis;
            String kuerzel = Tkz.name[i];
            double von = ad.getTkzVonAbs(kuerzel);
            if (!Trigo.isBetween(winkel, von, bis = ad.getTkzBisAbs(kuerzel))) continue;
            return kuerzel;
        }
        return "";
    }

    private String getTkzName(Astrodaten ad, double winkel) {
        int tkz = this.getTkzId(ad, winkel);
        String name = Tkz.name[tkz];
        return name;
    }

    private List<AnalyseAspektElement> getAspektList(GuiPlanet gp) {
        Aspektarium aspektarium;
        ArrayList<AnalyseAspektElement> list = new ArrayList<AnalyseAspektElement>();
        int planet = gp.planet;
        if (planet < 0) {
            return null;
        }
        Aspektarium aspektarium2 = aspektarium = gp.satz == 1 ? this.aspektarium1 : this.aspektarium2;
        if (aspektarium == null) {
            return null;
        }
        for (int j = 0; j < aspektarium.getSize(); ++j) {
            AspektTyp at;
            int p1 = planet;
            int p2 = j;
            AspektariumPlanet planet2 = aspektarium.getPlanet(j);
            if (p2 == 11 || p2 == 13 || gp.planet == planet2.nr || (at = aspektarium.getAspekt(planet, j)) == AspektTyp.empty) continue;
            String transitText = "";
            if (TransitCalculator.isCalculationAllowed(this.horoskopCalculator.getHoroskop())) {
                if (!this.transiteInitialized) {
                    this.initializeTransite(aspektarium, gp.satz, false);
                }
                int pb = Math.min(planet, j);
                int pa = Math.max(planet, j);
                Date von = aspektarium.getTransitVonArray()[pa][pb];
                Date bis = aspektarium.getTransitBisArray()[pa][pb];
                transitText = " von " + Converter.timeToString(von) + " bis " + Converter.timeToString(bis);
            }
            AnalyseAspektElement analyseAspektElement = new AnalyseAspektElement(this.horoskopCalculator.getHoroskop().getName(), p1, p2, at, transitText);
            list.add(analyseAspektElement);
        }
        return list;
    }

    private List<AnalyseAspektElement> getInteraspektList(GuiPlanet gp, boolean bidirection) {
        ArrayList<AnalyseAspektElement> list = new ArrayList<AnalyseAspektElement>();
        int planet = gp.planet;
        if (planet < 0) {
            return null;
        }
        Aspektarium aspektarium = this.interaspektarium;
        for (int j = 0; j < aspektarium.getSize(); ++j) {
            AspektTyp at;
            int p1 = planet;
            int p2 = j;
            if (gp.satz == 2) {
                p1 = j;
                p2 = planet;
            }
            if (p1 == AspektariumCalculator.ID_DC || p1 == AspektariumCalculator.ID_IC || p1 == AspektariumCalculator.ID_DC || p1 == AspektariumCalculator.ID_IC || p2 == AspektariumCalculator.ID_DC || p2 == AspektariumCalculator.ID_IC || p2 == AspektariumCalculator.ID_DC || p2 == AspektariumCalculator.ID_IC || (at = aspektarium.getAspekt(p1, p2)) == AspektTyp.empty) continue;
            String transitText = "";
            if (TransitCalculator.isCalculationAllowed(this.horoskopCalculator.getHoroskop())) {
                if (!this.transiteInitialized) {
                    this.initializeTransite(aspektarium, 1, true);
                }
                Date von = aspektarium.getTransitVonArray()[p1][p2];
                Date bis = aspektarium.getTransitBisArray()[p1][p2];
                transitText = " von " + Converter.timeToString(von) + " bis " + Converter.timeToString(bis);
            }
            AnalyseAspektElement analyseAspektElement = new AnalyseAspektElement(this.horoskopCalculator.getHoroskop().getName(), p1, p2, at, transitText);
            list.add(analyseAspektElement);
        }
        return list;
    }

    public AnalyseElementList getAnalysetextPlanet(Controlpanel controlpanel, Astrodaten ad1, Astrodaten ad2, String planet1, String planet2) {
        AnalyseFilter filter = new AnalyseFilter();
        filter.setHoroskop(this.horoskopCalculator.getHoroskop().getName());
        filter.setStufe(controlpanel.getStufe1());
        filter.setPlanet1(planet1);
        filter.setPlanet2(planet2);
        TextanalyseCalculator ac = ad2 != null ? new TextanalyseCalculator(controlpanel, ad1, ad2, null) : new TextanalyseCalculator(controlpanel, ad1);
        ac.setFilter(filter);
        return ac.calculateKonstellation(0);
    }

    public AnalyseElementList getAnalysetextHaus(Controlpanel controlpanel, Astrodaten ad, String haus) {
        AnalyseFilter filter = new AnalyseFilter();
        filter.setHoroskop(this.horoskopCalculator.getHoroskop().getName());
        filter.setStufe(controlpanel.getStufe1());
        filter.setHaus(haus);
        TextanalyseCalculator ac = new TextanalyseCalculator(controlpanel, ad);
        ac.setFilter(filter);
        return ac.calculateKonstellation(0);
    }

    public AnalyseElementList getAnalysetextTkz(Controlpanel controlpanel, Astrodaten ad, String tkzName) {
        AnalyseFilter filter = new AnalyseFilter();
        filter.setHoroskop(this.horoskopCalculator.getHoroskop().getName());
        filter.setStufe(controlpanel.getStufe1());
        filter.setTkz(tkzName);
        TextanalyseCalculator ac = new TextanalyseCalculator(controlpanel, ad);
        ac.setFilter(filter);
        return ac.calculateKonstellation(0);
    }

    private class GuiPlanet {
        int planet;
        String name;
        int satz;

        private GuiPlanet() {
        }

        private int name2planet(String name) {
            for (int i = 0; i < Constants.planeten.length; ++i) {
                if (!Util.equals(Constants.planeten[i], name)) continue;
                return i;
            }
            return -1;
        }
    }
}

