/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.paint;

import de.cni.client.gui.util.Resources;
import de.cni.client.paint.Controlpanel;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.core.Trigo;
import org.eclipse.swt.graphics.Image;

public class IconFactory {
    public static final String sonne = "\u2609";
    public static final String mond = "\u263d";
    public static final String merkur = "\u263f";
    public static final String venus = "\u2640";
    public static final String erde = "\u2641";
    public static final String mars = "\u2642";
    public static final String jupiter = "\u2643";
    public static final String saturn = "\u2644";
    public static final String uranus = "\u26e2";
    public static final String neptun = "\u2646";
    public static final String pluto = "\u2647";
    public static final String widder = "\u2648";
    public static final String stier = "\u2649";
    public static final String zwillinge = "\u264a";
    public static final String krebs = "\u264b";
    public static final String loewe = "\u264c";
    public static final String jungfrau = "\u264d";
    public static final String waage = "\u264e";
    public static final String skorpion = "\u264f";
    public static final String schuetze = "\u2650";
    public static final String steinbock = "\u2651";
    public static final String wassermann = "\u2652";
    public static final String fische = "\u2653";
    public static final String konjunktion = "\u260c";
    public static final String opposition = "\u260d";
    public static final String quadrat = "\u25a1";
    public static final String trigion = "\u25b3";
    public static final String sextil = "\u26b9";
    int inconSizeId;
    private int iconSizeId;
    private int aspektIconSize;
    private int tkzIconSize;
    private int planetIconSize;
    private int planetIconDiagonale;
    private int planetIconDiagonaleOffset;
    private boolean paperVersion;
    private Resources r;

    public IconFactory() {
        this.planetIconDiagonale = (int)Math.round(Math.sqrt(this.planetIconSize * this.planetIconSize + this.planetIconSize * this.planetIconSize));
        this.planetIconDiagonaleOffset = this.planetIconDiagonale / 2 + 1;
        this.r = Resources.getInstance();
    }

    private void setIconSize() {
        this.planetIconDiagonale = Trigo.getDiagonale(this.planetIconSize);
        this.planetIconDiagonaleOffset = this.planetIconDiagonale / 2 + 1;
    }

    private Resources.ICON_SIZE getIconSize(Controlpanel panel) {
        if (this.paperVersion) {
            return Resources.ICON_SIZE.large;
        }
        switch (panel.getIconSizeId()) {
            case 1: {
                return Resources.ICON_SIZE.small;
            }
            case 2: {
                return Resources.ICON_SIZE.medium;
            }
            case 3: {
                return Resources.ICON_SIZE.large;
            }
        }
        return Resources.ICON_SIZE.standard;
    }

    public Image getPlanetImage(Controlpanel panel, int id, Resources.ICON_COLOR color) {
        switch (id) {
            case 0: {
                return this.r.getImage(Resources.ICON.PLANET_SONNE, this.getIconSize(panel), color);
            }
            case 1: {
                return this.r.getImage(Resources.ICON.PLANET_MOND, this.getIconSize(panel), color);
            }
            case 2: {
                return this.r.getImage(Resources.ICON.PLANET_MERKUR, this.getIconSize(panel), color);
            }
            case 3: {
                return this.r.getImage(Resources.ICON.PLANET_VENUS, this.getIconSize(panel), color);
            }
            case 4: {
                return this.r.getImage(Resources.ICON.PLANET_MARS, this.getIconSize(panel), color);
            }
            case 5: {
                return this.r.getImage(Resources.ICON.PLANET_JUPITER, this.getIconSize(panel), color);
            }
            case 6: {
                return this.r.getImage(Resources.ICON.PLANET_SATURN, this.getIconSize(panel), color);
            }
            case 7: {
                return this.r.getImage(Resources.ICON.PLANET_URANUS, this.getIconSize(panel), color);
            }
            case 8: {
                return this.r.getImage(Resources.ICON.PLANET_NEPTUN, this.getIconSize(panel), color);
            }
            case 9: {
                return this.r.getImage(Resources.ICON.PLANET_PLUTO, this.getIconSize(panel), color);
            }
            case 10: {
                return this.r.getImage(Resources.ICON.PLANET_AC, this.getIconSize(panel), color);
            }
            case 11: {
                return this.r.getImage(Resources.ICON.PLANET_DC, this.getIconSize(panel), color);
            }
            case 12: {
                return this.r.getImage(Resources.ICON.PLANET_MC, this.getIconSize(panel), color);
            }
            case 13: {
                return this.r.getImage(Resources.ICON.PLANET_IC, this.getIconSize(panel), color);
            }
        }
        return null;
    }

    public Image getTkzImage(Controlpanel panel, int id) {
        switch (id) {
            case 0: {
                return this.r.getImage(Resources.ICON.TKZ_WIDDER, this.getIconSize(panel), null);
            }
            case 1: {
                return this.r.getImage(Resources.ICON.TKZ_STIER, this.getIconSize(panel), null);
            }
            case 2: {
                return this.r.getImage(Resources.ICON.TKZ_ZWILLINGE, this.getIconSize(panel), null);
            }
            case 3: {
                return this.r.getImage(Resources.ICON.TKZ_KREBS, this.getIconSize(panel), null);
            }
            case 4: {
                return this.r.getImage(Resources.ICON.TKZ_LOEWE, this.getIconSize(panel), null);
            }
            case 5: {
                return this.r.getImage(Resources.ICON.TKZ_JUNGFRAU, this.getIconSize(panel), null);
            }
            case 6: {
                return this.r.getImage(Resources.ICON.TKZ_WAAGE, this.getIconSize(panel), null);
            }
            case 7: {
                return this.r.getImage(Resources.ICON.TKZ_SKORPION, this.getIconSize(panel), null);
            }
            case 8: {
                return this.r.getImage(Resources.ICON.TKZ_SCHUETZE, this.getIconSize(panel), null);
            }
            case 9: {
                return this.r.getImage(Resources.ICON.TKZ_STEINBOCK, this.getIconSize(panel), null);
            }
            case 10: {
                return this.r.getImage(Resources.ICON.TKZ_WASSERMANN, this.getIconSize(panel), null);
            }
            case 11: {
                return this.r.getImage(Resources.ICON.TKZ_FISCHE, this.getIconSize(panel), null);
            }
        }
        return null;
    }

    public Image getAspektImage(AspektTyp aspekt) {
        return this.r.getImage(aspekt.icon);
    }

    public int getPlanetIconSizeInPixel(Controlpanel panel) {
        if (this.paperVersion) {
            return 32;
        }
        switch (panel.getIconSizeId()) {
            case 1: {
                return 18;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 32;
            }
        }
        return 24;
    }

    public int getTkzIconSizeInPixel(Controlpanel panel) {
        if (this.paperVersion) {
            return 40;
        }
        switch (panel.getIconSizeId()) {
            case 1: {
                return 18;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 40;
            }
        }
        return 40;
    }

    public boolean isPaperVersion() {
        return this.paperVersion;
    }

    public void setPaperVersion(boolean paperVersion) {
        this.paperVersion = paperVersion;
    }
}

