/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.paint;

import de.cni.client.paint.ColorFactory;
import de.cni.client.paint.Disposer;
import de.cni.client.paint.PaintRawData;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Leinwand {
    protected Orientation orientation = Orientation.Uhrzeiger;
    protected PaintRawData paintRawData;
    protected GC gc;
    protected Image image;
    protected Display display;
    protected ColorFactory cf = ColorFactory.getInstance();
    protected double alphaOffset = 0.0;
    protected int xMax;
    protected int yMax;
    protected int xCenter;
    protected int yCenter;
    protected int maxRadius;
    protected Font font5;
    protected Font font6;
    protected Font font7;
    protected Font font8;
    protected Font font9;
    protected Font font10;
    protected Font font12;
    protected Font font14;
    protected Font font16;
    protected Font font18;
    protected Font font20;
    protected Font font24;
    protected Font font32;
    protected Font font5Bold;
    protected Font font6Bold;
    protected Font font7Bold;
    protected Font font8Bold;
    protected Font font9Bold;
    protected Font font10Bold;
    protected Font font12Bold;
    protected Font font14Bold;
    protected Font font16Bold;
    protected Font font18Bold;
    protected Font font20Bold;
    protected Font font24Bold;
    protected Font font32Bold;

    public Leinwand(PaintRawData paintRawData) {
        this.paintRawData = paintRawData;
        this.xMax = this.paintRawData.getSizeX();
        this.yMax = this.paintRawData.getSizeY();
        this.xCenter = this.xMax / 2;
        this.yCenter = this.yMax / 2;
        this.maxRadius = Math.min(this.xCenter, this.yCenter);
    }

    public void initialize(GC gc) {
        this.gc = gc;
        this.display = Display.getCurrent();
        this.font5 = this.newFont(5, 0);
        this.font6 = this.newFont(6, 0);
        this.font7 = this.newFont(7, 0);
        this.font8 = this.newFont(8, 0);
        this.font9 = this.newFont(9, 0);
        this.font10 = this.newFont(10, 0);
        this.font12 = this.newFont(12, 0);
        this.font14 = this.newFont(14, 0);
        this.font16 = this.newFont(16, 0);
        this.font18 = this.newFont(18, 0);
        this.font20 = this.newFont(20, 0);
        this.font24 = this.newFont(24, 0);
        this.font32 = this.newFont(32, 0);
        this.font5Bold = this.newFont(5, 1);
        this.font6Bold = this.newFont(6, 1);
        this.font7Bold = this.newFont(7, 1);
        this.font9Bold = this.newFont(9, 1);
        this.font8Bold = this.newFont(8, 1);
        this.font10Bold = this.newFont(10, 1);
        this.font12Bold = this.newFont(12, 1);
        this.font14Bold = this.newFont(14, 1);
        this.font16Bold = this.newFont(16, 1);
        this.font20Bold = this.newFont(20, 1);
        this.font24Bold = this.newFont(24, 1);
        this.font32Bold = this.newFont(32, 1);
        gc.setForeground(this.cf.colorBlack);
    }

    private Font newFont(int size, int style) {
        return new Font((Device)this.display, new FontData("Segoe UI Symbol", size, style));
    }

    public void paint() {
    }

    public void writeCopyright() {
        int textX = 150;
        int textY = 100;
        this.gc.setForeground(this.cf.colorGrey);
        this.gc.setFont(this.font16);
        if (Util.equals(GlobalData.getInstance().getLizenzart(), "Test")) {
            String text = GlobalData.getInstance().getSettings().getFusszeile();
            this.gc.setFont(this.font8);
            this.gc.drawText(text, this.xMax - textX, this.yMax - textY + 32, true);
        }
    }

    public void finalize() {
        Disposer.dispose(this.font5);
        Disposer.dispose(this.font6);
        Disposer.dispose(this.font7);
        Disposer.dispose(this.font8);
        Disposer.dispose(this.font9);
        Disposer.dispose(this.font10);
        Disposer.dispose(this.font12);
        Disposer.dispose(this.font14);
        Disposer.dispose(this.font16);
        Disposer.dispose(this.font18);
        Disposer.dispose(this.font20);
        Disposer.dispose(this.font24);
        Disposer.dispose(this.font32);
        Disposer.dispose(this.font5Bold);
        Disposer.dispose(this.font6Bold);
        Disposer.dispose(this.font7Bold);
        Disposer.dispose(this.font8Bold);
        Disposer.dispose(this.font9Bold);
        Disposer.dispose(this.font10Bold);
        Disposer.dispose(this.font12Bold);
        Disposer.dispose(this.font14Bold);
        Disposer.dispose(this.font16Bold);
        Disposer.dispose(this.font18Bold);
        Disposer.dispose(this.font20Bold);
        Disposer.dispose(this.font24Bold);
        Disposer.dispose(this.font32Bold);
    }

    protected void astroLineGrad(double alpha, double radius) {
        this.astroLine(alpha / 360.0 * 2.0 * Math.PI, radius);
    }

    protected void astroLineGrad(double alpha, double radius1, double radius2) {
        this.astroLine(alpha / 360.0 * 2.0 * Math.PI, radius1, radius2);
    }

    protected void astroLine(double alpha, double radius) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha = -alpha;
        }
        double y2 = radius * Math.sin(alpha + this.alphaOffset);
        double x2 = radius * Math.cos(alpha + this.alphaOffset);
        this.astroLine(0, 0, this.round(x2), this.round(y2));
    }

    protected void astroLine(double alpha, double radius1, double radius2) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha = -alpha;
        }
        double y1 = radius1 * Math.sin(alpha + this.alphaOffset);
        double x1 = radius1 * Math.cos(alpha + this.alphaOffset);
        double y2 = radius2 * Math.sin(alpha + this.alphaOffset);
        double x2 = radius2 * Math.cos(alpha + this.alphaOffset);
        this.astroLine(this.round(x1), this.round(y1), this.round(x2), this.round(y2));
    }

    protected void astroScaleGrad(double alpha, double radius, double length) {
        this.astroScale(alpha * 2.0 * Math.PI / 360.0, radius, length);
    }

    protected void astroScaleTextGrad(double alpha, double radius, double length, String text) {
        this.astroScaleText(alpha * 2.0 * Math.PI / 360.0, radius, length, text);
    }

    protected void astroScaleIconGrad(double alpha, double radius, double length, int size, Image image) {
        this.astroScaleIcon(alpha * 2.0 * Math.PI / 360.0, radius, length, image, size);
    }

    protected void astroScaleText(double alpha, double radius, double scaleLength, String text) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha = -alpha;
        }
        int textHight = this.gc.getFontMetrics().getHeight();
        int textLength = this.round(0.64 * (double)this.gc.getFontMetrics().getAverageCharWidth() * (double)text.length());
        int length = (int)Math.round(Math.sqrt(textHight * textHight + textLength * textLength) / 2.0);
        int y1 = this.round((radius + scaleLength + (double)length) * Math.sin(alpha + this.alphaOffset)) - textHight / 2;
        int x1 = this.round((radius + scaleLength + (double)length) * Math.cos(alpha + this.alphaOffset)) - textLength / 2;
        this.astroText(text, x1, y1);
    }

    public int getSwtStringWith(String s) {
        int len = 0;
        if (s != null && s.length() != 0) {
            for (char c : s.toCharArray()) {
                len += this.gc.getCharWidth(c);
            }
        }
        return len;
    }

    protected void astroScaleIcon(double alpha, double radius, double scaleLength, Image image) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha = -alpha;
        }
        int textHight = 40;
        int textLength = 40;
        int y1 = this.round((double)(-textHight / 2) + (radius + scaleLength / 2.0 + (double)textHight) * Math.sin(alpha + this.alphaOffset));
        int x1 = this.round((double)(-textLength / 2) + (radius + scaleLength / 2.0 + (double)textLength) * Math.cos(alpha + this.alphaOffset));
        this.astroIcon(image, x1, y1, textLength, textHight);
    }

    protected void astroCenterTextGrad(double alpha1, double alpha2, double radius1, double radius2, String text) {
        this.astroCenterText(alpha1 * 2.0 * Math.PI / 360.0, alpha2 * 2.0 * Math.PI / 360.0, radius1, radius2, text);
    }

    protected void astroCenterIconGrad(double alpha1, double alpha2, double radius1, double radius2, int size, Image image) {
        this.astroCenterIcon(alpha1 * 2.0 * Math.PI / 360.0, alpha2 * 2.0 * Math.PI / 360.0, radius1, radius2, size, image);
    }

    protected void astroCenterText(double alpha1, double alpha2, double radius1, double radius2, String text) {
        double alphaCenter = alpha1 + (alpha2 - alpha1) / 2.0;
        double radiusCenter = radius1 + (radius2 - radius1) / 2.0;
        int textHight = this.gc.getFontMetrics().getHeight();
        int textLength = this.round(this.gc.getFontMetrics().getAverageCharWidth() * text.length());
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alphaCenter = -alphaCenter;
        }
        int y1 = this.round(radiusCenter * Math.sin(alphaCenter + this.alphaOffset) - (double)(textHight / 2));
        int x1 = this.round(radiusCenter * Math.cos(alphaCenter + this.alphaOffset) - (double)(textLength / 2));
        this.astroText(text, x1, y1);
    }

    protected void astroCenterIcon(double alpha1, double alpha2, double radius1, double radius2, int size, Image image) {
        double alphaCenter = alpha1 + (alpha2 - alpha1) / 2.0;
        double radiusCenter = radius1 + (radius2 - radius1) / 2.0;
        int hight = size;
        int length = size;
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alphaCenter = -alphaCenter;
        }
        int y1 = this.round(radiusCenter * Math.sin(alphaCenter + this.alphaOffset) - (double)(hight / 2));
        int x1 = this.round(radiusCenter * Math.cos(alphaCenter + this.alphaOffset) - (double)(length / 2));
        this.astroIcon(image, x1, y1, length, hight);
    }

    protected void drawAspektLinieGrad(double alpha1, double alpha2, int radius1, int radius2, Color color) {
        this.drawConjunktionLine(alpha1 * 2.0 * Math.PI / 360.0, alpha2 * 2.0 * Math.PI / 360.0, radius1, radius2, color);
    }

    protected void drawConjunktionLine(double alpha1, double alpha2, int radius1, int radius2, Color color) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha1 = -alpha1;
            alpha2 = -alpha2;
        }
        int y1 = (int)Math.round((double)radius1 * Math.sin(alpha1 + this.alphaOffset));
        int x1 = (int)Math.round((double)radius1 * Math.cos(alpha1 + this.alphaOffset));
        int y2 = (int)Math.round((double)radius2 * Math.sin(alpha2 + this.alphaOffset));
        int x2 = (int)Math.round((double)radius2 * Math.cos(alpha2 + this.alphaOffset));
        this.gc.setForeground(color);
        this.astroLine(x1, y1, x2, y2);
    }

    protected void astroScaleIconGrad(double alpha, double radius, double length, Image image, int size) {
        this.astroScaleIcon(alpha / 360.0 * 2.0 * Math.PI, radius, length, image, size);
    }

    protected void astroScaleIcon(double alpha, double radius, double length, Image icon, int size) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha = -alpha;
        }
        int iconLength = size;
        int iconHight = size;
        int y1 = this.round((double)(-iconHight / 2) + (radius + length / 2.0) * Math.sin(alpha + this.alphaOffset));
        int x1 = this.round((double)(-iconLength / 2) + (radius + length / 2.0) * Math.cos(alpha + this.alphaOffset));
        this.astroIcon(icon, x1, y1, iconLength, iconHight);
    }

    protected void astroScale(double alpha, double radius, double length) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha = -alpha;
        }
        int y1 = this.round((radius - length / 2.0) * Math.sin(alpha + this.alphaOffset));
        int x1 = this.round((radius - length / 2.0) * Math.cos(alpha + this.alphaOffset));
        int y2 = this.round((radius + length / 2.0) * Math.sin(alpha + this.alphaOffset));
        int x2 = this.round((radius + length / 2.0) * Math.cos(alpha + this.alphaOffset));
        this.astroLine(x1, y1, x2, y2);
    }

    protected void astroLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(this.xCenter + x1, this.yCenter + y1, this.xCenter + x2, this.yCenter + y2);
    }

    protected void astroCircle(int radius) {
        this.gc.drawOval(this.xCenter - radius, this.yCenter - radius, 2 * radius, 2 * radius);
    }

    protected void astroFillCircle(int radius) {
        this.gc.fillOval(this.xCenter - radius, this.yCenter - radius, 2 * radius, 2 * radius);
    }

    protected void astroText(String text, int x, int y) {
        this.gc.drawText(text, this.xCenter + x, this.yCenter + y, true);
    }

    protected void absoluteText(String text, int x, int y) {
        this.gc.drawText(text, x, y, true);
    }

    protected void astroIcon(Image image, int x, int y, int sizeX, int sizeY) {
        if (image.getImageData().width == sizeX && image.getImageData().height == sizeY) {
            this.gc.drawImage(image, this.xCenter + x, this.yCenter + y);
        } else {
            ImageData id = image.getImageData().scaledTo(sizeX, sizeY);
            Image i = new Image((Device)this.display, id);
            this.gc.drawImage(i, this.xCenter + x, this.yCenter + y);
            Disposer.dispose(i);
        }
    }

    protected int getIconSize(Image image) {
        Rectangle r = image.getBounds();
        return Math.max(r.height, r.width);
    }

    protected int round(double x) {
        return (int)Math.round(x);
    }

    protected void astrodrawArrow(double alpha, double radius1, double radius2) {
        if (this.orientation == Orientation.Gegenuhrzeiger) {
            alpha = -alpha;
        }
        alpha = alpha / 360.0 * 2.0 * Math.PI;
        double y1 = radius1 * Math.sin(alpha + this.alphaOffset);
        double x1 = radius1 * Math.cos(alpha + this.alphaOffset);
        double y2 = radius2 * Math.sin(alpha + this.alphaOffset);
        double x2 = radius2 * Math.cos(alpha + this.alphaOffset);
        this.drawArrow(this.round(x1), this.round(y1), this.round(x2), this.round(y2), 10.0, 0.5235987755982988);
    }

    private void drawArrow(int x1, int y1, int x2, int y2, double arrowLength, double arrowAngle) {
        x1 = this.xCenter + x1;
        x2 = this.xCenter + x2;
        y1 = this.yCenter + y1;
        y2 = this.yCenter + y2;
        double theta = Math.atan2(y2 - y1, x2 - x1);
        double offset = (arrowLength - 2.0) * Math.cos(arrowAngle);
        this.gc.drawLine(x1, y1, (int)((double)x2 - offset * Math.cos(theta)), (int)((double)y2 - offset * Math.sin(theta)));
        Path path = new Path(this.gc.getDevice());
        path.moveTo((float)((double)x2 - arrowLength * Math.cos(theta - arrowAngle)), (float)((double)y2 - arrowLength * Math.sin(theta - arrowAngle)));
        path.lineTo((float)x2, (float)y2);
        path.lineTo((float)((double)x2 - arrowLength * Math.cos(theta + arrowAngle)), (float)((double)y2 - arrowLength * Math.sin(theta + arrowAngle)));
        path.close();
        this.gc.fillPath(path);
        this.gc.drawPath(path);
        path.dispose();
    }

    protected static enum Orientation {
        Uhrzeiger,
        Gegenuhrzeiger;

    }
}

