/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.paint;

import de.cni.client.gui.pages.main.MainApplicationWindow;
import de.cni.client.gui.pages.personendaten.ReportjobController;
import de.cni.client.gui.popup.filter.PopupTokenReplacerDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.LaunchProgram;
import de.cni.client.gui.util.Popup;
import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.TokenReplacer;
import de.cni.common.core.Util;
import de.cni.common.datamodel.DocumentParameter;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Personendaten;
import de.cni.common.datamodel.admin.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RechnungCreator {
    private static Log log = LogFactory.getLog(RechnungCreator.class);
    Date date;
    Personendaten personendaten;
    Settings settings;

    public RechnungCreator(Personendaten personendaten) {
        this.refreshSettings();
        this.personendaten = personendaten;
        this.settings = GlobalData.getInstance().getSettings();
        this.date = new Date();
    }

    public void popupJasperViewer() {
        String filename;
        ReportjobController reportjobController;
        DocumentParameter documentParameter = new DocumentParameter();
        HashMap<String, Object> presetParameters = new HashMap<String, Object>();
        presetParameters.put("LOGO", this.getLogo());
        presetParameters.put("DATUM", this.date);
        presetParameters.put("PERSONENDATEN", this.personendaten);
        presetParameters.put("SETTINGS", this.settings);
        int ret = this.replaceTokens();
        if (ret == 4) {
            return;
        }
        if (ret == 1) {
            reportjobController = new ReportjobController();
            reportjobController.startBatch(4, true, presetParameters, true, "");
        }
        if (ret == 2) {
            reportjobController = new ReportjobController();
            filename = this.settings.getWorkingDir() + "/Rechnung_" + this.personendaten.getVorname() + "_" + this.personendaten.getNachname() + "_" + this.settings.getRechnungsnummer() + "_" + Converter.dateToSqlString(new Date()) + ".pdf";
            reportjobController.startBatch(4, true, presetParameters, false, filename);
        }
        if (ret == 3) {
            reportjobController = new ReportjobController();
            filename = this.settings.getWorkingDir() + "/Rechnung_" + this.personendaten.getVorname() + "_" + this.personendaten.getNachname() + "_" + this.settings.getRechnungsnummer() + "_" + Converter.dateToSqlString(new Date()) + ".pdf";
            reportjobController.startBatch(4, true, presetParameters, false, filename);
            String to = this.personendaten.getEmail();
            String body = this.personendaten.getAnrede() + "\n\nbeigef\u00fcgt erhalten Sie Ihrer Rechnung.\n\nFreundliche Gr\u00fc\u00dfe\n" + this.settings.getName();
            File file = new File(filename);
            ArrayList<File> files = new ArrayList<File>();
            files.add(file);
            LaunchProgram.openMailWindows(to, "Rechnung " + this.settings.getRechnungsnummer(), body, files);
        }
        if (Popup.question("Rechnungsnummer f\u00fcr die n\u00e4chste Rechnung erh\u00f6hen?")) {
            SqLiteDatabase db = new SqLiteDatabase();
            try {
                String rechnungsnummer = db.incrementRechnungsnummer(this.settings.getRechnungsnummer());
                GlobalData.getInstance().getSettings().setRechnungsnummer(rechnungsnummer);
            }
            catch (Exception e) {
                ErrorHandler.handleError(log, "Es ist ein Fehler beim Erh\u00f6hen der Rechnungsnummer aufgetreten. Bitte passen Sie die Nummer manuell an.", e);
            }
        }
    }

    private int replaceTokens() {
        Map<String, String> tokenmap = new HashMap<String, String>();
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getHeader1(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getHeader2(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getHeader3(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getAbsender(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getRechnungsdaten(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getBetreff(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getText1(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getText2(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getText3(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getFooter1(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getFooter2(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getFooter3(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getRand1(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getRand2(), "%%");
        tokenmap = TokenReplacer.addToTokenMap(tokenmap, this.settings.getRand3(), "%%");
        tokenmap.remove("Name");
        tokenmap.remove("Adresse1");
        tokenmap.remove("Adresse2");
        tokenmap.remove("Adresse3");
        tokenmap.remove("Adresse4");
        tokenmap.remove("E-Mail");
        tokenmap.remove("Kopfzeile");
        if (tokenmap.containsKey("Netto")) {
            tokenmap.remove("Brutto");
            tokenmap.remove("Steuer");
            tokenmap.remove("Steuersatz");
        }
        tokenmap.put("Rechnungsdatum", Converter.dateToString(new Date()));
        tokenmap.put("Rechnungsnummer", this.settings.getRechnungsnummer());
        tokenmap.put("Kundennummer", Converter.intToLeading0String(this.personendaten.getId(), 4));
        PopupTokenReplacerDialog dialog = new PopupTokenReplacerDialog(MainApplicationWindow.getInstance().getShell(), tokenmap, null);
        dialog.open();
        if (dialog.getReturnCode() == 4) {
            return dialog.getReturnCode();
        }
        tokenmap = dialog.getTokenmap();
        String nettoString = tokenmap.get("Netto");
        if (!Util.isEmpty(nettoString)) {
            int steuersatz = this.settings.getSteuersatz();
            tokenmap.put("Steuersatz", Converter.intToString(steuersatz));
            double netto = Converter.germanStringToDouble(nettoString);
            double steuer = Util.euro(netto * (double)steuersatz / 100.0);
            double brutto = Util.euro(netto + steuer);
            tokenmap.put("Netto", Formatter.pReportNumber(netto));
            tokenmap.put("Brutto", Formatter.pReportNumber(brutto));
            tokenmap.put("Steuer", Formatter.pReportNumber(steuer));
            tokenmap.put("Steuersatz", Formatter.pReportNumber(steuersatz));
        }
        tokenmap.put("Name", this.settings.getName());
        tokenmap.put("Adresse1", this.settings.getAdresse1());
        tokenmap.put("Adresse2", this.settings.getAdresse2());
        tokenmap.put("Adresse3", this.settings.getAdresse3());
        tokenmap.put("Adresse4", this.settings.getAdresse4());
        tokenmap.put("E-Mail", this.settings.getEmail());
        tokenmap.put("Kopfzeile", this.settings.getKopfzeile());
        this.settings.setHeader1(TokenReplacer.replaceTokens(this.settings.getHeader1(), tokenmap, "%%"));
        this.settings.setHeader2(TokenReplacer.replaceTokens(this.settings.getHeader2(), tokenmap, "%%"));
        this.settings.setHeader3(TokenReplacer.replaceTokens(this.settings.getHeader3(), tokenmap, "%%"));
        this.settings.setAbsender(TokenReplacer.replaceTokens(this.settings.getAbsender(), tokenmap, "%%"));
        this.settings.setRechnungsdaten(TokenReplacer.replaceTokens(this.settings.getRechnungsdaten(), tokenmap, "%%"));
        this.settings.setBetreff(TokenReplacer.replaceTokens(this.settings.getBetreff(), tokenmap, "%%"));
        this.settings.setText1(TokenReplacer.replaceTokens(this.settings.getText1(), tokenmap, "%%"));
        this.settings.setText2(TokenReplacer.replaceTokens(this.settings.getText2(), tokenmap, "%%"));
        this.settings.setText3(TokenReplacer.replaceTokens(this.settings.getText3(), tokenmap, "%%"));
        this.settings.setFooter1(TokenReplacer.replaceTokens(this.settings.getFooter1(), tokenmap, "%%"));
        this.settings.setFooter2(TokenReplacer.replaceTokens(this.settings.getFooter2(), tokenmap, "%%"));
        this.settings.setFooter3(TokenReplacer.replaceTokens(this.settings.getFooter3(), tokenmap, "%%"));
        this.settings.setRand1(TokenReplacer.replaceTokens(this.settings.getRand1(), tokenmap, "%%"));
        this.settings.setRand2(TokenReplacer.replaceTokens(this.settings.getRand2(), tokenmap, "%%"));
        this.settings.setRand3(TokenReplacer.replaceTokens(this.settings.getRand3(), tokenmap, "%%"));
        return dialog.getReturnCode();
    }

    public String getLogo() {
        String logo = GlobalData.getInstance().getSettings().getLogoFile();
        File f = FileUtils.getFile((String[])new String[]{logo});
        if (f.isFile()) {
            return logo;
        }
        return "./reports/logo.png";
    }

    public void refreshSettings() {
        try {
            SqLiteDatabase db = new SqLiteDatabase();
            List<IBusinessObject> boList = db.select(new Settings());
            if (boList != null && boList.size() > 0) {
                Settings settings = (Settings)boList.get(0);
                GlobalData.getInstance().setSettings(settings);
            }
        }
        catch (Exception e) {
            GlobalData.getInstance().setSettings(new Settings());
        }
    }
}

