/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.reporting;

import de.cni.common.core.Util;
import java.io.FileInputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePrinter {
    private static Log log = LogFactory.getLog(FilePrinter.class);

    public void printFile(String filename, boolean portrait, String printername) throws Exception {
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
        FileInputStream fis = new FileInputStream(filename);
        HashDocAttributeSet das = new HashDocAttributeSet();
        das.add(MediaSizeName.ISO_A4);
        pras.add(new Copies(2));
        if (portrait) {
            pras.add(OrientationRequested.PORTRAIT);
            das.add(OrientationRequested.PORTRAIT);
        } else {
            pras.add(OrientationRequested.LANDSCAPE);
            das.add(OrientationRequested.LANDSCAPE);
        }
        PrintService service = this.getPrintService(printername, pras);
        if (service != null) {
            DocPrintJob job = service.createPrintJob();
            SimpleDoc doc = new SimpleDoc(fis, flavor, das);
            job.print(doc, pras);
        }
    }

    private PrintService getPrintService(String printerName, PrintRequestAttributeSet aset) {
        if (Util.isEmpty(printerName)) {
            return PrintServiceLookup.lookupDefaultPrintService();
        }
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, aset);
        if (services.length == 0) {
            return null;
        }
        int selectedService = -1;
        for (int i = 0; i < services.length; ++i) {
            log.debug((Object)("Service:" + services[i].getName()));
            if (!services[i].getName().contains(printerName)) continue;
            selectedService = i;
            log.debug((Object)("Drucker gefunden" + printerName));
            break;
        }
        if (selectedService == -1) {
            log.debug((Object)("Drucker nicht gefunden" + printerName));
            return null;
        }
        return services[selectedService];
    }
}

