/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.astrologie;

import de.cni.client.gui.util.Resources;
import de.cni.common.core.Util;

public enum AspektTyp {
    empty(0.0, "", "", null),
    konjunktion(0.0, "konj", "Konjunktion", Resources.ICON.ASPEKT_KONJUNKTION),
    sextil(60.0, "sext", "Sextil", Resources.ICON.ASPEKT_SEXTIL),
    quadrat(90.0, "quad", "Quadrat", Resources.ICON.ASPEKT_QUADRAT),
    trigon(120.0, "tri", "Trigon", Resources.ICON.ASPEKT_TRIGON),
    opposition(180.0, "opo", "Opposition", Resources.ICON.ASPEKT_OPPOSITION);

    public double winkelbeziehung;
    public String name;
    public String langname;
    public Resources.ICON icon;

    private AspektTyp(double winkelbeziehung, String name, String langname, Resources.ICON icon) {
        this.winkelbeziehung = winkelbeziehung;
        this.name = name;
        this.langname = langname;
        this.icon = icon;
    }

    public static AspektTyp[] getAll() {
        return new AspektTyp[]{konjunktion, sextil, quadrat, trigon, opposition};
    }

    public static AspektTyp getAspekt(int id) {
        switch (id) {
            case 0: {
                return empty;
            }
            case 1: {
                return konjunktion;
            }
            case 2: {
                return sextil;
            }
            case 3: {
                return quadrat;
            }
            case 4: {
                return trigon;
            }
            case 5: {
                return opposition;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Resources.ICON getIcon() {
        return this.icon;
    }

    public String getIconname() {
        return this.icon.toString().replace("ASPEKT_", "") + ".png";
    }

    public String getLangname() {
        return this.langname;
    }

    public void setLangname(String langname) {
        this.langname = langname;
    }

    public static AspektTyp getAspektTyp(String name) {
        for (AspektTyp a : AspektTyp.values()) {
            if (!Util.equals(a.name, name) && !Util.equals(a.langname, name)) continue;
            return a;
        }
        return null;
    }
}

