/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.astrologie;

import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.PlanetInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import swisseph.SweDate;
import swisseph.SwissEph;
import swisseph.SwissephException;

public class Calculator {
    static SwissEph sw = null;
    private static String ephe_path = null;
    public static final TimeZone GMT0 = TimeZone.getTimeZone("GMT+0");

    public static String getEphe_path() {
        return ephe_path;
    }

    public static void setEphe_path(String path) {
        ephe_path = path;
    }

    public Calculator() {
        if (sw == null) {
            Calculator.initSwissEph();
        }
    }

    private static SwissEph initSwissEph() {
        sw = new SwissEph(ephe_path);
        return sw;
    }

    public SweDate calcSweDate(Date date) {
        Calendar calendar = Calendar.getInstance(GMT0);
        calendar.setTime(date);
        SweDate sd = new SweDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5), (double)calendar.get(11) + (double)calendar.get(12) / 60.0 + (double)calendar.get(13) / 3600.0 + (double)calendar.get(14) / 3600000.0);
        return sd;
    }

    public SweDate calcSweDate(int year, int month, int day, int hour, int minutes, int second, String timezone) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, second);
        calendar.set(14, 0);
        return this.calcSweDate(calendar.getTime());
    }

    public PlanetInfo calc(SweDate sd, int planet, int iflag) {
        return this.calc(sd.getJulDay(), planet, iflag);
    }

    public PlanetInfo calc(double julianDay, int planet, int iflag) {
        double[] res = new double[6];
        StringBuffer sbErr = new StringBuffer();
        int rc = sw.swe_calc_ut(julianDay, planet, iflag, res, sbErr);
        if (sbErr.length() > 0) {
            System.err.println(sbErr.toString());
        }
        if (rc == -1) {
            throw new SwissephException(julianDay, sbErr.toString());
        }
        return new PlanetInfo(planet, res);
    }

    public PlanetInfo calc(SweDate sd, int planet) {
        return this.calc(sd, planet, 256);
    }

    public PlanetInfo calc(double julianDay, int planet) {
        return this.calc(julianDay, planet, 256);
    }

    public HousesInfo houses(SweDate sd, double latitude, double longitude, int hsy) {
        double[] cusp = new double[13];
        double[] ascmc = new double[10];
        int result = sw.swe_houses(sd.getJulDay(), 0, latitude, longitude, hsy, cusp, ascmc);
        if (result == -1) {
            throw new SwissephException(sd.getJulDay(), "Calculation was not possible due to nearness to the polar circle in Koch or Placidus house system or when requesting Gauquelin sectors. Calculation automatically switched to Porphyry house calculation method in this case");
        }
        return new HousesInfo(cusp, ascmc[0], ascmc[1]);
    }

    public double calcFort(HousesInfo hi, PlanetInfo sun, PlanetInfo moon) {
        double k = sun.getLongitude() - hi.getAc();
        if (k < 0.0) {
            k += 360.0;
        }
        double f = k > 180.0 ? hi.getAc() - sun.getLongitude() + moon.getLongitude() : hi.getAc() + sun.getLongitude() - moon.getLongitude();
        return f;
    }

    public static String getPlanetName(int planet) {
        return sw.swe_get_planet_name(planet);
    }
}

