/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.astrologie;

import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.core.Constants;
import de.cni.common.core.Trigo;

public class EphPlanetInfo {
    public static final String[] planet_names = new String[]{"Sun", "Moon", "Merc", "Venu", "Mars", "Jupi", "Satu", "Uran", "Nept", "Plut", "mNde", "tNde", "Lili", "oApo", "Eart", "Chir", "Phol", "Cere", "Pall", "Juno", "Vest"};
    public static int PLANET_MAX = planet_names.length;
    protected int id;
    protected double longitude;
    protected double latitude;
    protected double distance;
    protected double longitudeSpeed;
    protected double latitudeSpeed;
    protected double distanceSpeed;

    public EphPlanetInfo() {
    }

    public EphPlanetInfo(int id) {
        this.id = id;
    }

    public EphPlanetInfo(int id, double longitude) {
        this.id = id;
        this.longitude = longitude;
    }

    public EphPlanetInfo(int planetId, double[] xx) {
        this.id = planetId;
        this.longitude = xx[0];
        this.latitude = xx[1];
        this.distance = xx[2];
        this.longitudeSpeed = xx[3];
        this.latitudeSpeed = xx[4];
        this.distanceSpeed = xx[5];
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistanceSpeed() {
        return this.distanceSpeed;
    }

    public void setDistanceSpeed(double distanceSpeed) {
        this.distanceSpeed = distanceSpeed;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLatitudeSpeed() {
        return this.latitudeSpeed;
    }

    public void setLatitudeSpeed(double latitudeSpeed) {
        this.latitudeSpeed = latitudeSpeed;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLongitudeSpeed() {
        return this.longitudeSpeed;
    }

    public void setLongitudeSpeed(double longitudeSpeed) {
        this.longitudeSpeed = longitudeSpeed;
    }

    public int getId() {
        return this.id;
    }

    public String getPlanetName() {
        return EphPlanetInfo.getPlanetName(this.id);
    }

    public String getAstroPlanetName() {
        return Constants.planeten[this.id];
    }

    public String getPosition() {
        return FormatterGradzahlen.format(this.getLongitude());
    }

    public String toString() {
        return this.toString(false, 0.0);
    }

    public String toString(boolean relativeToTkz, double asc) {
        String s = this.getAstroPlanetName();
        if (relativeToTkz) {
            s = s + "\t" + FormatterGradzahlen.format(this.getLongitude());
            if (this.getLongitudeSpeed() < 0.0) {
                s = s + " R";
            }
            s = s + "\t( " + FormatterGradzahlen.formatAbsolute(this.getTransferedLongitude(asc)) + ")";
        } else {
            s = s + "\t" + FormatterGradzahlen.format(this.getLongitude());
        }
        if (this.getLongitudeSpeed() < 0.0) {
            s = s + " R";
        }
        return s;
    }

    public double getWinkelRel() {
        return Trigo.grad(this.longitude);
    }

    public double getWinkelAbs(double asc) {
        return Trigo.grad(this.getTransferedLongitude(asc));
    }

    public boolean isReverseDirection(double asc) {
        return this.getLongitudeSpeed() < 0.0;
    }

    public double getTransferedLongitude(double asc) {
        return FormatterGradzahlen.transfer(this.longitude, asc);
    }

    public double getTransferedLongitude(double asc, double offset) {
        return FormatterGradzahlen.transfer(this.longitude, asc, offset);
    }

    public static String getPlanetName(int id) {
        if (id >= 0 && id < 21) {
            return planet_names[id];
        }
        return "";
    }
}

