/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.astrologie;

import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.core.Converter;

public class HousesInfo {
    public static int anz = 13;
    private double ac;
    private double mc;
    private double acAbs;
    private double mcAbs;
    public double[] houseVonRel = new double[anz];
    public double[] houseVonAbs = new double[anz];
    public double[] houseBisAbs = new double[anz];

    public HousesInfo() {
    }

    public HousesInfo(double[] cusp, double ac, double mc) {
        int i;
        this.houseVonRel = cusp;
        this.ac = ac;
        this.mc = mc;
        this.acAbs = FormatterGradzahlen.transfer(ac, ac);
        this.mcAbs = FormatterGradzahlen.transfer(mc, ac);
        this.houseVonAbs[1] = -180.0;
        this.houseBisAbs[12] = 180.0;
        for (i = 2; i <= 12; ++i) {
            double winkel;
            this.houseBisAbs[i - 1] = winkel = FormatterGradzahlen.transfer(this.houseVonRel[i], ac);
            this.houseVonAbs[i] = winkel;
        }
        for (i = 1; i <= 12; ++i) {
            if (this.houseVonAbs[i] < 0.0) {
                this.houseVonAbs[i] = this.houseVonAbs[i] + 360.0;
            }
            if (!(this.houseBisAbs[i] < 0.0)) continue;
            this.houseBisAbs[i] = this.houseBisAbs[i] + 360.0;
        }
    }

    public String toString(int houseIndex, boolean relativeToTkz, double ac) {
        double alpha = this.houseVonRel[houseIndex];
        String s = Converter.intToLeading0String(houseIndex, 2) + ". Haus\t";
        if (relativeToTkz) {
            s = s + FormatterGradzahlen.format(alpha);
            s = s + "\t( " + FormatterGradzahlen.formatAbsolute(FormatterGradzahlen.transfer(alpha, ac)) + " )";
        } else {
            s = s + FormatterGradzahlen.format(alpha);
        }
        return s;
    }

    public double getHouse(int houseIndex) {
        return this.houseVonRel[houseIndex];
    }

    public double getAc() {
        return this.ac;
    }

    public double getMc() {
        return this.mc;
    }

    public double[] getHouseVonGrad() {
        return this.houseVonAbs;
    }

    public double getHouseVonGrad(int idx) {
        return this.houseVonAbs[idx];
    }

    public double getHouseVonAbs(int idx) {
        return this.houseVonAbs[idx];
    }

    public void setHouseVonGrad(int idx, double value) {
        this.houseVonAbs[idx] = value;
    }

    public double[] getHouseBisAbs() {
        return this.houseBisAbs;
    }

    public double getHouseBisAbs(int idx) {
        return this.houseBisAbs[idx];
    }

    public void setHouseBisGrad(int idx, double value) {
        this.houseBisAbs[idx] = value;
    }

    public double[] getHousesVonRel() {
        return this.houseVonRel;
    }

    public void setHousesVonRel(double[] houses) {
        this.houseVonRel = houses;
    }

    public void setAc(double ac) {
        this.ac = ac;
    }

    public void setMc(double mc) {
        this.mc = mc;
    }

    public void setHouseVonAbs(double[] houseVonAbs) {
        this.houseVonAbs = houseVonAbs;
    }

    public void setHouseBisAbs(double[] houseBisAbs) {
        this.houseBisAbs = houseBisAbs;
    }

    public double getAcAbs() {
        return this.acAbs;
    }

    public double getMcAbs() {
        return this.mcAbs;
    }

    public double[] getHouseVonRel() {
        return this.houseVonRel;
    }

    public double[] getHouseVonAbs() {
        return this.houseVonAbs;
    }

    public void setAcAbs(double acAbs) {
        this.acAbs = acAbs;
    }

    public void setMcAbs(double mcAbs) {
        this.mcAbs = mcAbs;
    }

    public void setHouseVonRel(double[] houseVonRel) {
        this.houseVonRel = houseVonRel;
    }
}

