/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.astrologie;

import de.cni.client.gui.util.Resources;
import de.cni.common.astrologie.EphPlanetInfo;
import de.cni.common.core.Constants;
import de.cni.common.core.Trigo;

public class PlanetInfo
extends EphPlanetInfo
implements Comparable<PlanetInfo> {
    public static final String[] planet_names = Constants.planeten;
    public static int PLANET_MAX = planet_names.length;
    public static int REAL_PLANET_MAX = planet_names.length - 4;
    public static final int PLANET_SONNE_ID = 0;
    public static final int PLANET_MOND_ID = 1;
    public static final int PLANET_MERKUR_ID = 2;
    public static final int PLANET_VENUS_ID = 3;
    public static final int PLANET_MARS_ID = 4;
    public static final int PLANET_JUPITER_ID = 5;
    public static final int PLANET_SATURN_ID = 6;
    public static final int PLANET_URANUS_ID = 7;
    public static final int PLANET_NEPTUN_ID = 8;
    public static final int PLANET_PLUTO_ID = 9;
    public static final int PLANET_AC_ID = 10;
    public static final int PLANET_DC_ID = 11;
    public static final int PLANET_MC_ID = 12;
    public static final int PLANET_IC_ID = 13;

    public PlanetInfo() {
    }

    public PlanetInfo(int id) {
        super(id);
    }

    public PlanetInfo(int id, double longitude) {
        super(id, longitude);
    }

    public PlanetInfo(int planetId, double[] xx) {
        super(planetId, xx);
    }

    public static Resources.ICON getPlanetIcon(int id) {
        switch (id) {
            case 0: {
                return Resources.ICON.PLANET_SONNE;
            }
            case 1: {
                return Resources.ICON.PLANET_MOND;
            }
            case 2: {
                return Resources.ICON.PLANET_MERKUR;
            }
            case 3: {
                return Resources.ICON.PLANET_VENUS;
            }
            case 4: {
                return Resources.ICON.PLANET_MARS;
            }
            case 5: {
                return Resources.ICON.PLANET_JUPITER;
            }
            case 6: {
                return Resources.ICON.PLANET_SATURN;
            }
            case 7: {
                return Resources.ICON.PLANET_URANUS;
            }
            case 8: {
                return Resources.ICON.PLANET_NEPTUN;
            }
            case 9: {
                return Resources.ICON.PLANET_PLUTO;
            }
            case 10: {
                return Resources.ICON.PLANET_AC;
            }
            case 11: {
                return Resources.ICON.PLANET_DC;
            }
            case 12: {
                return Resources.ICON.PLANET_MC;
            }
            case 13: {
                return Resources.ICON.PLANET_IC;
            }
        }
        return null;
    }

    public static String getTextSymbol(int id) {
        switch (id) {
            case 0: {
                return "\u2609";
            }
            case 1: {
                return "\u263d";
            }
            case 2: {
                return "\u263f";
            }
            case 3: {
                return "\u2640";
            }
            case 4: {
                return "\u2642";
            }
            case 5: {
                return "\u2643";
            }
            case 6: {
                return "\u2644";
            }
            case 7: {
                return "\u26e2";
            }
            case 8: {
                return "\u2646";
            }
            case 9: {
                return "\u2647";
            }
            case 10: {
                return "AC";
            }
            case 11: {
                return "DC";
            }
            case 12: {
                return "MC";
            }
            case 13: {
                return "IC";
            }
        }
        return null;
    }

    @Override
    public int compareTo(PlanetInfo pi) {
        double longi = pi.getLongitude();
        double d = Trigo.grad(this.getLongitude()) - Trigo.grad(longi);
        if (d > 0.0 && d < 1.0) {
            return 1;
        }
        if (d < 0.0 && d > -1.0) {
            return -1;
        }
        return (int)d;
    }
}

