/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.AspektTyp;
import de.cni.common.calculation.Horoskop;
import de.cni.common.core.Constants;
import de.cni.common.core.Formatter;

public class AnalyseAspektElement {
    String horoskopname;
    int planet1;
    int planet2;
    AspektTyp aspekt;
    String transittext;

    public AnalyseAspektElement(String horoskop, int planet1, int planet2, AspektTyp aspekt, String transittext) {
        this.horoskopname = horoskop;
        this.planet1 = planet1;
        this.planet2 = planet2;
        this.aspekt = aspekt;
        this.transittext = transittext;
    }

    public String toString() {
        return this.aspekt.langname + ": " + Constants.planeten[this.planet1] + " --> " + Constants.planeten[this.planet2] + (this.isTransit() ? " (t)" : "") + Formatter.dependingOnSecondString(", ", this.transittext);
    }

    private boolean isTransit() {
        return Horoskop.fromString(this.horoskopname).isTransit();
    }

    public int getPlanet1() {
        return this.planet1;
    }

    public int getPlanet2() {
        return this.planet2;
    }

    public AspektTyp getAspekt() {
        return this.aspekt;
    }

    public void setPlanet1(int planet1) {
        this.planet1 = planet1;
    }

    public void setPlanet2(int planet2) {
        this.planet2 = planet2;
    }

    public void setAspekt(AspektTyp aspekt) {
        this.aspekt = aspekt;
    }

    public String getHoroskopname() {
        return this.horoskopname;
    }

    public void setHoroskopname(String horoskopname) {
        this.horoskopname = horoskopname;
    }
}

