/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Tupel;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AstroHelper {
    Astrodaten astrodaten;

    public AstroHelper(Astrodaten astrodaten) {
        this.astrodaten = astrodaten;
    }

    public List<String> getPlanetenByHaus(String haus, int dreiGradRegelOffset) {
        ArrayList<String> list = new ArrayList<String>();
        int hausId = Converter.stringToInt(haus);
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(hausId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(hausId));
        for (int planetId = 0; planetId < Constants.planeten.length; ++planetId) {
            String planetName = Constants.planeten[planetId];
            double gradPlanet = Trigo.grad(this.getGradPlanet(planetName) + (double)dreiGradRegelOffset);
            if (!Trigo.isBetween(gradPlanet, von, bis)) continue;
            list.add(planetName);
        }
        return list;
    }

    public List<String> getEchtePlanetenByHaus(String haus, int dreiGradRegelOffset) {
        ArrayList<String> list = new ArrayList<String>();
        int hausId = Converter.stringToInt(haus);
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(hausId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(hausId));
        for (int planetId = 0; planetId < 10; ++planetId) {
            String planetName = Constants.planeten[planetId];
            double gradPlanet = Trigo.grad(this.getGradPlanet(planetName) + (double)dreiGradRegelOffset);
            if (!Trigo.isBetween(gradPlanet, von, bis)) continue;
            list.add(planetName);
        }
        return list;
    }

    public double[] getGradTkz(String tkzName) {
        double[] result = new double[2];
        double offset = -(this.astrodaten.housesInfo.getAc() + 180.0);
        result[0] = Trigo.grad(offset + (double)Tkz.getGrad(tkzName));
        result[1] = Trigo.grad(offset + (double)Tkz.getGradNext(tkzName));
        return result;
    }

    public double[] getGradHaus(String hausId) {
        return this.getGradHaus(Converter.stringToInt(hausId));
    }

    public double[] getGradHaus(int hausId) {
        double[] result = new double[]{Trigo.grad(this.astrodaten.getHausVonGrad(hausId)), Trigo.grad(this.astrodaten.getHausBisGrad(hausId))};
        return result;
    }

    public boolean hasTkz(String planetName, String tkz) {
        int myTkzId = AstroHelper.getTkzId(tkz);
        double offset = -(this.astrodaten.housesInfo.getAc() + 180.0);
        String kuerzel = Tkz.name[myTkzId];
        double von = Trigo.grad(offset + (double)Tkz.getGrad(kuerzel));
        double bis = Trigo.grad(offset + (double)Tkz.getGradNext(kuerzel));
        double gradPlanet = this.getGradPlanet(planetName);
        return Trigo.isBetween(gradPlanet, von, bis);
    }

    public String getTkzByPlanet(String planetName) {
        for (String tkz : Constants.tkz) {
            if (!this.hasTkz(planetName, tkz)) continue;
            return tkz;
        }
        return null;
    }

    public String getHausByPlanet(String planetName, int dreiGradOffset) {
        for (int hausId = 1; hausId <= 12; ++hausId) {
            double bis;
            double von;
            double gradPlanet = Trigo.grad(this.getGradPlanet(planetName) + (double)dreiGradOffset);
            if (!Trigo.isBetween(gradPlanet, von = Trigo.grad(this.astrodaten.getHausVonGrad(hausId)), bis = Trigo.grad(this.astrodaten.getHausBisGrad(hausId)))) continue;
            return Converter.intToString(hausId);
        }
        return "0";
    }

    public List<Tupel> getTkzByHaus(String hausId) {
        return this.getTkzByHaus(Converter.stringToInt(hausId));
    }

    public List<Tupel> getTkzByHaus(int hausId) {
        ArrayList<Tupel> result = new ArrayList<Tupel>();
        double vonHaus = this.getGradHaus(hausId)[0];
        double bisHaus = this.getGradHaus(hausId)[1];
        for (String tkz : Constants.tkz) {
            double vonTkz = this.getGradTkz(tkz)[0];
            double bisTkz = this.getGradTkz(tkz)[1];
            if (!Trigo.isBetween(vonTkz, vonHaus, bisHaus) && !Trigo.isBetween(bisTkz, vonHaus, bisHaus) && !Trigo.isBetween(vonHaus, vonTkz, bisTkz) && !Trigo.isBetween(bisHaus, bisTkz, bisTkz)) continue;
            Tupel t = new Tupel();
            t.name = tkz;
            t.von = vonTkz;
            t.bis = bisTkz;
            t.masterVon = vonHaus;
            t.masterBis = bisHaus;
            result.add(t);
        }
        Collections.sort(result);
        return result;
    }

    public double getGradPlanet(String planet) {
        HousesInfo hi = this.astrodaten.housesInfo;
        double ac = 180.0;
        double dc = 0.0;
        double mc = hi.getMcAbs();
        double ic = (mc + 180.0) % 360.0;
        int id1 = this.getPlanetId(planet);
        double gradPlanet = 0.0;
        if (id1 == AspektariumCalculator.ID_AC) {
            gradPlanet = ac;
        } else if (id1 == AspektariumCalculator.ID_DC) {
            gradPlanet = dc;
        } else if (id1 == AspektariumCalculator.ID_MC) {
            gradPlanet = mc;
        } else if (id1 == AspektariumCalculator.ID_IC) {
            gradPlanet = ic;
        } else {
            double asc = this.astrodaten.housesInfo.getAc();
            gradPlanet = Trigo.grad(this.astrodaten.planet[id1].getTransferedLongitude(asc));
        }
        return gradPlanet;
    }

    public Integer getPlanetId(String name) {
        for (int i = 0; i < Constants.planeten.length; ++i) {
            if (!Util.equals(name, Constants.planeten[i])) continue;
            return i;
        }
        return null;
    }

    public static Integer getTkzId(String name) {
        for (int i = 0; i < Constants.tkz.length; ++i) {
            if (!Util.equals(name, Constants.tkz[i])) continue;
            return i;
        }
        return null;
    }
}

