/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.popup.filter.ExchangeParameter;
import de.cni.client.gui.popup.filter.PopupFileDialog;
import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.gui.util.Popup;
import de.cni.client.paint.Controlpanel;
import de.cni.common.calculation.Aspektarium;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.TransitCalculator;
import de.cni.common.calculation.TransitHausCalculator;
import de.cni.common.calculation.TransitHausRange;
import de.cni.common.calculation.TransitRange;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import de.cni.common.io.ResultFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchjobTransitzeiten {
    private static Log log = LogFactory.getLog(BatchjobTransitzeiten.class);
    Controlpanel controlpanel = new Controlpanel(GlobalData.getInstance().getSettings());

    public void runBatch(ExchangeParameter exchangeParameter) throws Exception {
        boolean withPopup;
        String title = null;
        Date berechnungsdatum = exchangeParameter.von;
        int stepInMinutes = 2880;
        if (exchangeParameter.planet1 >= 0) {
            for (int i = 0; i < 14; ++i) {
                this.controlpanel.getPlaneten1()[i] = false;
                this.controlpanel.getPlaneten2()[i] = false;
            }
            this.controlpanel.getPlaneten1()[exchangeParameter.planet1] = true;
            this.controlpanel.getPlaneten2()[exchangeParameter.planet1] = true;
        }
        ArrayList<TransitRange> totalList = new ArrayList<TransitRange>();
        HoroskopCalculator horoskopCalculator = new HoroskopCalculator();
        do {
            System.out.println("#### Berechnung f\u00fcr " + Converter.timeToString(berechnungsdatum));
            if (exchangeParameter.horoskop == Horoskop.Transit) {
                horoskopCalculator.calculateTransit(exchangeParameter.personendaten1, berechnungsdatum);
            } else if (exchangeParameter.horoskop == Horoskop.KompositTransit) {
                horoskopCalculator.calculateKompoTransit(exchangeParameter.personendaten1, exchangeParameter.personendaten2, berechnungsdatum);
            } else if (exchangeParameter.horoskop == Horoskop.Synastrie) {
                horoskopCalculator.calculateSynastrie(exchangeParameter.personendaten1, exchangeParameter.personendaten2);
            } else {
                Popup.error("F\u00fcr ein " + exchangeParameter.horoskop.getName() + "-Horoskop k\u00f6nnen die Transite nicht bestimmt werden.");
                return;
            }
            if (title == null) {
                title = horoskopCalculator.getTitle() + "\n";
                title = title + "Zeitraum: " + Converter.dateToString(exchangeParameter.von) + " bis " + Converter.dateToString(exchangeParameter.bis);
            }
            AspektariumCalculator aspektariumCalculator = new AspektariumCalculator(horoskopCalculator.getHoroskop(), this.controlpanel);
            Aspektarium interaspektarium = aspektariumCalculator.berechneInterAspekte(horoskopCalculator.getAstrodaten1(), horoskopCalculator.getAstrodaten2(), horoskopCalculator.getAstrodaten2().getOffset());
            TransitCalculator transitCalculator = new TransitCalculator(horoskopCalculator, this.controlpanel, interaspektarium.getPlanetListe(), interaspektarium.getAspektArray());
            if (exchangeParameter.planet1 >= 0) {
                transitCalculator.setUsePanel(true);
            }
            List<TransitRange> transitRangeList = transitCalculator.calculate(0, true);
            Iterator<TransitRange> iterator = transitRangeList.iterator();
            while (iterator.hasNext()) {
                TransitRange transitRange = iterator.next();
                if (totalList.contains(transitRange)) continue;
                totalList.add(transitRange);
            }
        } while (DateUtil.compareDateWithoutTime(berechnungsdatum = DateUtil.dateAddMinutes(berechnungsdatum, stepInMinutes), exchangeParameter.bis) < 0);
        Collections.sort(totalList);
        String result = "----------------------------------------------------------------------------------\n";
        result = result + exchangeParameter.horoskop.getName() + "\n";
        result = result + title + "\n";
        result = result + "----------------------------------------------------------------------------------\n";
        for (TransitRange transitRange : totalList) {
            if (transitRange.getPlanetnr1() == 11 || transitRange.getPlanetnr1() == 13 || transitRange.getPlanetnr2() >= 10 || transitRange.getPlanetnr2() < 6) continue;
            if (!totalList.contains(transitRange)) {
                totalList.add(transitRange);
            }
            result = result + Converter.timeToString(transitRange.getTransitVon()) + ";" + Converter.timeToString(transitRange.getTransitBis()) + ";" + Constants.planeten[transitRange.getPlanetnr1()] + ";" + Constants.planeten[transitRange.getPlanetnr2()] + ";" + transitRange.getAspekttyp().langname + ";Haus " + transitRange.getPlanetNr1Haus() + ";" + transitRange.getPlanetNr1Tkz() + ";Haus " + transitRange.getPlanetNr2Haus() + ";" + transitRange.getPlanetNr2Tkz() + ";\n";
        }
        TransitHausCalculator transitHausCalculator = new TransitHausCalculator(horoskopCalculator, this.controlpanel);
        List<TransitHausRange> listTransitHausRange = transitHausCalculator.calculate(exchangeParameter.von, exchangeParameter.bis, horoskopCalculator.getHoroskop().getPlanetenSaetze(), true);
        for (TransitHausRange transitHausRange : listTransitHausRange) {
            result = result + Converter.timeToString(transitHausRange.getTransitVon()) + ";" + Converter.timeToString(transitHausRange.getTransitBis()) + ";" + Constants.planeten[transitHausRange.getPlanetnr()] + ";Haus" + transitHausRange.getHaus() + ";\n";
        }
        System.out.println(result);
        String filename = horoskopCalculator.getHoroskop().getName() + "_" + horoskopCalculator.getPd1().getNachname() + (horoskopCalculator.getPd2() == null ? "" : "_" + horoskopCalculator.getPd2().getNachname()) + "_" + Converter.dateToSortableString(exchangeParameter.von) + "_" + Converter.dateToSortableString(exchangeParameter.bis);
        boolean ret = true;
        boolean bl = withPopup = !exchangeParameter.automatischSpeichern;
        if (withPopup) {
            ret = Popup.textfieldPopupWithSaveButton(filename, result);
        }
        if (ret && (filename = this.saveResultString(filename, result, withPopup)) != null) {
            Popup.info("Datei " + filename + " wurde gespeichert.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveResultString(String filename, String result, boolean withPopup) {
        try {
            String ext = "csv";
            String extName = "CSV-Format";
            if (withPopup) {
                if (Util.isEmpty(filename = PopupFileDialog.openSaveFileDialog(filename, new String[]{"*." + ext}, new String[]{extName}))) {
                    return null;
                }
                if (!filename.endsWith("." + ext)) {
                    filename = filename + "." + ext;
                }
            } else {
                String workingDir = GlobalData.getInstance().getSettings().getWorkingDir();
                if (Util.isEmpty(workingDir)) {
                    workingDir = "io";
                }
                filename = workingDir + "/" + filename + "." + ext;
            }
            if (filename.endsWith(".csv")) {
                try (ResultFile resultFile = null;){
                    resultFile = new ResultFile(filename, StandardCharsets.ISO_8859_1);
                    resultFile.print(result);
                }
            }
            return filename;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return null;
        }
    }
}

