/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.util.ErrorHandler;
import de.cni.common.calculation.AstroHelper;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Herrscher;
import de.cni.common.calculation.HerrscherResultList;
import de.cni.common.core.Constants;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HerrscherCalculator {
    private static Log log = LogFactory.getLog(HerrscherCalculator.class);
    String horoskopName;
    Set<String> foundSet = new HashSet<String>();
    AstroHelper ah;
    HerrscherResultList hrl = new HerrscherResultList();

    public HerrscherCalculator(String horoskopName, Astrodaten astrodaten) {
        this.horoskopName = horoskopName;
        this.ah = new AstroHelper(astrodaten);
    }

    public String calculateHerrscherAnalyseNachRandolf(int dreiGradRegelOffset) {
        try {
            this.hrl = new HerrscherResultList();
            for (int hausId = 1; hausId <= 12; ++hausId) {
                this.foundSet = new HashSet<String>();
                String tkz = this.ah.getTkzByHaus((int)hausId).get((int)0).name;
                String herrscherPlanet = Herrscher.getHerrscherPlanet(tkz);
                String herrscherHaus = this.ah.getHausByPlanet(herrscherPlanet, dreiGradRegelOffset);
                this.hrl.add(this.horoskopName, hausId, "", tkz, herrscherPlanet, herrscherHaus);
                this.herrscherIterationPlanetNachRandolf(hausId, herrscherPlanet, 0, Constants.planeten.length, dreiGradRegelOffset);
            }
            return this.hrl.toRandolfString();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return "";
        }
    }

    public String calculateHerrscherAnalyseClassic(int dreiGradRegelOffset) {
        try {
            this.hrl = new HerrscherResultList();
            for (int hausId = 1; hausId <= 12; ++hausId) {
                this.foundSet = new HashSet<String>();
                String tkz = this.ah.getTkzByHaus((int)hausId).get((int)0).name;
                String herrscherPlanet = Herrscher.getHerrscherPlanet(tkz);
                String herrscherHaus = this.ah.getHausByPlanet(herrscherPlanet, dreiGradRegelOffset);
                this.hrl.add(this.horoskopName, hausId, "", tkz, herrscherPlanet, herrscherHaus);
                this.herrscherIterationPlanetClassic(hausId, herrscherPlanet, 0, Constants.planeten.length, dreiGradRegelOffset);
            }
            return this.hrl.toClassicString();
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
            return "";
        }
    }

    private void herrscherIterationPlanetClassic(int hausId, String planetName, int n, int max, int dreiGradRegelOffset) throws IOException {
        if (this.foundSet.contains(planetName)) {
            return;
        }
        this.foundSet.add(planetName);
        String haus = this.ah.getHausByPlanet(planetName, dreiGradRegelOffset);
        String tkz = this.ah.getTkzByHaus((String)haus).get((int)0).name;
        String herrscherPlanet = Herrscher.getHerrscherPlanet(tkz);
        String herrscherHaus = this.ah.getHausByPlanet(herrscherPlanet, dreiGradRegelOffset);
        this.hrl.add(this.horoskopName, hausId, planetName, tkz, herrscherPlanet, haus);
        if (n < max) {
            this.herrscherIterationPlanetClassic(hausId, herrscherPlanet, n + 1, max, dreiGradRegelOffset);
        }
    }

    private void herrscherIterationPlanetNachRandolf(int hausId, String planetName, int n, int max, int dreiGradRegelOffset) throws IOException {
        if (this.foundSet.contains(planetName)) {
            return;
        }
        this.foundSet.add(planetName);
        String tkz = this.ah.getTkzByPlanet(planetName);
        String herrscherPlanet = Herrscher.getHerrscherPlanet(tkz);
        String herrscherHaus = this.ah.getHausByPlanet(herrscherPlanet, dreiGradRegelOffset);
        this.hrl.add(this.horoskopName, hausId, planetName, tkz, herrscherPlanet, herrscherHaus);
        if (n < max) {
            this.herrscherIterationPlanetNachRandolf(hausId, herrscherPlanet, n + 1, max, dreiGradRegelOffset);
        }
    }

    public HerrscherResultList getHerrscherResultList() {
        return this.hrl;
    }
}

